/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import org.jetbrains.relocated.apache.batik.bridge.AnimatableGenericSVGBridge;
import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.BridgeException;
import org.jetbrains.relocated.apache.batik.bridge.CSSUtilities;
import org.jetbrains.relocated.apache.batik.bridge.ErrorConstants;
import org.jetbrains.relocated.apache.batik.bridge.SVGUtilities;
import org.jetbrains.relocated.apache.batik.bridge.UnitProcessor;
import org.jetbrains.relocated.apache.batik.dom.util.XLinkSupport;
import org.jetbrains.relocated.apache.batik.gvt.text.TextPath;
import org.jetbrains.relocated.apache.batik.parser.AWTPathProducer;
import org.jetbrains.relocated.apache.batik.parser.ParseException;
import org.jetbrains.relocated.apache.batik.parser.PathParser;
import org.jetbrains.relocated.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;

public class SVGTextPathElementBridge
extends AnimatableGenericSVGBridge
implements ErrorConstants {
    @Override
    public String getLocalName() {
        return "textPath";
    }

    @Override
    public void handleElement(BridgeContext ctx2, Element e) {
    }

    public TextPath createTextPath(BridgeContext ctx2, Element textPathElement) {
        String uri = XLinkSupport.getXLinkHref(textPathElement);
        Element pathElement = ctx2.getReferencedElement(textPathElement, uri);
        if (pathElement == null || !"http://www.w3.org/2000/svg".equals(pathElement.getNamespaceURI()) || !pathElement.getLocalName().equals("path")) {
            throw new BridgeException(ctx2, textPathElement, "uri.badTarget", new Object[]{uri});
        }
        String s = pathElement.getAttributeNS(null, "d");
        Shape pathShape = null;
        if (s.length() != 0) {
            AWTPathProducer app = new AWTPathProducer();
            app.setWindingRule(CSSUtilities.convertFillRule(pathElement));
            try {
                PathParser pathParser = new PathParser();
                pathParser.setPathHandler(app);
                pathParser.parse(s);
            }
            catch (ParseException pEx) {
                throw new BridgeException(ctx2, pathElement, pEx, "attribute.malformed", new Object[]{"d"});
            }
            finally {
                pathShape = app.getShape();
            }
        } else {
            throw new BridgeException(ctx2, pathElement, "attribute.missing", new Object[]{"d"});
        }
        s = pathElement.getAttributeNS(null, "transform");
        if (s.length() != 0) {
            AffineTransform tr = SVGUtilities.convertTransform(pathElement, "transform", s, ctx2);
            pathShape = tr.createTransformedShape(pathShape);
        }
        TextPath textPath = new TextPath(new GeneralPath(pathShape));
        s = textPathElement.getAttributeNS(null, "startOffset");
        if (s.length() > 0) {
            float startOffset = 0.0f;
            int percentIndex = s.indexOf(37);
            if (percentIndex != -1) {
                float pathLength = textPath.lengthOfPath();
                String percentString = s.substring(0, percentIndex);
                float startOffsetPercent = 0.0f;
                try {
                    startOffsetPercent = SVGUtilities.convertSVGNumber(percentString);
                }
                catch (NumberFormatException e) {
                    throw new BridgeException(ctx2, textPathElement, "attribute.malformed", new Object[]{"startOffset", s});
                }
                startOffset = (float)((double)(startOffsetPercent * pathLength) / 100.0);
            } else {
                UnitProcessor.Context uctx = UnitProcessor.createContext(ctx2, textPathElement);
                startOffset = UnitProcessor.svgOtherLengthToUserSpace(s, "startOffset", uctx);
            }
            textPath.setStartOffset(startOffset);
        }
        return textPath;
    }
}

