/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.anim.timing;

import java.util.Calendar;
import java.util.LinkedList;
import org.jetbrains.relocated.apache.batik.anim.timing.AccesskeyTimingSpecifier;
import org.jetbrains.relocated.apache.batik.anim.timing.EventbaseTimingSpecifier;
import org.jetbrains.relocated.apache.batik.anim.timing.IndefiniteTimingSpecifier;
import org.jetbrains.relocated.apache.batik.anim.timing.MediaMarkerTimingSpecifier;
import org.jetbrains.relocated.apache.batik.anim.timing.OffsetTimingSpecifier;
import org.jetbrains.relocated.apache.batik.anim.timing.RepeatTimingSpecifier;
import org.jetbrains.relocated.apache.batik.anim.timing.SyncbaseTimingSpecifier;
import org.jetbrains.relocated.apache.batik.anim.timing.TimedElement;
import org.jetbrains.relocated.apache.batik.anim.timing.TimingSpecifier;
import org.jetbrains.relocated.apache.batik.anim.timing.WallclockTimingSpecifier;
import org.jetbrains.relocated.apache.batik.parser.DefaultTimingSpecifierListHandler;
import org.jetbrains.relocated.apache.batik.parser.TimingSpecifierListParser;

public class TimingSpecifierListProducer
extends DefaultTimingSpecifierListHandler {
    protected LinkedList timingSpecifiers = new LinkedList();
    protected TimedElement owner;
    protected boolean isBegin;

    public TimingSpecifierListProducer(TimedElement owner, boolean isBegin) {
        this.owner = owner;
        this.isBegin = isBegin;
    }

    public TimingSpecifier[] getTimingSpecifiers() {
        return this.timingSpecifiers.toArray(new TimingSpecifier[this.timingSpecifiers.size()]);
    }

    public static TimingSpecifier[] parseTimingSpecifierList(TimedElement owner, boolean isBegin, String spec, boolean useSVG11AccessKeys, boolean useSVG12AccessKeys) {
        TimingSpecifierListParser p = new TimingSpecifierListParser(useSVG11AccessKeys, useSVG12AccessKeys);
        TimingSpecifierListProducer pp = new TimingSpecifierListProducer(owner, isBegin);
        p.setTimingSpecifierListHandler(pp);
        p.parse(spec);
        TimingSpecifier[] specs = pp.getTimingSpecifiers();
        return specs;
    }

    @Override
    public void offset(float offset2) {
        OffsetTimingSpecifier ts = new OffsetTimingSpecifier(this.owner, this.isBegin, offset2);
        this.timingSpecifiers.add(ts);
    }

    @Override
    public void syncbase(float offset2, String syncbaseID, String timeSymbol) {
        SyncbaseTimingSpecifier ts = new SyncbaseTimingSpecifier(this.owner, this.isBegin, offset2, syncbaseID, timeSymbol.charAt(0) == 'b');
        this.timingSpecifiers.add(ts);
    }

    @Override
    public void eventbase(float offset2, String eventbaseID, String eventType) {
        EventbaseTimingSpecifier ts = new EventbaseTimingSpecifier(this.owner, this.isBegin, offset2, eventbaseID, eventType);
        this.timingSpecifiers.add(ts);
    }

    @Override
    public void repeat(float offset2, String syncbaseID) {
        RepeatTimingSpecifier ts = new RepeatTimingSpecifier(this.owner, this.isBegin, offset2, syncbaseID);
        this.timingSpecifiers.add(ts);
    }

    @Override
    public void repeat(float offset2, String syncbaseID, int repeatIteration) {
        RepeatTimingSpecifier ts = new RepeatTimingSpecifier(this.owner, this.isBegin, offset2, syncbaseID, repeatIteration);
        this.timingSpecifiers.add(ts);
    }

    @Override
    public void accesskey(float offset2, char key) {
        AccesskeyTimingSpecifier ts = new AccesskeyTimingSpecifier(this.owner, this.isBegin, offset2, key);
        this.timingSpecifiers.add(ts);
    }

    @Override
    public void accessKeySVG12(float offset2, String keyName) {
        AccesskeyTimingSpecifier ts = new AccesskeyTimingSpecifier(this.owner, this.isBegin, offset2, keyName);
        this.timingSpecifiers.add(ts);
    }

    @Override
    public void mediaMarker(String syncbaseID, String markerName) {
        MediaMarkerTimingSpecifier ts = new MediaMarkerTimingSpecifier(this.owner, this.isBegin, syncbaseID, markerName);
        this.timingSpecifiers.add(ts);
    }

    @Override
    public void wallclock(Calendar time) {
        WallclockTimingSpecifier ts = new WallclockTimingSpecifier(this.owner, this.isBegin, time);
        this.timingSpecifiers.add(ts);
    }

    @Override
    public void indefinite() {
        IndefiniteTimingSpecifier ts = new IndefiniteTimingSpecifier(this.owner, this.isBegin);
        this.timingSpecifiers.add(ts);
    }
}

