/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.showImplementations;

import com.intellij.codeInsight.hint.ImplementationViewElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.ImplementationViewElementModel;
import com.jetbrains.rd.ide.model.ImplementationViewNavigateToModel;
import com.jetbrains.rd.ide.model.ImplementationViewSessionModel;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdTextRange;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0014\u0010\u0019\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012R\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0016\u0010$\u001a\u0004\u0018\u00010%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u000200\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102\u00a8\u00063"}, d2={"Lcom/jetbrains/rdclient/showImplementations/FrontendImplementationViewElement;", "Lcom/intellij/codeInsight/hint/ImplementationViewElement;", "project", "Lcom/intellij/openapi/project/Project;", "sessionModel", "Lcom/jetbrains/rd/ide/model/ImplementationViewSessionModel;", "model", "Lcom/jetbrains/rd/ide/model/ImplementationViewElementModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/ide/model/ImplementationViewSessionModel;Lcom/jetbrains/rd/ide/model/ImplementationViewElementModel;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "isNamed", "", "()Z", "name", "", "getName", "()Ljava/lang/String;", "containingFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getContainingFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "text", "getText", "presentableText", "getPresentableText", "locationText", "getLocationText", "locationIcon", "Ljavax/swing/Icon;", "getLocationIcon", "()Ljavax/swing/Icon;", "containingMemberOrSelf", "getContainingMemberOrSelf", "()Lcom/intellij/codeInsight/hint/ImplementationViewElement;", "elementForShowUsages", "Lcom/intellij/psi/PsiElement;", "getElementForShowUsages", "()Lcom/intellij/psi/PsiElement;", "navigate", "", "focusEditor", "range", "Lcom/jetbrains/rd/ide/model/RdTextRange;", "getRange", "()Lcom/jetbrains/rd/ide/model/RdTextRange;", "navigationOffset", "", "getNavigationOffset", "()I", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendImplementationViewSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendImplementationViewSession.kt\ncom/jetbrains/rdclient/showImplementations/FrontendImplementationViewElement\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1#2:249\n*E\n"})
public final class FrontendImplementationViewElement
extends ImplementationViewElement {
    @NotNull
    private final Project project;
    @NotNull
    private final ImplementationViewSessionModel sessionModel;
    @NotNull
    private final ImplementationViewElementModel model;
    @NotNull
    private final RdTextRange range;
    private final int navigationOffset;

    public FrontendImplementationViewElement(@NotNull Project project, @NotNull ImplementationViewSessionModel sessionModel, @NotNull ImplementationViewElementModel model2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.project = project;
        this.sessionModel = sessionModel;
        this.model = model2;
        this.range = new RdTextRange(this.model.getStartOffset(), this.model.getEndOffset() - 1);
        this.navigationOffset = this.model.getNavigationOffset();
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    public boolean isNamed() {
        return true;
    }

    @Nullable
    public String getName() {
        return this.model.getName();
    }

    @Nullable
    public VirtualFile getContainingFile() {
        VirtualFile virtualFile;
        RdDocumentId rdDocumentId = this.model.getContainingFile();
        if (rdDocumentId != null) {
            RdDocumentId it = rdDocumentId;
            boolean bl = false;
            virtualFile = IdeBackend.Companion.getInstance(this.getProject()).findVirtualFile(it);
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    @Nullable
    public String getText() {
        CharSequence charSequence;
        VirtualFile virtualFile = this.getContainingFile();
        if (virtualFile == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null || (charSequence = document.getCharsSequence()) == null) {
            return null;
        }
        CharSequence charSequence2 = charSequence;
        if (this.model.getEndOffset() > charSequence2.length()) {
            return null;
        }
        return ((Object)StringsKt.subSequence((CharSequence)charSequence2, (IntRange)RangesKt.until((int)this.model.getStartOffset(), (int)this.model.getEndOffset()))).toString();
    }

    @NotNull
    public String getPresentableText() {
        return this.model.getPresentableText();
    }

    @Nullable
    public String getLocationText() {
        return this.model.getLocationText();
    }

    @Nullable
    public Icon getLocationIcon() {
        IconModel iconModel = this.model.getLocationIcon();
        return iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null;
    }

    @NotNull
    public ImplementationViewElement getContainingMemberOrSelf() {
        return this;
    }

    @Nullable
    public PsiElement getElementForShowUsages() {
        VirtualFile virtualFile = this.getContainingFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile vFile = virtualFile;
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
        Intrinsics.checkNotNull((Object)psiDocumentManager);
        PsiFile psiFile = DocumentUtilKt.getPsiFile(vFile, fileDocumentManager2, psiDocumentManager);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        return psiFile2.findElementAt(this.model.getNavigationOffset());
    }

    public void navigate(boolean focusEditor) {
        this.sessionModel.getNavigate().fire((Object)new ImplementationViewNavigateToModel(this.model.getId(), focusEditor));
    }

    @NotNull
    public final RdTextRange getRange() {
        return this.range;
    }

    public final int getNavigationOffset() {
        return this.navigationOffset;
    }
}

