/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.IntData;
import org.jetbrains.jetCheck.IntDistribution;
import org.jetbrains.jetCheck.ShrinkStep;
import org.jetbrains.jetCheck.StructureElement;
import org.jetbrains.jetCheck.StructureNode;

class RemoveListRange
extends ShrinkStep {
    private final StructureNode node;
    private final int lastSuccessfulRemove;
    private final int start;
    private final int length;

    static RemoveListRange fromEnd(StructureNode node) {
        int likelyFailingSuffix = node.isIncompleteList() && node.children.size() > 2 ? 1 : 0;
        return new RemoveListRange(node, node.children.size() - likelyFailingSuffix, node.children.size() - likelyFailingSuffix - 1, 1);
    }

    private RemoveListRange(StructureNode node, int lastSuccessfulRemove, int start, int length) {
        this.node = node;
        this.lastSuccessfulRemove = lastSuccessfulRemove;
        this.start = start;
        this.length = length;
        assert (start > 0);
        assert (start + length <= node.children.size());
        assert (lastSuccessfulRemove > 0);
        assert (lastSuccessfulRemove <= node.children.size());
    }

    @Override
    List<?> getEqualityObjects() {
        return Arrays.asList(this.node.id, this.start, this.length);
    }

    @Override
    @Nullable
    StructureNode apply(StructureNode root) {
        IntDistribution lengthDistribution = ((IntData)this.node.children.get((int)0)).distribution;
        int newSize = this.node.children.size() - this.length - 1;
        if (!lengthDistribution.isValidValue(newSize)) {
            return null;
        }
        ArrayList<StructureElement> lessItems = new ArrayList<StructureElement>(newSize + 1);
        lessItems.add(new IntData(this.node.children.get((int)0).id, newSize, lengthDistribution));
        lessItems.addAll(this.node.children.subList(1, this.start));
        lessItems.addAll(this.node.children.subList(this.start + this.length, this.node.children.size()));
        return root.replace(this.node.id, this.node.copyWithChildren(lessItems));
    }

    @Override
    ShrinkStep onFailure() {
        int newEnd;
        if (this.length > 1) {
            int end = this.start + this.length;
            return new RemoveListRange(this.node, this.lastSuccessfulRemove, end - this.length / 2, this.length / 2);
        }
        int n = newEnd = this.start == 1 ? this.node.children.size() : this.start;
        if (newEnd == this.lastSuccessfulRemove) {
            return this.node.shrinkChild(this.node.children.size() - 1);
        }
        return new RemoveListRange(this.node, this.lastSuccessfulRemove, newEnd - 1, 1);
    }

    @Override
    @Nullable
    ShrinkStep onSuccess(StructureNode smallerRoot) {
        if (this.length == this.node.children.size() - 1) {
            return null;
        }
        StructureNode inheritor = (StructureNode)Objects.requireNonNull(smallerRoot.findChildById(this.node.id));
        if (this.start == 1) {
            return RemoveListRange.fromEnd(inheritor);
        }
        int newLength = Math.min(this.length * 2, this.start - 1);
        return new RemoveListRange(inheritor, this.start, this.start - newLength, newLength);
    }

    public String toString() {
        return "RemoveListRange{last=" + this.lastSuccessfulRemove + ", start=" + this.start + ", length=" + this.length + ", node=" + this.node.id + ": " + this.node + '}';
    }
}

