/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.object;

import ca.sqlpower.graph.BreadthFirstSearch;
import ca.sqlpower.graph.GraphModel;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.WorkspaceGraphModelEdge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WorkspaceGraphModel
implements GraphModel<SPObject, WorkspaceGraphModelEdge> {
    private final Set<SPObject> nodes;
    private final Map<SPObject, Set<WorkspaceGraphModelEdge>> inboundEdges;
    private final Map<SPObject, Set<WorkspaceGraphModelEdge>> outboundEdges;
    private final SPObject graphStartNode;

    private WorkspaceGraphModel(Set<SPObject> nodes, Map<SPObject, Set<WorkspaceGraphModelEdge>> inboundEdges, Map<SPObject, Set<WorkspaceGraphModelEdge>> outboundEdges, SPObject graphStartNode) {
        this.nodes = nodes;
        this.inboundEdges = inboundEdges;
        this.outboundEdges = outboundEdges;
        this.graphStartNode = graphStartNode;
    }

    public WorkspaceGraphModel(SPObject root, SPObject graphStartNode, boolean showOnlyDependencies, boolean reversePolarity) {
        this.nodes = new HashSet<SPObject>();
        this.outboundEdges = new HashMap<SPObject, Set<WorkspaceGraphModelEdge>>();
        this.inboundEdges = new HashMap<SPObject, Set<WorkspaceGraphModelEdge>>();
        this.graphStartNode = graphStartNode;
        LinkedList<SPObject> adjacentNodes = new LinkedList<SPObject>();
        HashMap<SPObject, SPObject> childParentMap = new HashMap<SPObject, SPObject>();
        adjacentNodes.add(root);
        while (!adjacentNodes.isEmpty()) {
            SPObject node = (SPObject)adjacentNodes.remove();
            if (this.nodes.contains(node)) continue;
            if (node != root) {
                for (SPObject sPObject : node.getChildren()) {
                    childParentMap.put(sPObject, node);
                }
            }
            ArrayList<SPObject> edgeChildren = new ArrayList<SPObject>();
            edgeChildren.addAll(node.getDependencies());
            edgeChildren.addAll(node.getChildren());
            for (SPObject child : edgeChildren) {
                adjacentNodes.add(child);
                if (showOnlyDependencies && child.getParent() != null && child.getParent().equals(node)) continue;
                SPObject childNode = child;
                SPObject parentNode = node;
                if (reversePolarity) {
                    SPObject temp = parentNode;
                    parentNode = childNode;
                    childNode = temp;
                }
                if (showOnlyDependencies) {
                    while (childParentMap.get(parentNode) != null) {
                        parentNode = (SPObject)childParentMap.get(parentNode);
                    }
                }
                WorkspaceGraphModelEdge edge = new WorkspaceGraphModelEdge(parentNode, childNode);
                Set<WorkspaceGraphModelEdge> childInboundList = this.inboundEdges.get(childNode);
                if (childInboundList == null) {
                    childInboundList = new HashSet<WorkspaceGraphModelEdge>();
                    this.inboundEdges.put(childNode, childInboundList);
                }
                childInboundList.add(edge);
                Set<WorkspaceGraphModelEdge> parentOutboundList = this.outboundEdges.get(parentNode);
                if (parentOutboundList == null) {
                    parentOutboundList = new HashSet<WorkspaceGraphModelEdge>();
                    this.outboundEdges.put(parentNode, parentOutboundList);
                }
                parentOutboundList.add(edge);
            }
            if (!showOnlyDependencies) {
                this.nodes.add(node);
                continue;
            }
            if (childParentMap.containsKey(node) && this.inboundEdges.get(node) == null && this.outboundEdges.get(node) == null) continue;
            this.nodes.add(node);
        }
        BreadthFirstSearch<SPObject, WorkspaceGraphModelEdge> bfs = new BreadthFirstSearch<SPObject, WorkspaceGraphModelEdge>();
        List<SPObject> connectedObjects = bfs.performSearch(this, graphStartNode);
        ArrayList<SPObject> arrayList = new ArrayList<SPObject>();
        for (SPObject node : this.nodes) {
            if (connectedObjects.contains(node)) continue;
            arrayList.add(node);
        }
        this.nodes.removeAll(arrayList);
        for (SPObject removedNode : arrayList) {
            this.inboundEdges.remove(removedNode);
            if (this.outboundEdges.get(removedNode) != null) {
                for (WorkspaceGraphModelEdge edge : this.outboundEdges.get(removedNode)) {
                    if (this.inboundEdges.get(edge.getChild()) == null) continue;
                    this.inboundEdges.get(edge.getChild()).remove(edge);
                }
            }
            this.outboundEdges.remove(removedNode);
        }
    }

    @Override
    public Collection<SPObject> getAdjacentNodes(SPObject node) {
        HashSet<SPObject> adjacentNodes = new HashSet<SPObject>();
        Set<WorkspaceGraphModelEdge> edges = this.outboundEdges.get(node);
        if (edges == null) {
            return Collections.emptySet();
        }
        for (WorkspaceGraphModelEdge edge : edges) {
            adjacentNodes.add(edge.getChild());
        }
        return adjacentNodes;
    }

    @Override
    public Collection<WorkspaceGraphModelEdge> getEdges() {
        HashSet<WorkspaceGraphModelEdge> allEdges = new HashSet<WorkspaceGraphModelEdge>();
        for (Set<WorkspaceGraphModelEdge> edges : this.inboundEdges.values()) {
            if (edges == null) continue;
            allEdges.addAll(edges);
        }
        return allEdges;
    }

    @Override
    public Collection<WorkspaceGraphModelEdge> getInboundEdges(SPObject node) {
        Set<WorkspaceGraphModelEdge> edges = this.inboundEdges.get(node);
        if (edges == null) {
            return Collections.emptyList();
        }
        return edges;
    }

    @Override
    public Collection<SPObject> getNodes() {
        return this.nodes;
    }

    @Override
    public Collection<WorkspaceGraphModelEdge> getOutboundEdges(SPObject node) {
        Set<WorkspaceGraphModelEdge> edges = this.outboundEdges.get(node);
        if (edges == null) {
            return Collections.emptyList();
        }
        return edges;
    }

    public SPObject getGraphStartNode() {
        return this.graphStartNode;
    }

    public WorkspaceGraphModel invert() {
        HashMap<SPObject, Set<WorkspaceGraphModelEdge>> invertedInboundEdges = new HashMap<SPObject, Set<WorkspaceGraphModelEdge>>();
        for (Map.Entry<SPObject, Set<WorkspaceGraphModelEdge>> entry : this.inboundEdges.entrySet()) {
            HashSet<WorkspaceGraphModelEdge> edges = new HashSet<WorkspaceGraphModelEdge>();
            for (WorkspaceGraphModelEdge edge : entry.getValue()) {
                edges.add(new WorkspaceGraphModelEdge(edge.getChild(), edge.getParent()));
            }
            invertedInboundEdges.put(entry.getKey(), edges);
        }
        HashMap<SPObject, Set<WorkspaceGraphModelEdge>> invertedOutboundEdges = new HashMap<SPObject, Set<WorkspaceGraphModelEdge>>();
        for (Map.Entry<SPObject, Set<WorkspaceGraphModelEdge>> entry : this.outboundEdges.entrySet()) {
            HashSet<WorkspaceGraphModelEdge> edges = new HashSet<WorkspaceGraphModelEdge>();
            for (WorkspaceGraphModelEdge edge : entry.getValue()) {
                edges.add(new WorkspaceGraphModelEdge(edge.getChild(), edge.getParent()));
            }
            invertedOutboundEdges.put(entry.getKey(), edges);
        }
        return new WorkspaceGraphModel(this.nodes, invertedOutboundEdges, invertedInboundEdges, this.graphStartNode);
    }
}

