/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class V680ProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().groupBegin().number("#(d+)#").expression("([^#]*)#").groupEnd("?").number("(d+)#").expression("([^#]+)#").expression("([^#]+)#").number("(d+)#").expression("([^#]+)?#?").expression("(?:[^#]+#)?").number("(d+.d+),([EW]),").number("(d+.d+),([NS]),").number("(d+.d+),").number("(d+.?d*)?#").number("(dd)(dd)(dd)#").number("(dd)(dd)(dd)").any().compile();

    public V680ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if ((sentence = sentence.trim()).length() != 16) {
            Parser parser = new Parser(PATTERN, sentence);
            if (!parser.matches()) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            DeviceSession deviceSession = parser.hasNext() ? this.getDeviceSession(channel, remoteAddress, parser.next()) : this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            position.setDeviceId(deviceSession.getDeviceId());
            position.set("user", parser.next());
            position.setValid(parser.nextInt(0) > 0);
            position.set("password", parser.next());
            position.set("event", parser.next());
            position.set("packet", parser.next());
            position.set("lbsData", parser.next());
            double lon = parser.nextDouble(0.0);
            boolean west = parser.next().equals("W");
            double lat = parser.nextDouble(0.0);
            boolean south = parser.next().equals("S");
            if (lat > 90.0 || lon > 180.0) {
                int lonDegrees = (int)(lon * 0.01);
                lon = (lon - (double)(lonDegrees * 100)) / 60.0;
                lon += (double)lonDegrees;
                int latDegrees = (int)(lat * 0.01);
                lat = (lat - (double)(latDegrees * 100)) / 60.0;
                lat += (double)latDegrees;
            }
            position.setLongitude(west ? -lon : lon);
            position.setLatitude(south ? -lat : lat);
            position.setSpeed(parser.nextDouble(0.0));
            position.setCourse(parser.nextDouble(0.0));
            int day = parser.nextInt(0);
            int month = parser.nextInt(0);
            if (day == 0 && month == 0) {
                return null;
            }
            DateBuilder dateBuilder = new DateBuilder().setDate(parser.nextInt(0), month, day).setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
            position.setTime(dateBuilder.getDate());
            return position;
        }
        this.getDeviceSession(channel, remoteAddress, sentence.substring(1));
        return null;
    }
}

