/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.model.Command;

public class PretraceProtocolEncoder
extends BaseProtocolEncoder {
    public PretraceProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private String formatCommand(String uniqueId, String data) {
        String content = uniqueId + data;
        return String.format("(%s^%02X)", content, Checksum.xor(content));
    }

    @Override
    protected Object encodeCommand(Command command) {
        String uniqueId = this.getUniqueId(command.getDeviceId());
        return switch (command.getType()) {
            case "custom" -> this.formatCommand(uniqueId, command.getString("data"));
            case "positionPeriodic" -> this.formatCommand(uniqueId, String.format("D221%1$d,%1$d,,", command.getInteger("frequency")));
            default -> null;
        };
    }
}

