/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.traccar.BaseFrameDecoder;
import org.traccar.NetworkMessage;

public class At2000FrameDecoder
extends BaseFrameDecoder {
    private static final int BLOCK_LENGTH = 16;
    private static final int ACK_LENGTH = 496;
    private boolean firstPacket = true;
    private ByteBuf currentBuffer;
    private int acknowledgedBytes;

    private void sendResponse(Channel channel) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer((int)32);
            response.writeByte(0);
            response.writeMedium(1);
            response.writeByte(0);
            response.writerIndex(32);
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        int length;
        if (buf.readableBytes() < 5) {
            return null;
        }
        if (this.firstPacket) {
            this.firstPacket = false;
            length = buf.getUnsignedMediumLE(buf.readerIndex() + 2);
        } else {
            length = buf.getUnsignedMediumLE(buf.readerIndex() + 1);
        }
        if ((length += 16) % 16 != 0) {
            length = (length / 16 + 1) * 16;
        }
        if (!(buf.readableBytes() < length && buf.readableBytes() % 496 != 0 || buf == this.currentBuffer && buf.readableBytes() <= this.acknowledgedBytes)) {
            this.sendResponse(channel);
            this.currentBuffer = buf;
            this.acknowledgedBytes = buf.readableBytes();
        }
        if (buf.readableBytes() >= length) {
            return buf.readRetainedSlice(length);
        }
        return null;
    }
}

