/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import jakarta.inject.Inject;
import java.util.Date;
import org.traccar.handler.BasePositionHandler;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

public class OutdatedHandler
extends BasePositionHandler {
    private final CacheManager cacheManager;

    @Inject
    public OutdatedHandler(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void onPosition(Position position, BasePositionHandler.Callback callback) {
        if (position.getOutdated()) {
            Position last = this.cacheManager.getPosition(position.getDeviceId());
            if (last != null) {
                position.setFixTime(last.getFixTime());
                position.setValid(last.getValid());
                position.setLatitude(last.getLatitude());
                position.setLongitude(last.getLongitude());
                position.setAltitude(last.getAltitude());
                position.setSpeed(last.getSpeed());
                position.setCourse(last.getCourse());
                position.setAccuracy(last.getAccuracy());
            } else {
                position.setFixTime(new Date(315964819000L));
            }
            if (position.getDeviceTime() == null) {
                position.setDeviceTime(position.getServerTime());
            }
        }
        callback.processed(false);
    }
}

