/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.List;
import org.eclipse.jetty.websocket.server.JettyWebSocketServlet;
import org.eclipse.jetty.websocket.server.JettyWebSocketServletFactory;
import org.traccar.api.AsyncSocket;
import org.traccar.api.security.LoginService;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.session.ConnectionManager;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;

@Singleton
public class AsyncSocketServlet
extends JettyWebSocketServlet {
    private final Config config;
    private final ObjectMapper objectMapper;
    private final ConnectionManager connectionManager;
    private final Storage storage;
    private final LoginService loginService;

    @Inject
    public AsyncSocketServlet(Config config, ObjectMapper objectMapper, ConnectionManager connectionManager, Storage storage, LoginService loginService) {
        this.config = config;
        this.objectMapper = objectMapper;
        this.connectionManager = connectionManager;
        this.storage = storage;
        this.loginService = loginService;
    }

    public void configure(JettyWebSocketServletFactory factory) {
        factory.setIdleTimeout(Duration.ofMillis(this.config.getLong(Keys.WEB_TIMEOUT)));
        factory.setCreator((req, resp) -> {
            Long userId = null;
            List tokens = (List)req.getParameterMap().get("token");
            if (tokens != null && !tokens.isEmpty()) {
                String token = (String)tokens.iterator().next();
                try {
                    userId = this.loginService.login(token).getUser().getId();
                }
                catch (IOException | GeneralSecurityException | StorageException e) {
                    throw new RuntimeException(e);
                }
            } else if (req.getSession() != null) {
                userId = (Long)((HttpSession)req.getSession()).getAttribute("userId");
            }
            if (userId != null) {
                return new AsyncSocket(this.objectMapper, this.connectionManager, this.storage, userId);
            }
            return null;
        });
    }
}

