/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.policyeditor;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.jnlp.security.policyeditor.CustomPermission;
import net.sourceforge.jnlp.security.policyeditor.InvalidPolicyException;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditorPermissions;

public class PolicyEntry {
    private final String codebase;
    private final Set<PolicyEditorPermissions> permissions = new HashSet<PolicyEditorPermissions>();
    private final Set<CustomPermission> customPermissions = new HashSet<CustomPermission>();

    public PolicyEntry(String codebase, Collection<PolicyEditorPermissions> permissions, Collection<CustomPermission> customPermissions) {
        this.codebase = codebase == null ? "" : codebase;
        this.permissions.addAll(permissions);
        this.permissions.remove(null);
        this.customPermissions.addAll(customPermissions);
        this.customPermissions.remove(null);
    }

    public String getCodebase() {
        return this.codebase;
    }

    public Set<PolicyEditorPermissions> getPermissions() {
        return this.permissions;
    }

    public Set<CustomPermission> getCustomPermissions() {
        return this.customPermissions;
    }

    public static PolicyEntry fromString(String contents) throws InvalidPolicyException {
        List<String> lines = Arrays.asList(contents.split("\\r?\\n+"));
        if (!PolicyEntry.validatePolicy(lines)) {
            throw new InvalidPolicyException();
        }
        String codebase = "";
        HashSet<PolicyEditorPermissions> permissions = new HashSet<PolicyEditorPermissions>();
        HashSet<CustomPermission> customPermissions = new HashSet<CustomPermission>();
        boolean openBlock = false;
        boolean commentBlock = false;
        for (String line : lines) {
            Pattern openBlockPattern = Pattern.compile("grant\\s*\"?\\s*(?:codeBase)?\\s*\"?([^\"\\s]*)\"?\\s*\\{");
            Matcher openBlockMatcher = openBlockPattern.matcher(line);
            if (openBlockMatcher.matches()) {
                codebase = openBlockMatcher.group(1);
                openBlock = true;
                continue;
            }
            boolean commentLine = false;
            if (line.matches("\\s*\\};\\s*")) {
                openBlock = false;
            }
            if (line.matches(".*/\\*.*")) {
                commentBlock = true;
            }
            if (line.matches(".*\\*/.*")) {
                commentBlock = false;
            }
            if (line.matches(".*/\\*.*") && line.matches(".*\\*/.*")) {
                commentLine = true;
            }
            if (line.matches("\\s*//.*")) {
                commentLine = true;
            }
            if (!openBlock || commentBlock || commentLine) continue;
            PolicyEditorPermissions perm = PolicyEditorPermissions.fromString(line);
            if (perm != null) {
                permissions.add(perm);
                continue;
            }
            CustomPermission cPerm = CustomPermission.fromString(line.trim());
            if (cPerm == null) continue;
            customPermissions.add(cPerm);
        }
        return new PolicyEntry(codebase, permissions, customPermissions);
    }

    public static boolean validatePolicy(String content) {
        return PolicyEntry.validatePolicy(Arrays.asList(content.split("\\r?\\n")));
    }

    public static boolean validatePolicy(List<String> lines) {
        int openerCount = 0;
        int closerCount = 0;
        for (String line : lines) {
            Pattern openBlockPattern = Pattern.compile("grant\\s*\"?\\s*(?:codeBase)?\\s*\"?([^\"\\s]*)\"?\\s*\\{");
            Matcher openBlockMatcher = openBlockPattern.matcher(line);
            if (openBlockMatcher.matches()) {
                ++openerCount;
            }
            if (!line.matches("\\s*\\};\\s*")) continue;
            ++closerCount;
        }
        return openerCount == 1 && closerCount == 1;
    }

    public String toString() {
        if (this.codebase.isEmpty() && this.permissions.isEmpty() && this.customPermissions.isEmpty()) {
            return "";
        }
        String newline = System.getProperty("line.separator");
        StringBuilder result = new StringBuilder();
        result.append(newline);
        result.append("grant");
        if (!this.codebase.isEmpty()) {
            result.append(" codeBase \"");
            result.append(this.codebase);
            result.append("\"");
        }
        result.append(" {");
        result.append(newline);
        for (PolicyEditorPermissions perm : this.permissions) {
            result.append("\t");
            result.append(perm.toPermissionString());
            result.append(newline);
        }
        for (CustomPermission customPerm : this.customPermissions) {
            result.append("\t");
            result.append(customPerm.toString().trim());
            result.append(newline);
        }
        result.append("};");
        result.append(newline);
        return result.toString();
    }
}

