/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.cluster.AbstractDiffable;
import org.opensearch.cluster.metadata.IndexTemplateMetadata;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.translog.BufferedChecksumStreamOutput;

@PublicApi(since="2.15.0")
public class TemplatesMetadata
extends AbstractDiffable<TemplatesMetadata>
implements ToXContentFragment {
    public static TemplatesMetadata EMPTY_METADATA = TemplatesMetadata.builder().build();
    private final Map<String, IndexTemplateMetadata> templates;

    public TemplatesMetadata() {
        this(Collections.emptyMap());
    }

    public TemplatesMetadata(Map<String, IndexTemplateMetadata> templates) {
        this.templates = Collections.unmodifiableMap(templates);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, IndexTemplateMetadata> getTemplates() {
        return this.templates;
    }

    public static TemplatesMetadata fromXContent(XContentParser parser) throws IOException {
        return Builder.fromXContent(parser);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Builder.toXContent(this, builder, params);
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.templates.size());
        for (IndexTemplateMetadata cursor : this.templates.values()) {
            cursor.writeTo(out);
        }
    }

    public void writeVerifiableTo(BufferedChecksumStreamOutput out) throws IOException {
        out.writeMapValues(this.templates, (stream, value) -> value.writeVerifiableTo((BufferedChecksumStreamOutput)stream));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplatesMetadata that = (TemplatesMetadata)o;
        return Objects.equals(this.templates, that.templates);
    }

    public int hashCode() {
        return this.templates != null ? this.templates.hashCode() : 0;
    }

    public String toString() {
        return "TemplatesMetadata{templates=" + String.valueOf(this.templates) + "}";
    }

    @PublicApi(since="2.15.0")
    public static class Builder {
        private final Map<String, IndexTemplateMetadata> templates;

        public Builder() {
            this.templates = new HashMap<String, IndexTemplateMetadata>();
        }

        public Builder(Map<String, IndexTemplateMetadata> templates) {
            this.templates = templates;
        }

        public Builder put(IndexTemplateMetadata.Builder templateBuilder) {
            return this.put(templateBuilder.build());
        }

        public Builder put(IndexTemplateMetadata template) {
            this.templates.put(template.name(), template);
            return this;
        }

        public Builder removeTemplate(String templateName) {
            this.templates.remove(templateName);
            return this;
        }

        public Builder templates(Map<String, IndexTemplateMetadata> templates) {
            this.templates.putAll(templates);
            return this;
        }

        public TemplatesMetadata build() {
            return new TemplatesMetadata(this.templates);
        }

        public static void toXContent(TemplatesMetadata templatesMetadata, XContentBuilder builder, ToXContent.Params params) throws IOException {
            for (IndexTemplateMetadata cursor : templatesMetadata.getTemplates().values()) {
                IndexTemplateMetadata.Builder.toXContentWithTypes(cursor, builder, params);
            }
        }

        public static TemplatesMetadata fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder();
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (currentFieldName == null) {
                token = parser.nextToken();
            }
            if (token == XContentParser.Token.START_OBJECT) {
                token = parser.nextToken();
            }
            if (parser.currentName() != null && token != XContentParser.Token.END_OBJECT) {
                do {
                    builder.put(IndexTemplateMetadata.Builder.fromXContent(parser, parser.currentName()));
                } while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT);
            }
            return builder.build();
        }
    }
}

