/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.util.DocIdSetBuilder;
import org.opensearch.knn.index.query.PerLeafResult;

public final class ResultUtil {
    public static void reduceToTopK(List<PerLeafResult> perLeafResults, int k) {
        PriorityQueue<Float> topKMinQueue = new PriorityQueue<Float>(k);
        int count = 0;
        for (PerLeafResult perLeafResult : perLeafResults) {
            count += perLeafResult.getResult().size();
            for (Float score : perLeafResult.getResult().values()) {
                if (topKMinQueue.size() < k) {
                    topKMinQueue.add(score);
                    continue;
                }
                if (topKMinQueue.peek() == null || !(score.floatValue() > ((Float)topKMinQueue.peek()).floatValue())) continue;
                topKMinQueue.poll();
                topKMinQueue.add(score);
            }
        }
        if (count <= k) {
            return;
        }
        float minScore = topKMinQueue.peek() == null ? -3.4028235E38f : ((Float)topKMinQueue.peek()).floatValue();
        perLeafResults.forEach(results -> results.getResult().entrySet().removeIf(entry -> ((Float)entry.getValue()).floatValue() < minScore));
    }

    public static DocIdSetIterator resultMapToDocIds(Map<Integer, Float> resultMap) throws IOException {
        if (resultMap.isEmpty()) {
            return DocIdSetIterator.empty();
        }
        int maxDoc = Collections.max(resultMap.keySet()) + 1;
        return ResultUtil.resultMapToDocIds(resultMap, maxDoc);
    }

    public static DocIdSetIterator resultMapToDocIds(Map<Integer, Float> resultMap, int maxDoc) throws IOException {
        if (resultMap.isEmpty()) {
            return DocIdSetIterator.empty();
        }
        DocIdSetBuilder docIdSetBuilder = new DocIdSetBuilder(maxDoc);
        DocIdSetBuilder.BulkAdder setAdder = docIdSetBuilder.grow(resultMap.size());
        resultMap.keySet().forEach(arg_0 -> ((DocIdSetBuilder.BulkAdder)setAdder).add(arg_0));
        return docIdSetBuilder.build().iterator();
    }

    public static TopDocs resultMapToTopDocs(Map<Integer, Float> resultMap, int segmentOffset) {
        if (resultMap.isEmpty()) {
            return new TopDocs(new TotalHits(0L, TotalHits.Relation.EQUAL_TO), new ScoreDoc[0]);
        }
        int totalHits = 0;
        ArrayList<ScoreDoc> scoreDocs = new ArrayList<ScoreDoc>();
        ArrayList<Map.Entry<Integer, Float>> topScores = new ArrayList<Map.Entry<Integer, Float>>(resultMap.entrySet());
        topScores.sort(Map.Entry.comparingByValue().reversed());
        for (Map.Entry entry : topScores) {
            ScoreDoc scoreDoc = new ScoreDoc((Integer)entry.getKey() + segmentOffset, ((Float)entry.getValue()).floatValue());
            scoreDocs.add(scoreDoc);
            ++totalHits;
        }
        return new TopDocs(new TotalHits((long)totalHits, TotalHits.Relation.EQUAL_TO), (ScoreDoc[])scoreDocs.toArray(ScoreDoc[]::new));
    }
}

