/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.common.ValidationException;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.knn.common.KNNValidationUtil;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.VectorQueryType;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.KNNLibrarySearchContext;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.engine.model.QueryContext;
import org.opensearch.knn.index.engine.qframe.QuantizationConfig;
import org.opensearch.knn.index.engine.validation.ParameterValidator;
import org.opensearch.knn.index.mapper.KNNMappingConfig;
import org.opensearch.knn.index.mapper.KNNVectorFieldType;
import org.opensearch.knn.index.query.BaseQueryFactory;
import org.opensearch.knn.index.query.KNNQueryFactory;
import org.opensearch.knn.index.query.RNNQueryFactory;
import org.opensearch.knn.index.query.parser.KNNQueryBuilderParser;
import org.opensearch.knn.index.query.parser.MethodParametersParser;
import org.opensearch.knn.index.query.parser.RescoreParser;
import org.opensearch.knn.index.query.rescore.RescoreContext;
import org.opensearch.knn.index.util.IndexUtil;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.knn.indices.ModelMetadata;
import org.opensearch.knn.indices.ModelUtil;

public class KNNQueryBuilder
extends AbstractQueryBuilder<KNNQueryBuilder> {
    @Generated
    private static final Logger log = LogManager.getLogger(KNNQueryBuilder.class);
    private static ModelDao modelDao;
    public static final ParseField VECTOR_FIELD;
    public static final ParseField K_FIELD;
    public static final ParseField FILTER_FIELD;
    public static final ParseField IGNORE_UNMAPPED_FIELD;
    public static final ParseField EXPAND_NESTED_FIELD;
    public static final ParseField MAX_DISTANCE_FIELD;
    public static final ParseField MIN_SCORE_FIELD;
    public static final ParseField EF_SEARCH_FIELD;
    public static final ParseField NPROBE_FIELD;
    public static final ParseField METHOD_PARAMS_FIELD;
    public static final ParseField RESCORE_FIELD;
    public static final ParseField RESCORE_OVERSAMPLE_FIELD;
    public static final int K_MAX = 10000;
    public static final String NAME = "knn";
    private final String fieldName;
    private final float[] vector;
    private int k;
    private Float maxDistance;
    private Float minScore;
    private Map<String, ?> methodParameters;
    private QueryBuilder filter;
    private boolean ignoreUnmapped;
    private RescoreContext rescoreContext;
    private Boolean expandNested;

    @Deprecated
    public KNNQueryBuilder(String fieldName, float[] vector) {
        if (Strings.isNullOrEmpty((String)fieldName)) {
            throw new IllegalArgumentException(String.format("[%s] requires fieldName", NAME));
        }
        if (vector == null) {
            throw new IllegalArgumentException(String.format("[%s] requires query vector", NAME));
        }
        if (vector.length == 0) {
            throw new IllegalArgumentException(String.format("[%s] query vector is empty", NAME));
        }
        this.fieldName = fieldName;
        this.vector = vector;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public KNNQueryBuilder(String fieldName, float[] vector, int k) {
        this(fieldName, vector, k, null);
    }

    @Deprecated
    public KNNQueryBuilder(String fieldName, float[] vector, int k, QueryBuilder filter) {
        if (Strings.isNullOrEmpty((String)fieldName)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] requires fieldName", NAME));
        }
        if (vector == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] requires query vector", NAME));
        }
        if (vector.length == 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] query vector is empty", NAME));
        }
        if (k <= 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] requires k > 0", NAME));
        }
        if (k > 10000) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] requires k <= %d", NAME, 10000));
        }
        this.fieldName = fieldName;
        this.vector = vector;
        this.k = k;
        this.filter = filter;
        this.ignoreUnmapped = false;
        this.maxDistance = null;
        this.minScore = null;
        this.rescoreContext = null;
        this.expandNested = null;
    }

    public static void initialize(ModelDao modelDao) {
        KNNQueryBuilder.modelDao = modelDao;
    }

    public KNNQueryBuilder(StreamInput in) throws IOException {
        super(in);
        Builder builder = KNNQueryBuilderParser.streamInput(in, IndexUtil::isClusterOnOrAfterMinRequiredVersion);
        this.fieldName = builder.fieldName;
        this.vector = builder.vector;
        this.k = builder.k;
        this.filter = builder.filter;
        this.ignoreUnmapped = builder.ignoreUnmapped;
        this.maxDistance = builder.maxDistance;
        this.minScore = builder.minScore;
        this.methodParameters = builder.methodParameters;
        this.rescoreContext = builder.rescoreContext;
        this.expandNested = builder.expandNested;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        KNNQueryBuilderParser.streamOutput(out, this, IndexUtil::isClusterOnOrAfterMinRequiredVersion);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Object vector() {
        return this.vector;
    }

    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        KNNQueryBuilderParser.toXContent(builder, params, this);
    }

    protected Query doToQuery(QueryShardContext context) {
        int vectorLength;
        QueryContext queryContext;
        KNNLibrarySearchContext engineSpecificMethodContext;
        ValidationException validationException;
        String method;
        MappedFieldType mappedFieldType = context.fieldMapper(this.fieldName);
        if (mappedFieldType == null && this.ignoreUnmapped) {
            return new MatchNoDocsQuery();
        }
        if (!(mappedFieldType instanceof KNNVectorFieldType)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Field '%s' is not knn_vector type.", this.fieldName));
        }
        KNNVectorFieldType knnVectorFieldType = (KNNVectorFieldType)mappedFieldType;
        KNNMappingConfig knnMappingConfig = knnVectorFieldType.getKnnMappingConfig();
        AtomicReference queryConfigFromMapping = new AtomicReference();
        int fieldDimension = knnMappingConfig.getDimension();
        knnMappingConfig.getKnnMethodContext().ifPresentOrElse(knnMethodContext -> queryConfigFromMapping.set(new QueryConfigFromMapping(knnMethodContext.getKnnEngine(), knnMethodContext.getMethodComponentContext(), knnMethodContext.getSpaceType(), knnVectorFieldType.getVectorDataType())), () -> knnMappingConfig.getModelId().ifPresentOrElse(modelId -> {
            ModelMetadata modelMetadata = this.getModelMetadataForField((String)modelId);
            queryConfigFromMapping.set(new QueryConfigFromMapping(modelMetadata.getKnnEngine(), modelMetadata.getMethodComponentContext(), modelMetadata.getSpaceType(), modelMetadata.getVectorDataType()));
        }, () -> {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Field '%s' is not built for ANN search.", this.fieldName));
        }));
        KNNEngine knnEngine = ((QueryConfigFromMapping)queryConfigFromMapping.get()).getKnnEngine();
        MethodComponentContext methodComponentContext = ((QueryConfigFromMapping)queryConfigFromMapping.get()).getMethodComponentContext();
        SpaceType spaceType = ((QueryConfigFromMapping)queryConfigFromMapping.get()).getSpaceType();
        VectorDataType vectorDataType = ((QueryConfigFromMapping)queryConfigFromMapping.get()).getVectorDataType();
        RescoreContext processedRescoreContext = knnVectorFieldType.resolveRescoreContext(this.rescoreContext);
        knnVectorFieldType.transformQueryVector(this.vector);
        VectorQueryType vectorQueryType = this.getVectorQueryType(this.k, this.maxDistance, this.minScore);
        this.updateQueryStats(vectorQueryType);
        String string = method = methodComponentContext != null ? methodComponentContext.getName() : null;
        if (StringUtils.isNotBlank((String)method) && (validationException = ParameterValidator.validateParameters((engineSpecificMethodContext = knnEngine.getKNNLibrarySearchContext(method)).supportedMethodParameters(queryContext = new QueryContext(vectorQueryType)), this.methodParameters, KNNMethodConfigContext.EMPTY)) != null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Parameters not valid for [%s]:[%s]:[%s] combination: [%s]", knnEngine, method, vectorQueryType.getQueryTypeName(), validationException.getMessage()));
        }
        if (this.maxDistance != null || this.minScore != null) {
            if (!KNNEngine.ENGINES_SUPPORTING_RADIAL_SEARCH.contains(knnEngine)) {
                throw new UnsupportedOperationException(String.format(Locale.ROOT, "Engine [%s] does not support radial search", knnEngine));
            }
            if (vectorDataType == VectorDataType.BINARY) {
                throw new UnsupportedOperationException(String.format(Locale.ROOT, "Binary data type does not support radial search", new Object[0]));
            }
            if (knnMappingConfig.getQuantizationConfig() != QuantizationConfig.EMPTY) {
                throw new UnsupportedOperationException("Radial search is not supported for indices which have quantization enabled");
            }
        }
        Float radius = null;
        if (this.maxDistance != null) {
            if (this.maxDistance.floatValue() < 0.0f && !SpaceType.INNER_PRODUCT.equals((Object)spaceType)) {
                throw new IllegalArgumentException(String.format("[knn] requires distance to be non-negative for space type: %s", new Object[]{spaceType}));
            }
            radius = knnEngine.distanceToRadialThreshold(this.maxDistance, spaceType);
        }
        if (this.minScore != null) {
            if (this.minScore.floatValue() > 1.0f && !SpaceType.INNER_PRODUCT.equals((Object)spaceType)) {
                throw new IllegalArgumentException(String.format("[knn] requires score to be in the range [0, 1] for space type: %s", new Object[]{spaceType}));
            }
            radius = knnEngine.scoreToRadialThreshold(this.minScore, spaceType);
        }
        int n = vectorLength = VectorDataType.BINARY == vectorDataType ? this.vector.length * 8 : this.vector.length;
        if (fieldDimension != vectorLength) {
            throw new IllegalArgumentException(String.format("Query vector has invalid dimension: %d. Dimension should be: %d", vectorLength, fieldDimension));
        }
        byte[] byteVector = new byte[]{};
        switch (vectorDataType) {
            case BINARY: {
                byteVector = new byte[this.vector.length];
                for (int i = 0; i < this.vector.length; ++i) {
                    KNNValidationUtil.validateByteVectorValue(this.vector[i], knnVectorFieldType.getVectorDataType());
                    byteVector[i] = (byte)this.vector[i];
                }
                spaceType.validateVector(byteVector);
                break;
            }
            case BYTE: {
                if (KNNEngine.LUCENE == knnEngine) {
                    byteVector = new byte[this.vector.length];
                    for (int i = 0; i < this.vector.length; ++i) {
                        KNNValidationUtil.validateByteVectorValue(this.vector[i], knnVectorFieldType.getVectorDataType());
                        byteVector[i] = (byte)this.vector[i];
                    }
                    spaceType.validateVector(byteVector);
                    break;
                }
                for (float v : this.vector) {
                    KNNValidationUtil.validateByteVectorValue(v, knnVectorFieldType.getVectorDataType());
                }
                spaceType.validateVector(this.vector);
                break;
            }
            default: {
                spaceType.validateVector(this.vector);
            }
        }
        if (KNNEngine.getEnginesThatCreateCustomSegmentFiles().contains(knnEngine) && this.filter != null && !KNNEngine.getEnginesThatSupportsFilters().contains(knnEngine)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Engine [%s] does not support filters", knnEngine));
        }
        String indexName = context.index().getName();
        if (this.k != 0) {
            BaseQueryFactory.CreateQueryRequest createQueryRequest = BaseQueryFactory.CreateQueryRequest.builder().knnEngine(knnEngine).indexName(indexName).fieldName(this.fieldName).vector(this.getVectorForCreatingQueryRequest(vectorDataType, knnEngine)).byteVector(this.getVectorForCreatingQueryRequest(vectorDataType, knnEngine, byteVector)).vectorDataType(vectorDataType).k(this.k).methodParameters(this.methodParameters).filter(this.filter).context(context).rescoreContext(processedRescoreContext).expandNested(this.expandNested).build();
            return KNNQueryFactory.create(createQueryRequest);
        }
        if (radius != null) {
            BaseQueryFactory.CreateQueryRequest createQueryRequest = BaseQueryFactory.CreateQueryRequest.builder().knnEngine(knnEngine).indexName(indexName).fieldName(this.fieldName).vector(VectorDataType.FLOAT == vectorDataType ? this.vector : null).byteVector((byte[])(VectorDataType.BYTE == vectorDataType ? byteVector : null)).vectorDataType(vectorDataType).radius(radius).methodParameters(this.methodParameters).filter(this.filter).context(context).build();
            return RNNQueryFactory.create(createQueryRequest);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] requires k or distance or score to be set", NAME));
    }

    private ModelMetadata getModelMetadataForField(String modelId) {
        ModelMetadata modelMetadata = modelDao.getMetadata(modelId);
        if (!ModelUtil.isModelCreated(modelMetadata)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Model ID '%s' is not created.", modelId));
        }
        return modelMetadata;
    }

    private VectorQueryType getVectorQueryType(int k, Float maxDistance, Float minScore) {
        if (maxDistance != null) {
            return VectorQueryType.MAX_DISTANCE;
        }
        if (minScore != null) {
            return VectorQueryType.MIN_SCORE;
        }
        if (k != 0) {
            return VectorQueryType.K;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] requires exactly one of k, distance or score to be set", NAME));
    }

    private void updateQueryStats(VectorQueryType vectorQueryType) {
        vectorQueryType.getQueryStatCounter().increment();
        if (this.filter != null) {
            vectorQueryType.getQueryWithFilterStatCounter().increment();
        }
    }

    private float[] getVectorForCreatingQueryRequest(VectorDataType vectorDataType, KNNEngine knnEngine) {
        if (VectorDataType.FLOAT == vectorDataType || VectorDataType.BYTE == vectorDataType && KNNEngine.FAISS == knnEngine) {
            return this.vector;
        }
        return null;
    }

    private byte[] getVectorForCreatingQueryRequest(VectorDataType vectorDataType, KNNEngine knnEngine, byte[] byteVector) {
        if (VectorDataType.BINARY == vectorDataType || VectorDataType.BYTE == vectorDataType && KNNEngine.LUCENE == knnEngine) {
            return byteVector;
        }
        return null;
    }

    protected boolean doEquals(KNNQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Arrays.equals(this.vector, other.vector) && Objects.equals(this.k, other.k) && Objects.equals(this.minScore, other.minScore) && Objects.equals(this.maxDistance, other.maxDistance) && Objects.equals(this.methodParameters, other.methodParameters) && Objects.equals(this.filter, other.filter) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped) && Objects.equals(this.rescoreContext, other.rescoreContext) && Objects.equals(this.expandNested, other.expandNested);
    }

    protected int doHashCode() {
        return Objects.hash(this.fieldName, Arrays.hashCode(this.vector), this.k, this.methodParameters, this.filter, this.ignoreUnmapped, this.maxDistance, this.minScore, this.rescoreContext, this.expandNested);
    }

    public String getWriteableName() {
        return NAME;
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        QueryBuilder rewrittenFilter;
        if (Objects.nonNull(this.filter) && (rewrittenFilter = this.filter.rewrite(queryShardContext)) != this.filter) {
            KNNQueryBuilder rewrittenQueryBuilder = KNNQueryBuilder.builder().fieldName(this.fieldName).vector(this.vector).k(this.k).maxDistance(this.maxDistance).minScore(this.minScore).methodParameters(this.methodParameters).filter(rewrittenFilter).ignoreUnmapped(this.ignoreUnmapped).rescoreContext(this.rescoreContext).expandNested(this.expandNested).build();
            return rewrittenQueryBuilder;
        }
        return super.doRewrite(queryShardContext);
    }

    @Generated
    private KNNQueryBuilder(String fieldName, float[] vector, int k, Float maxDistance, Float minScore, Map<String, ?> methodParameters, QueryBuilder filter, boolean ignoreUnmapped, RescoreContext rescoreContext, Boolean expandNested) {
        this.fieldName = fieldName;
        this.vector = vector;
        this.k = k;
        this.maxDistance = maxDistance;
        this.minScore = minScore;
        this.methodParameters = methodParameters;
        this.filter = filter;
        this.ignoreUnmapped = ignoreUnmapped;
        this.rescoreContext = rescoreContext;
        this.expandNested = expandNested;
    }

    @Generated
    public int getK() {
        return this.k;
    }

    @Generated
    public Float getMaxDistance() {
        return this.maxDistance;
    }

    @Generated
    public Float getMinScore() {
        return this.minScore;
    }

    @Generated
    public Map<String, ?> getMethodParameters() {
        return this.methodParameters;
    }

    @Generated
    public QueryBuilder getFilter() {
        return this.filter;
    }

    @Generated
    public boolean isIgnoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Generated
    public RescoreContext getRescoreContext() {
        return this.rescoreContext;
    }

    @Generated
    public Boolean getExpandNested() {
        return this.expandNested;
    }

    static {
        VECTOR_FIELD = new ParseField("vector", new String[0]);
        K_FIELD = new ParseField("k", new String[0]);
        FILTER_FIELD = new ParseField("filter", new String[0]);
        IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
        EXPAND_NESTED_FIELD = new ParseField("expand_nested_docs", new String[0]);
        MAX_DISTANCE_FIELD = new ParseField("max_distance", new String[0]);
        MIN_SCORE_FIELD = new ParseField("min_score", new String[0]);
        EF_SEARCH_FIELD = new ParseField("ef_search", new String[0]);
        NPROBE_FIELD = new ParseField("nprobes", new String[0]);
        METHOD_PARAMS_FIELD = new ParseField("method_parameters", new String[0]);
        RESCORE_FIELD = new ParseField("rescore", new String[0]);
        RESCORE_OVERSAMPLE_FIELD = new ParseField("oversample_factor", new String[0]);
    }

    public static class Builder {
        private String fieldName;
        private float[] vector;
        private Integer k;
        private Map<String, ?> methodParameters;
        private Float maxDistance;
        private Float minScore;
        private QueryBuilder filter;
        private boolean ignoreUnmapped;
        private String queryName;
        private float boost = 1.0f;
        private RescoreContext rescoreContext;
        private Boolean expandNested;

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder vector(float[] vector) {
            this.vector = vector;
            return this;
        }

        public Builder k(Integer k) {
            this.k = k;
            return this;
        }

        public Builder methodParameters(Map<String, ?> methodParameters) {
            this.methodParameters = methodParameters;
            return this;
        }

        public Builder maxDistance(Float maxDistance) {
            this.maxDistance = maxDistance;
            return this;
        }

        public Builder minScore(Float minScore) {
            this.minScore = minScore;
            return this;
        }

        public Builder ignoreUnmapped(boolean ignoreUnmapped) {
            this.ignoreUnmapped = ignoreUnmapped;
            return this;
        }

        public Builder filter(QueryBuilder filter) {
            this.filter = filter;
            return this;
        }

        public Builder queryName(String queryName) {
            this.queryName = queryName;
            return this;
        }

        public Builder boost(float boost) {
            this.boost = boost;
            return this;
        }

        public Builder rescoreContext(RescoreContext rescoreContext) {
            this.rescoreContext = rescoreContext;
            return this;
        }

        public Builder expandNested(Boolean expandNested) {
            this.expandNested = expandNested;
            return this;
        }

        public KNNQueryBuilder build() {
            this.validate();
            int k = this.k == null ? 0 : this.k;
            return (KNNQueryBuilder)((KNNQueryBuilder)new KNNQueryBuilder(this.fieldName, this.vector, k, this.maxDistance, this.minScore, this.methodParameters, this.filter, this.ignoreUnmapped, this.rescoreContext, this.expandNested).boost(this.boost)).queryName(this.queryName);
        }

        private void validate() {
            ValidationException validationException;
            if (Strings.isNullOrEmpty((String)this.fieldName)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] requires fieldName", KNNQueryBuilder.NAME));
            }
            if (this.vector == null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] requires query vector", KNNQueryBuilder.NAME));
            }
            if (this.vector.length == 0) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] query vector is empty", KNNQueryBuilder.NAME));
            }
            if (this.k == null && this.minScore == null && this.maxDistance == null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] requires exactly one of k, distance or score to be set", KNNQueryBuilder.NAME));
            }
            if (this.k != null && this.maxDistance != null || this.maxDistance != null && this.minScore != null || this.k != null && this.minScore != null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] requires exactly one of k, distance or score to be set", KNNQueryBuilder.NAME));
            }
            if (this.k != null && (this.k <= 0 || this.k > 10000)) {
                String errorMessage = "[knn] requires k to be in the range (0, 10000]";
                throw new IllegalArgumentException("[knn] requires k to be in the range (0, 10000]");
            }
            if (this.minScore != null && this.minScore.floatValue() <= 0.0f) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] requires minScore to be greater than 0", KNNQueryBuilder.NAME));
            }
            if (this.methodParameters != null && (validationException = MethodParametersParser.validateMethodParameters(this.methodParameters)) != null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] errors in method parameter [%s]", KNNQueryBuilder.NAME, validationException.getMessage()));
            }
            if (this.rescoreContext != null && (validationException = RescoreParser.validate(this.rescoreContext)) != null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] errors in rescore parameter [%s]", KNNQueryBuilder.NAME, validationException.getMessage()));
            }
        }
    }

    private static class QueryConfigFromMapping {
        private final KNNEngine knnEngine;
        private final MethodComponentContext methodComponentContext;
        private final SpaceType spaceType;
        private final VectorDataType vectorDataType;

        @Generated
        public KNNEngine getKnnEngine() {
            return this.knnEngine;
        }

        @Generated
        public MethodComponentContext getMethodComponentContext() {
            return this.methodComponentContext;
        }

        @Generated
        public SpaceType getSpaceType() {
            return this.spaceType;
        }

        @Generated
        public VectorDataType getVectorDataType() {
            return this.vectorDataType;
        }

        @Generated
        public QueryConfigFromMapping(KNNEngine knnEngine, MethodComponentContext methodComponentContext, SpaceType spaceType, VectorDataType vectorDataType) {
            this.knnEngine = knnEngine;
            this.methodComponentContext = methodComponentContext;
            this.spaceType = spaceType;
            this.vectorDataType = vectorDataType;
        }
    }
}

