/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.common.sgd;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import java.util.SplittableRandom;
import java.util.logging.Logger;
import org.tribuo.Output;
import org.tribuo.common.sgd.AbstractFMModel;
import org.tribuo.common.sgd.AbstractSGDTrainer;
import org.tribuo.common.sgd.FMParameters;
import org.tribuo.math.StochasticGradientOptimiser;

public abstract class AbstractFMTrainer<T extends Output<T>, U, V extends AbstractFMModel<T>>
extends AbstractSGDTrainer<T, U, V, FMParameters> {
    private static final Logger logger = Logger.getLogger(AbstractFMTrainer.class.getName());
    @Config(mandatory=true, description="The size of the factorized feature representation.")
    protected int factorizedDimSize;
    @Config(mandatory=true, description="The variance of the initializer.")
    protected double variance;

    protected AbstractFMTrainer(StochasticGradientOptimiser optimiser, int epochs, int loggingInterval, int minibatchSize, long seed, int factorizedDimSize, double variance) {
        super(optimiser, epochs, loggingInterval, minibatchSize, seed, false);
        this.factorizedDimSize = factorizedDimSize;
        this.variance = variance;
        this.postConfig();
    }

    protected AbstractFMTrainer() {
        super(false);
    }

    @Override
    public void postConfig() {
        super.postConfig();
        if (this.factorizedDimSize < 1) {
            throw new PropertyException("", "factorizedDimSize", "Value must be positive.");
        }
        if (this.variance <= 0.0) {
            throw new PropertyException("", "variance", "Value must be positive.");
        }
    }

    @Override
    protected String getName() {
        return "factorization-machine-model";
    }

    @Override
    protected FMParameters createParameters(int numFeatures, int numOutputs, SplittableRandom localRNG) {
        return new FMParameters(localRNG, numFeatures, numOutputs, this.factorizedDimSize, this.variance);
    }
}

