/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.cluster;

import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.opensearch.ad.cluster.diskcleanup.ADCheckpointIndexRetention;
import org.opensearch.client.Client;
import org.opensearch.cluster.LocalNodeClusterManagerListener;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lifecycle.LifecycleListener;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.forecast.cluster.diskcleanup.ForecastCheckpointIndexRetention;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.cluster.HourlyCron;
import org.opensearch.timeseries.cluster.diskcleanup.IndexCleanup;
import org.opensearch.timeseries.util.ClientUtil;
import org.opensearch.timeseries.util.DateUtils;
import org.opensearch.timeseries.util.DiscoveryNodeFilterer;

public class ClusterManagerEventListener
implements LocalNodeClusterManagerListener {
    private Scheduler.Cancellable adCheckpointIndexRetentionCron;
    private Scheduler.Cancellable forecastCheckpointIndexRetentionCron;
    private Scheduler.Cancellable hourlyCron;
    private ClusterService clusterService;
    private ThreadPool threadPool;
    private Client client;
    private Clock clock;
    private ClientUtil clientUtil;
    private DiscoveryNodeFilterer nodeFilter;
    private Duration adCheckpointTtlDuration;
    private Duration forecastCheckpointTtlDuration;

    public ClusterManagerEventListener(ClusterService clusterService, ThreadPool threadPool, Client client, Clock clock, ClientUtil clientUtil, DiscoveryNodeFilterer nodeFilter, Setting<TimeValue> adCheckpointTtl, Setting<TimeValue> forecastCheckpointTtl, Settings settings) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.clusterService.addLocalNodeClusterManagerListener((LocalNodeClusterManagerListener)this);
        this.clock = clock;
        this.clientUtil = clientUtil;
        this.nodeFilter = nodeFilter;
        this.adCheckpointTtlDuration = DateUtils.toDuration((TimeValue)adCheckpointTtl.get(settings));
        this.forecastCheckpointTtlDuration = DateUtils.toDuration((TimeValue)forecastCheckpointTtl.get(settings));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(adCheckpointTtl, it -> {
            this.adCheckpointTtlDuration = DateUtils.toDuration(it);
            this.cancel(this.adCheckpointIndexRetentionCron);
            IndexCleanup indexCleanup = new IndexCleanup(client, clientUtil, clusterService);
            this.adCheckpointIndexRetentionCron = threadPool.scheduleWithFixedDelay((Runnable)new ADCheckpointIndexRetention(this.adCheckpointTtlDuration, clock, indexCleanup), TimeValue.timeValueHours((long)24L), this.executorName());
            this.forecastCheckpointIndexRetentionCron = threadPool.scheduleWithFixedDelay((Runnable)new ForecastCheckpointIndexRetention(this.forecastCheckpointTtlDuration, clock, indexCleanup), TimeValue.timeValueHours((long)24L), this.executorName());
        });
    }

    public void onClusterManager() {
        if (this.hourlyCron == null) {
            this.hourlyCron = this.threadPool.scheduleWithFixedDelay((Runnable)new HourlyCron(this.client, this.nodeFilter), TimeValue.timeValueHours((long)1L), this.executorName());
            this.clusterService.addLifecycleListener(new LifecycleListener(){

                public void beforeStop() {
                    ClusterManagerEventListener.this.cancel(ClusterManagerEventListener.this.hourlyCron);
                    ClusterManagerEventListener.this.hourlyCron = null;
                }
            });
        }
        if (this.adCheckpointIndexRetentionCron == null) {
            IndexCleanup indexCleanup = new IndexCleanup(this.client, this.clientUtil, this.clusterService);
            this.adCheckpointIndexRetentionCron = this.threadPool.scheduleWithFixedDelay((Runnable)new ADCheckpointIndexRetention(this.adCheckpointTtlDuration, this.clock, indexCleanup), TimeValue.timeValueHours((long)24L), this.executorName());
            this.forecastCheckpointIndexRetentionCron = this.threadPool.scheduleWithFixedDelay((Runnable)new ForecastCheckpointIndexRetention(this.forecastCheckpointTtlDuration, this.clock, indexCleanup), TimeValue.timeValueHours((long)24L), this.executorName());
            this.clusterService.addLifecycleListener(new LifecycleListener(){

                public void beforeStop() {
                    ClusterManagerEventListener.this.cancel(ClusterManagerEventListener.this.adCheckpointIndexRetentionCron);
                    ClusterManagerEventListener.this.adCheckpointIndexRetentionCron = null;
                    ClusterManagerEventListener.this.cancel(ClusterManagerEventListener.this.forecastCheckpointIndexRetentionCron);
                    ClusterManagerEventListener.this.forecastCheckpointIndexRetentionCron = null;
                }
            });
        }
    }

    public void offClusterManager() {
        this.cancel(this.hourlyCron);
        this.hourlyCron = null;
        this.cancel(this.adCheckpointIndexRetentionCron);
        this.adCheckpointIndexRetentionCron = null;
        this.cancel(this.forecastCheckpointIndexRetentionCron);
        this.forecastCheckpointIndexRetentionCron = null;
    }

    private void cancel(Scheduler.Cancellable cron) {
        if (cron != null) {
            cron.cancel();
        }
    }

    @VisibleForTesting
    public List<Scheduler.Cancellable> getCheckpointIndexRetentionCron() {
        return Arrays.asList(this.adCheckpointIndexRetentionCron, this.forecastCheckpointIndexRetentionCron);
    }

    public Scheduler.Cancellable getHourlyCron() {
        return this.hourlyCron;
    }

    private String executorName() {
        return "generic";
    }
}

