/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.memory;

import java.io.IOException;
import java.time.Instant;
import lombok.Generated;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.engine.memory.BaseMessage;

public class ConversationIndexMessage
extends BaseMessage {
    private String sessionId;
    private String question;
    private String response;
    private Boolean finalAnswer;
    private Instant createdTime;

    public ConversationIndexMessage(String type, String sessionId, String question, String response, boolean finalAnswer) {
        super(type, response);
        this.sessionId = sessionId;
        this.question = question;
        this.response = response;
        this.finalAnswer = finalAnswer;
        this.createdTime = Instant.now();
    }

    @Override
    public String toString() {
        return "Human:" + this.question + "\nAssistant:" + this.response;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.sessionId != null) {
            builder.field("session_id", this.sessionId);
        }
        if (this.question != null) {
            builder.field("question", this.question);
        }
        if (this.response != null) {
            builder.field("response", this.response);
        }
        if (this.finalAnswer != null) {
            builder.field("final_answer", this.finalAnswer);
        }
        builder.field("created_time", (Object)this.createdTime);
        builder.endObject();
        return builder;
    }

    @Generated
    public static ConversationIndexMessageBuilder conversationIndexMessageBuilder() {
        return new ConversationIndexMessageBuilder();
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public String getQuestion() {
        return this.question;
    }

    @Generated
    public String getResponse() {
        return this.response;
    }

    @Generated
    public Boolean getFinalAnswer() {
        return this.finalAnswer;
    }

    @Generated
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Generated
    public void setQuestion(String question) {
        this.question = question;
    }

    @Generated
    public void setResponse(String response) {
        this.response = response;
    }

    @Generated
    public void setFinalAnswer(Boolean finalAnswer) {
        this.finalAnswer = finalAnswer;
    }

    @Generated
    public void setCreatedTime(Instant createdTime) {
        this.createdTime = createdTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConversationIndexMessage)) {
            return false;
        }
        ConversationIndexMessage other = (ConversationIndexMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$finalAnswer = this.getFinalAnswer();
        Boolean other$finalAnswer = other.getFinalAnswer();
        if (this$finalAnswer == null ? other$finalAnswer != null : !((Object)this$finalAnswer).equals(other$finalAnswer)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        String this$question = this.getQuestion();
        String other$question = other.getQuestion();
        if (this$question == null ? other$question != null : !this$question.equals(other$question)) {
            return false;
        }
        String this$response = this.getResponse();
        String other$response = other.getResponse();
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        Instant this$createdTime = this.getCreatedTime();
        Instant other$createdTime = other.getCreatedTime();
        return !(this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConversationIndexMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $finalAnswer = this.getFinalAnswer();
        result = result * 59 + ($finalAnswer == null ? 43 : ((Object)$finalAnswer).hashCode());
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        String $question = this.getQuestion();
        result = result * 59 + ($question == null ? 43 : $question.hashCode());
        String $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        Instant $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        return result;
    }

    @Generated
    public static class ConversationIndexMessageBuilder {
        @Generated
        private String type;
        @Generated
        private String sessionId;
        @Generated
        private String question;
        @Generated
        private String response;
        @Generated
        private boolean finalAnswer;

        @Generated
        ConversationIndexMessageBuilder() {
        }

        @Generated
        public ConversationIndexMessageBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public ConversationIndexMessageBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Generated
        public ConversationIndexMessageBuilder question(String question) {
            this.question = question;
            return this;
        }

        @Generated
        public ConversationIndexMessageBuilder response(String response) {
            this.response = response;
            return this;
        }

        @Generated
        public ConversationIndexMessageBuilder finalAnswer(boolean finalAnswer) {
            this.finalAnswer = finalAnswer;
            return this;
        }

        @Generated
        public ConversationIndexMessage build() {
            return new ConversationIndexMessage(this.type, this.sessionId, this.question, this.response, this.finalAnswer);
        }

        @Generated
        public String toString() {
            return "ConversationIndexMessage.ConversationIndexMessageBuilder(type=" + this.type + ", sessionId=" + this.sessionId + ", question=" + this.question + ", response=" + this.response + ", finalAnswer=" + this.finalAnswer + ")";
        }
    }
}

