/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.UUID;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException$;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.executor.ExecutorExitCode$;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.shuffle.ExecutorDiskUtils;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockId$;
import org.apache.spark.storage.DiskBlockManager$;
import org.apache.spark.storage.ShuffleMergedDataBlockId;
import org.apache.spark.storage.ShuffleMergedIndexBlockId;
import org.apache.spark.storage.ShuffleMergedMetaBlockId;
import org.apache.spark.storage.TempLocalBlockId;
import org.apache.spark.storage.TempShuffleBlockId;
import org.apache.spark.storage.UnrecognizedBlockId;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Ug!\u0002\u00192\u0001MJ\u0004\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u00111\u0003!\u00111A\u0005\u00025C\u0001\"\u0015\u0001\u0003\u0002\u0004%\tA\u0015\u0005\t1\u0002\u0011\t\u0011)Q\u0005\u001d\"A\u0011\f\u0001B\u0001B\u0003%a\nC\u0003[\u0001\u0011\u00051\f\u0003\u0005b\u0001\t\u0007I\u0011A\u001ac\u0011\u00191\u0007\u0001)A\u0005G\"Aq\r\u0001b\u0001\n\u0003\u0019\u0004\u000e\u0003\u0004u\u0001\u0001\u0006I!\u001b\u0005\tk\u0002\u0011\r\u0011\"\u00014m\"9\u0011q\u0001\u0001!\u0002\u00139\b\"CA\u0005\u0001\t\u0007I\u0011BA\u0006\u0011!\ty\u0001\u0001Q\u0001\n\u00055\u0001\"CA\t\u0001\t\u0007I\u0011BA\n\u0011\u001d\t)\u0002\u0001Q\u0001\naD\u0011\"a\u0006\u0001\u0005\u0004%I!!\u0007\t\u000f\u0005m\u0001\u0001)A\u0005u!A\u0011Q\u0004\u0001C\u0002\u0013%Q\nC\u0004\u0002 \u0001\u0001\u000b\u0011\u0002(\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005%\u0002bBA\u001b\u0001\u0011\u0005\u0011q\u0007\u0005\b\u0003k\u0001A\u0011BA#\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001bBq!!\u0015\u0001\t\u0003\t\u0019\u0006C\u0004\u0002h\u0001!\t!!\u001b\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0004bBA>\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003\u0017\u0003A\u0011AAG\u0011\u001d\t9\n\u0001C\u0005\u00033Cq!!(\u0001\t\u0013\ty\nC\u0004\u0002\"\u0002!\t!a)\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\"9\u0011Q\u0016\u0001\u0005\n\u0005=\u0006\u0002CAY\u0001\u0011\u00051'a(\t\u000f\u0005M\u0006\u0001\"\u0003\u0002 \u001eA\u0011QW\u0019\t\u0002M\n9LB\u00041c!\u00051'!/\t\riCC\u0011AA^\u0011%\ti\f\u000bb\u0001\n\u0003\ty\f\u0003\u0005\u0002L\"\u0002\u000b\u0011BAa\u0011%\ti\r\u000bb\u0001\n\u0003\ty\f\u0003\u0005\u0002P\"\u0002\u000b\u0011BAa\u0011%\t\t\u000e\u000bb\u0001\n\u0003\ty\f\u0003\u0005\u0002T\"\u0002\u000b\u0011BAa\u0005A!\u0015n]6CY>\u001c7.T1oC\u001e,'O\u0003\u00023g\u000591\u000f^8sC\u001e,'B\u0001\u001b6\u0003\u0015\u0019\b/\u0019:l\u0015\t1t'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002q\u0005\u0019qN]4\u0014\u0007\u0001Q\u0004\t\u0005\u0002<}5\tAHC\u0001>\u0003\u0015\u00198-\u00197b\u0013\tyDH\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007N\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u000b\n\u0013q\u0001T8hO&tw-\u0001\u0003d_:47\u0001\u0001\t\u0003\u0013*k\u0011aM\u0005\u0003\u0017N\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002#\u0011,G.\u001a;f\r&dWm](o'R|\u0007/F\u0001O!\tYt*\u0003\u0002Qy\t9!i\\8mK\u0006t\u0017!\u00063fY\u0016$XMR5mKN|en\u0015;pa~#S-\u001d\u000b\u0003'Z\u0003\"a\u000f+\n\u0005Uc$\u0001B+oSRDqaV\u0002\u0002\u0002\u0003\u0007a*A\u0002yIE\n!\u0003Z3mKR,g)\u001b7fg>s7\u000b^8qA\u0005A\u0011n\u001d#sSZ,'/\u0001\u0004=S:LGO\u0010\u000b\u00059z{\u0006\r\u0005\u0002^\u00015\t\u0011\u0007C\u0003G\r\u0001\u0007\u0001\nC\u0003M\r\u0001\u0007a\nC\u0003Z\r\u0001\u0007a*\u0001\ntk\n$\u0015N]:QKJdunY1m\t&\u0014X#A2\u0011\u0005m\"\u0017BA3=\u0005\rIe\u000e^\u0001\u0014gV\u0014G)\u001b:t!\u0016\u0014Hj\\2bY\u0012K'\u000fI\u0001\nY>\u001c\u0017\r\u001c#jeN,\u0012!\u001b\t\u0004w)d\u0017BA6=\u0005\u0015\t%O]1z!\ti'/D\u0001o\u0015\ty\u0007/\u0001\u0002j_*\t\u0011/\u0001\u0003kCZ\f\u0017BA:o\u0005\u00111\u0015\u000e\\3\u0002\u00151|7-\u00197ESJ\u001c\b%A\bm_\u000e\fG\u000eR5sgN#(/\u001b8h+\u00059\bcA\u001ekqB\u0019\u00110!\u0001\u000f\u0005it\bCA>=\u001b\u0005a(BA?H\u0003\u0019a$o\\8u}%\u0011q\u0010P\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0011Q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}d\u0014\u0001\u00057pG\u0006dG)\u001b:t'R\u0014\u0018N\\4!\u0003\u001d\u0019XO\u0019#jeN,\"!!\u0004\u0011\u0007mR\u0017.\u0001\u0005tk\n$\u0015N]:!\u00031iWM]4f\t&\u0014h*Y7f+\u0005A\u0018!D7fe\u001e,G)\u001b:OC6,\u0007%\u0001\u0007tQV$Hm\\<o\u0011>|7.F\u0001;\u00035\u0019\b.\u001e;e_^t\u0007j\\8lA\u0005Q\u0002/\u001a:nSN\u001c\u0018n\u001c8DQ\u0006tw-\u001b8h%\u0016\fX/\u001b:fI\u0006Y\u0002/\u001a:nSN\u001c\u0018n\u001c8DQ\u0006tw-\u001b8h%\u0016\fX/\u001b:fI\u0002\nqaZ3u\r&dW\rF\u0002m\u0003KAa!a\n\u0016\u0001\u0004A\u0018\u0001\u00034jY\u0016t\u0017-\\3\u0015\u00071\fY\u0003C\u0004\u0002.Y\u0001\r!a\f\u0002\u000f\tdwnY6JIB\u0019Q,!\r\n\u0007\u0005M\u0012GA\u0004CY>\u001c7.\u00133\u0002)\u001d,G/T3sO\u0016$7\u000b[;gM2,g)\u001b7f)\u0015a\u0017\u0011HA\u001e\u0011\u001d\tic\u0006a\u0001\u0003_Aq!!\u0010\u0018\u0001\u0004\ty$\u0001\u0003eSJ\u001c\b\u0003B\u001e\u0002B]L1!a\u0011=\u0005\u0019y\u0005\u000f^5p]R)A.a\u0012\u0002J!1\u0011q\u0005\rA\u0002aDq!!\u0010\u0019\u0001\u0004\ty$A\u0007d_:$\u0018-\u001b8t\u00052|7m\u001b\u000b\u0004\u001d\u0006=\u0003bBA\u00173\u0001\u0007\u0011qF\u0001\fO\u0016$\u0018\t\u001c7GS2,7\u000f\u0006\u0002\u0002VA)\u0011qKA1Y:!\u0011\u0011LA/\u001d\rY\u00181L\u0005\u0002{%\u0019\u0011q\f\u001f\u0002\u000fA\f7m[1hK&!\u00111MA3\u0005\r\u0019V-\u001d\u0006\u0004\u0003?b\u0014\u0001D4fi\u0006cGN\u00117pG.\u001cHCAA6!\u0019\t9&!\u0019\u00020\u000592M]3bi\u0016<vN\u001d7e%\u0016\fG-\u00192mK\u001aKG.\u001a\u000b\u0004'\u0006E\u0004BBA:9\u0001\u0007A.\u0001\u0003gS2,\u0017AE2sK\u0006$X\rV3na\u001aKG.Z,ji\"$2\u0001\\A=\u0011\u0019\t\u0019(\ba\u0001Y\u0006!2M]3bi\u0016$V-\u001c9M_\u000e\fGN\u00117pG.$\"!a \u0011\rm\n\t)!\"m\u0013\r\t\u0019\t\u0010\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007u\u000b9)C\u0002\u0002\nF\u0012\u0001\u0003V3na2{7-\u00197CY>\u001c7.\u00133\u0002-\r\u0014X-\u0019;f)\u0016l\u0007o\u00155vM\u001adWM\u00117pG.$\"!a$\u0011\rm\n\t)!%m!\ri\u00161S\u0005\u0004\u0003+\u000b$A\u0005+f[B\u001c\u0006.\u001e4gY\u0016\u0014En\\2l\u0013\u0012\fqb\u0019:fCR,Gj\\2bY\u0012K'o\u001d\u000b\u0004S\u0006m\u0005\"\u0002$!\u0001\u0004A\u0015!J2sK\u0006$X\rT8dC2$\u0015N]:G_JlUM]4fINCWO\u001a4mK\ncwnY6t)\u0005\u0019\u0016AG2sK\u0006$X\rR5s/&$\b\u000eU3s[&\u001c8/[8oo]\u0002DcA*\u0002&\"1\u0011q\u0015\u0012A\u00021\f1\u0002Z5s)>\u001c%/Z1uK\u00069s-\u001a;NKJ<W\rR5sK\u000e$xN]=B]\u0012\fE\u000f^3naRLEIS:p]N#(/\u001b8h)\u0005A\u0018aD1eINCW\u000f\u001e3po:Dun\\6\u0015\u0003i\nAa\u001d;pa\u00061Am\\*u_B\f\u0001\u0003R5tW\ncwnY6NC:\fw-\u001a:\u0011\u0005uC3C\u0001\u0015;)\t\t9,A\bN\u000bJ;Ui\u0018#J%\u0016\u001bEk\u0014*Z+\t\t\t\r\u0005\u0003\u0002D\u0006%WBAAc\u0015\r\t9\r]\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u0004\u0005\u0015\u0017\u0001E'F%\u001e+u\fR%S\u000b\u000e#vJU-!\u00035iUIU$F?\u0012K%kX&F3\u0006qQ*\u0012*H\u000b~#\u0015JU0L\u000bf\u0003\u0013AD!U)\u0016k\u0005\u000bV0J\t~[U)W\u0001\u0010\u0003R#V)\u0014)U?&#ulS#ZA\u0001")
public class DiskBlockManager
implements Logging {
    private final SparkConf conf;
    private boolean deleteFilesOnStop;
    private final boolean isDriver;
    private final int subDirsPerLocalDir;
    private final File[] localDirs;
    private final String[] localDirsString;
    private final File[][] subDirs;
    private final String mergeDirName;
    private final Object shutdownHook;
    private final boolean permissionChangingRequired;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String ATTEMPT_ID_KEY() {
        return DiskBlockManager$.MODULE$.ATTEMPT_ID_KEY();
    }

    public static String MERGE_DIR_KEY() {
        return DiskBlockManager$.MODULE$.MERGE_DIR_KEY();
    }

    public static String MERGE_DIRECTORY() {
        return DiskBlockManager$.MODULE$.MERGE_DIRECTORY();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean deleteFilesOnStop() {
        return this.deleteFilesOnStop;
    }

    public void deleteFilesOnStop_$eq(boolean x$1) {
        this.deleteFilesOnStop = x$1;
    }

    public int subDirsPerLocalDir() {
        return this.subDirsPerLocalDir;
    }

    public File[] localDirs() {
        return this.localDirs;
    }

    public String[] localDirsString() {
        return this.localDirsString;
    }

    private File[][] subDirs() {
        return this.subDirs;
    }

    private String mergeDirName() {
        return this.mergeDirName;
    }

    private Object shutdownHook() {
        return this.shutdownHook;
    }

    private boolean permissionChangingRequired() {
        return this.permissionChangingRequired;
    }

    public File getFile(String filename) {
        File file;
        int hash = Utils$.MODULE$.nonNegativeHash(filename);
        int dirId = hash % this.localDirs().length;
        int subDirId = hash / this.localDirs().length % this.subDirsPerLocalDir();
        File[] fileArray = this.subDirs()[dirId];
        synchronized (fileArray) {
            File file2;
            File old = this.subDirs()[dirId][subDirId];
            if (old != null) {
                file2 = old;
            } else {
                Object object;
                File newDir = new File(this.localDirs()[dirId], StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)subDirId)})));
                if (!newDir.exists()) {
                    Path path = newDir.toPath();
                    Files.createDirectory(path, new FileAttribute[0]);
                    if (this.permissionChangingRequired()) {
                        Set<PosixFilePermission> currentPerms = Files.getPosixFilePermissions(path, new LinkOption[0]);
                        currentPerms.add(PosixFilePermission.GROUP_WRITE);
                        object = Files.setPosixFilePermissions(path, currentPerms);
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                } else {
                    object = BoxedUnit.UNIT;
                }
                this.subDirs()[dirId][subDirId] = newDir;
                file2 = newDir;
            }
            file = file2;
        }
        File subDir = file;
        return new File(subDir, filename);
    }

    public File getFile(BlockId blockId) {
        return this.getFile(blockId.name());
    }

    public File getMergedShuffleFile(BlockId blockId, Option<String[]> dirs) {
        File file;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof ShuffleMergedDataBlockId) {
            ShuffleMergedDataBlockId shuffleMergedDataBlockId = (ShuffleMergedDataBlockId)blockId2;
            file = this.getMergedShuffleFile(shuffleMergedDataBlockId.name(), dirs);
        } else if (blockId2 instanceof ShuffleMergedIndexBlockId) {
            ShuffleMergedIndexBlockId shuffleMergedIndexBlockId = (ShuffleMergedIndexBlockId)blockId2;
            file = this.getMergedShuffleFile(shuffleMergedIndexBlockId.name(), dirs);
        } else if (blockId2 instanceof ShuffleMergedMetaBlockId) {
            ShuffleMergedMetaBlockId shuffleMergedMetaBlockId = (ShuffleMergedMetaBlockId)blockId2;
            file = this.getMergedShuffleFile(shuffleMergedMetaBlockId.name(), dirs);
        } else {
            throw SparkException$.MODULE$.internalError(new StringBuilder(43).append("Only merged block ID is supported, but got ").append(blockId).toString(), "STORAGE");
        }
        return file;
    }

    private File getMergedShuffleFile(String filename, Option<String[]> dirs) {
        if (!dirs.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])x$2))))) {
            throw SparkException$.MODULE$.internalError(new StringBuilder(49).append("Cannot read ").append(filename).append(" because merged shuffle dirs is empty").toString(), "STORAGE");
        }
        return new File(ExecutorDiskUtils.getFilePath((String[])((String[])dirs.get()), (int)this.subDirsPerLocalDir(), (String)filename));
    }

    public boolean containsBlock(BlockId blockId) {
        return this.getFile(blockId.name()).exists();
    }

    public Seq<File> getAllFiles() {
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])this.subDirs()), (Function1 & Serializable)dir -> {
            File[] fileArray = dir;
            synchronized (dir) {
                File[] fileArray2 = (File[])dir.clone();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return fileArray2;
            }
        }, (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(File.class))), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DiskBlockManager.$anonfun$getAllFiles$3(x$3)))), (Function1 & Serializable)dir -> {
            File[] files = dir.listFiles();
            return files != null ? ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])files)) : (Seq)package$.MODULE$.Seq().empty();
        }, ClassTag$.MODULE$.apply(File.class)));
    }

    public Seq<BlockId> getAllBlocks() {
        return (Seq)this.getAllFiles().flatMap((Function1 & Serializable)f -> {
            Some some;
            try {
                some = new Some((Object)BlockId$.MODULE$.apply(f.getName()));
            }
            catch (UnrecognizedBlockId unrecognizedBlockId) {
                some = None$.MODULE$;
            }
            return some;
        });
    }

    public void createWorldReadableFile(File file) {
        Path path = file.toPath();
        Files.createFile(path, new FileAttribute[0]);
        Set<PosixFilePermission> currentPerms = Files.getPosixFilePermissions(path, new LinkOption[0]);
        currentPerms.add(PosixFilePermission.OTHERS_READ);
        Files.setPosixFilePermissions(path, currentPerms);
    }

    /*
     * WARNING - void declaration
     */
    public File createTempFileWith(File file) {
        void var2_2;
        block0: {
            File tmpFile = Utils$.MODULE$.tempFileWith(file);
            if (!this.permissionChangingRequired()) break block0;
            this.createWorldReadableFile(tmpFile);
        }
        return var2_2;
    }

    public Tuple2<TempLocalBlockId, File> createTempLocalBlock() {
        TempLocalBlockId blockId = new TempLocalBlockId(UUID.randomUUID());
        while (this.getFile(blockId).exists()) {
            blockId = new TempLocalBlockId(UUID.randomUUID());
        }
        return new Tuple2((Object)blockId, (Object)this.getFile(blockId));
    }

    public Tuple2<TempShuffleBlockId, File> createTempShuffleBlock() {
        TempShuffleBlockId blockId = new TempShuffleBlockId(UUID.randomUUID());
        while (this.getFile(blockId).exists()) {
            blockId = new TempShuffleBlockId(UUID.randomUUID());
        }
        File tmpFile = this.getFile(blockId);
        if (this.permissionChangingRequired()) {
            this.createWorldReadableFile(tmpFile);
        }
        return new Tuple2((Object)blockId, (Object)tmpFile);
    }

    private File[] createLocalDirs(SparkConf conf) {
        return (File[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.getConfiguredLocalDirs(conf)), (Function1 & Serializable)rootDir -> {
            None$ none$;
            try {
                File localDir = Utils$.MODULE$.createDirectory((String)rootDir, "blockmgr");
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Created local directory at ").append(localDir).toString());
                none$ = new Some((Object)localDir);
            }
            catch (IOException e) {
                this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Failed to create local dir in ").append((String)rootDir).append(". Ignoring this directory.").toString(), e);
                none$ = None$.MODULE$;
            }
            return none$;
        }, ClassTag$.MODULE$.apply(File.class));
    }

    private void createLocalDirsForMergedShuffleBlocks() {
        block0: {
            if (!Utils$.MODULE$.isPushBasedShuffleEnabled(this.conf, this.isDriver, false)) break block0;
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.getConfiguredLocalDirs(this.conf)), (Function1 & Serializable)rootDir -> {
                DiskBlockManager.$anonfun$createLocalDirsForMergedShuffleBlocks$1(this, rootDir);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void createDirWithPermission770(File dirToCreate) {
        int attempts = 0;
        int maxAttempts = Utils$.MODULE$.MAX_DIR_CREATION_ATTEMPTS();
        File created = null;
        while (created == null) {
            if (++attempts > maxAttempts) {
                throw SparkCoreErrors$.MODULE$.failToCreateDirectoryError(dirToCreate.getAbsolutePath(), maxAttempts);
            }
            try {
                dirToCreate.mkdirs();
                Files.setPosixFilePermissions(dirToCreate.toPath(), PosixFilePermissions.fromString("rwxrwx---"));
                if (dirToCreate.exists()) {
                    created = dirToCreate;
                }
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Created directory at ").append(dirToCreate.getAbsolutePath()).append(" with permission 770").toString());
            }
            catch (SecurityException e) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(28).append("Failed to create directory ").append(dirToCreate.getAbsolutePath()).append(" ").toString()).append("with permission 770").toString(), e);
                created = null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getMergeDirectoryAndAttemptIDJsonString() {
        void var3_3;
        HashMap mergedMetaMap = new HashMap();
        mergedMetaMap.put((Object)DiskBlockManager$.MODULE$.MERGE_DIR_KEY(), (Object)this.mergeDirName());
        ((Option)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.APP_ATTEMPT_ID())).foreach((Function1 & Serializable)attemptId -> mergedMetaMap.put((Object)DiskBlockManager$.MODULE$.ATTEMPT_ID_KEY(), attemptId));
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        String jsonString = mapper.writeValueAsString((Object)mergedMetaMap);
        return var3_3;
    }

    private Object addShutdownHook() {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Adding shutdown hook");
        return ShutdownHookManager$.MODULE$.addShutdownHook(ShutdownHookManager$.MODULE$.TEMP_DIR_SHUTDOWN_PRIORITY() + 1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Shutdown hook called");
            this.doStop();
        });
    }

    public void stop() {
        Boolean bl;
        try {
            bl = BoxesRunTime.boxToBoolean((boolean)ShutdownHookManager$.MODULE$.removeShutdownHook(this.shutdownHook()));
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> "Exception while removing shutdown hook.", e);
            bl = BoxedUnit.UNIT;
        }
        this.doStop();
    }

    private void doStop() {
        block0: {
            if (!this.deleteFilesOnStop()) break block0;
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this.localDirs()), (Function1 & Serializable)localDir -> {
                DiskBlockManager.$anonfun$doStop$1(this, localDir);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$getAllFiles$3(File x$3) {
        return x$3 != null;
    }

    public static final /* synthetic */ void $anonfun$createLocalDirsForMergedShuffleBlocks$1(DiskBlockManager $this, String rootDir) {
        try {
            File mergeDir = new File(rootDir, $this.mergeDirName());
            if (!mergeDir.exists() || mergeDir.listFiles().length < $this.subDirsPerLocalDir()) {
                $this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(42).append("Try to create ").append(mergeDir).append(" and its sub dirs since the ").toString()).append(new StringBuilder(19).append($this.mergeDirName()).append(" dir does not exist").toString()).toString());
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), $this.subDirsPerLocalDir()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)dirNum -> {
                    block0: {
                        File subDir = new File(mergeDir, StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dirNum)})));
                        if (subDir.exists()) break block0;
                        $this.createDirWithPermission770(subDir);
                    }
                });
            }
            $this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Merge directory and its sub dirs get created at ").append(mergeDir).toString());
        }
        catch (IOException e) {
            $this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Failed to create ").append($this.mergeDirName()).append(" dir in ").append(rootDir).append(". Ignoring this directory.").toString(), e);
        }
    }

    public static final /* synthetic */ void $anonfun$doStop$1(DiskBlockManager $this, File localDir) {
        block3: {
            if (!localDir.isDirectory() || !localDir.exists()) break block3;
            try {
                if (!ShutdownHookManager$.MODULE$.hasRootAsShutdownDeleteDir(localDir)) {
                    Utils$.MODULE$.deleteRecursively(localDir);
                }
            }
            catch (Exception e) {
                $this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Exception while deleting local spark dir: ").append(localDir).toString(), e);
            }
        }
    }

    public DiskBlockManager(SparkConf conf, boolean deleteFilesOnStop, boolean isDriver) {
        this.conf = conf;
        this.deleteFilesOnStop = deleteFilesOnStop;
        this.isDriver = isDriver;
        Logging.$init$((Logging)this);
        this.subDirsPerLocalDir = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DISKSTORE_SUB_DIRECTORIES()));
        this.localDirs = this.createLocalDirs(conf);
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.localDirs()))) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> "Failed to create any local dir.");
            System.exit(ExecutorExitCode$.MODULE$.DISK_STORE_FAILED_TO_CREATE_DIR());
        }
        this.localDirsString = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.localDirs()), (Function1 & Serializable)x$1 -> x$1.toString(), ClassTag$.MODULE$.apply(String.class));
        this.subDirs = (File[][])Array$.MODULE$.fill(this.localDirs().length, (Function0 & Serializable)() -> new File[this.subDirsPerLocalDir()], ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(File.class)));
        this.mergeDirName = new StringBuilder(0).append(DiskBlockManager$.MODULE$.MERGE_DIRECTORY()).append(((Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.APP_ATTEMPT_ID())).map((Function1 & Serializable)id -> new StringBuilder(1).append("_").append((String)id).toString()).getOrElse((Function0 & Serializable)() -> "")).toString();
        this.createLocalDirsForMergedShuffleBlocks();
        this.shutdownHook = this.addShutdownHook();
        this.permissionChangingRequired = BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_ENABLED())) && (BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_REMOVE_SHUFFLE_ENABLED())) || BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_FETCH_RDD_ENABLED())));
    }
}

