/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.util.Objects;
import software.amazon.cryptography.primitives.model.RSAPrivateKey;
import software.amazon.cryptography.primitives.model.RSAPublicKey;

public class GenerateRSAKeyPairOutput {
    private final RSAPublicKey publicKey;
    private final RSAPrivateKey privateKey;

    protected GenerateRSAKeyPairOutput(BuilderImpl builder) {
        this.publicKey = builder.publicKey();
        this.privateKey = builder.privateKey();
    }

    public RSAPublicKey publicKey() {
        return this.publicKey;
    }

    public RSAPrivateKey privateKey() {
        return this.privateKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected RSAPublicKey publicKey;
        protected RSAPrivateKey privateKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(GenerateRSAKeyPairOutput model) {
            this.publicKey = model.publicKey();
            this.privateKey = model.privateKey();
        }

        @Override
        public Builder publicKey(RSAPublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Override
        public RSAPublicKey publicKey() {
            return this.publicKey;
        }

        @Override
        public Builder privateKey(RSAPrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @Override
        public RSAPrivateKey privateKey() {
            return this.privateKey;
        }

        @Override
        public GenerateRSAKeyPairOutput build() {
            if (Objects.isNull(this.publicKey())) {
                throw new IllegalArgumentException("Missing value for required field `publicKey`");
            }
            if (Objects.isNull(this.privateKey())) {
                throw new IllegalArgumentException("Missing value for required field `privateKey`");
            }
            return new GenerateRSAKeyPairOutput(this);
        }
    }

    public static interface Builder {
        public Builder publicKey(RSAPublicKey var1);

        public RSAPublicKey publicKey();

        public Builder privateKey(RSAPrivateKey var1);

        public RSAPrivateKey privateKey();

        public GenerateRSAKeyPairOutput build();
    }
}

