/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class KmsPrivateKeyToStaticPublicKeyInput {
    private final String senderKmsIdentifier;
    private final ByteBuffer senderPublicKey;
    private final ByteBuffer recipientPublicKey;

    protected KmsPrivateKeyToStaticPublicKeyInput(BuilderImpl builder) {
        this.senderKmsIdentifier = builder.senderKmsIdentifier();
        this.senderPublicKey = builder.senderPublicKey();
        this.recipientPublicKey = builder.recipientPublicKey();
    }

    public String senderKmsIdentifier() {
        return this.senderKmsIdentifier;
    }

    public ByteBuffer senderPublicKey() {
        return this.senderPublicKey;
    }

    public ByteBuffer recipientPublicKey() {
        return this.recipientPublicKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String senderKmsIdentifier;
        protected ByteBuffer senderPublicKey;
        protected ByteBuffer recipientPublicKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(KmsPrivateKeyToStaticPublicKeyInput model) {
            this.senderKmsIdentifier = model.senderKmsIdentifier();
            this.senderPublicKey = model.senderPublicKey();
            this.recipientPublicKey = model.recipientPublicKey();
        }

        @Override
        public Builder senderKmsIdentifier(String senderKmsIdentifier) {
            this.senderKmsIdentifier = senderKmsIdentifier;
            return this;
        }

        @Override
        public String senderKmsIdentifier() {
            return this.senderKmsIdentifier;
        }

        @Override
        public Builder senderPublicKey(ByteBuffer senderPublicKey) {
            this.senderPublicKey = senderPublicKey;
            return this;
        }

        @Override
        public ByteBuffer senderPublicKey() {
            return this.senderPublicKey;
        }

        @Override
        public Builder recipientPublicKey(ByteBuffer recipientPublicKey) {
            this.recipientPublicKey = recipientPublicKey;
            return this;
        }

        @Override
        public ByteBuffer recipientPublicKey() {
            return this.recipientPublicKey;
        }

        @Override
        public KmsPrivateKeyToStaticPublicKeyInput build() {
            if (Objects.isNull(this.senderKmsIdentifier())) {
                throw new IllegalArgumentException("Missing value for required field `senderKmsIdentifier`");
            }
            if (Objects.isNull(this.recipientPublicKey())) {
                throw new IllegalArgumentException("Missing value for required field `recipientPublicKey`");
            }
            return new KmsPrivateKeyToStaticPublicKeyInput(this);
        }
    }

    public static interface Builder {
        public Builder senderKmsIdentifier(String var1);

        public String senderKmsIdentifier();

        public Builder senderPublicKey(ByteBuffer var1);

        public ByteBuffer senderPublicKey();

        public Builder recipientPublicKey(ByteBuffer var1);

        public ByteBuffer recipientPublicKey();

        public KmsPrivateKeyToStaticPublicKeyInput build();
    }
}

