/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsUtils_Compile;

import AwsArnParsing_Compile.AwsKmsIdentifier;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Function0;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.Tuple2;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import software.amazon.cryptography.materialproviders.internaldafny.types.DiscoveryFilter;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.services.kms.internaldafny.types.GetPublicKeyRequest;
import software.amazon.cryptography.services.kms.internaldafny.types.GetPublicKeyResponse;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenList;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;
import software.amazon.cryptography.services.kms.internaldafny.types.KeyUsageType;
import software.amazon.cryptography.services.kms.internaldafny.types.PublicKeyType;

public class __default {
    public static Result<DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>>, Error> StringifyEncryptionContext(DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> utf8EncCtx) {
        if (BigInteger.valueOf(utf8EncCtx.size()).signum() == 0) {
            return Result.create_Success(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), DafnyMap.fromElements((Tuple2[])new Tuple2[0]));
        }
        DafnyMap _0_stringifyResults = ((Function<DafnyMap, DafnyMap>)_1_utf8EncCtx -> (DafnyMap)((Function0)() -> {
            HashMap<DafnySequence, Result<Tuple2<DafnySequence<? extends Character>, DafnySequence<? extends Character>>, Error>> _coll0 = new HashMap<DafnySequence, Result<Tuple2<DafnySequence<? extends Character>, DafnySequence<? extends Character>>, Error>>();
            for (DafnySequence _compr_0_boxed0 : _1_utf8EncCtx.keySet().Elements()) {
                DafnySequence _compr_0 = _compr_0_boxed0;
                DafnySequence _2_utf8Key = _compr_0;
                if (!ValidUTF8Bytes._Is((DafnySequence<? extends Byte>)_2_utf8Key) || !_1_utf8EncCtx.keySet().contains((Object)_2_utf8Key)) continue;
                _coll0.put(_2_utf8Key, __default.StringifyEncryptionContextPair((DafnySequence<? extends Byte>)_2_utf8Key, (DafnySequence<? extends Byte>)((DafnySequence)_1_utf8EncCtx.get((Object)_2_utf8Key))));
            }
            return new DafnyMap(_coll0);
        }).apply()).apply(utf8EncCtx);
        if (((Function<DafnyMap, Boolean>)_3_stringifyResults -> Helpers.Quantifier((Iterable)_3_stringifyResults.valueSet().Elements(), (boolean)false, _exists_var_0_boxed0 -> {
            Result _exists_var_0;
            Result _4_r = _exists_var_0 = _exists_var_0_boxed0;
            return _3_stringifyResults.valueSet().contains((Object)_4_r) && _4_r.is_Failure();
        })).apply(_0_stringifyResults).booleanValue()) {
            return Result.create_Failure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption context contains invalid UTF8")));
        }
        boolean _5_stringKeysUnique = ((Function<DafnyMap, Boolean>)_6_stringifyResults -> Helpers.Quantifier((Iterable)_6_stringifyResults.keySet().Elements(), (boolean)true, _forall_var_0_boxed0 -> {
            DafnySequence _forall_var_0;
            DafnySequence _7_k = _forall_var_0 = _forall_var_0_boxed0;
            return Helpers.Quantifier((Iterable)_6_stringifyResults.keySet().Elements(), (boolean)true, _forall_var_1_boxed0 -> {
                DafnySequence _forall_var_1;
                DafnySequence _8_k_k = _forall_var_1 = _forall_var_1_boxed0;
                return !_6_stringifyResults.contains((Object)_7_k) || !_6_stringifyResults.contains((Object)_8_k_k) || _7_k.equals((Object)_8_k_k) || !((DafnySequence)((Tuple2)((Result)_6_stringifyResults.get((Object)_7_k)).dtor_value()).dtor__0()).equals(((Tuple2)((Result)_6_stringifyResults.get((Object)_8_k_k)).dtor_value()).dtor__0());
            });
        })).apply(_0_stringifyResults);
        if (!_5_stringKeysUnique) {
            return Result.create_Failure(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption context keys are not unique")));
        }
        return Result.create_Success(DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), ((Function<DafnyMap, DafnyMap>)_9_stringifyResults -> (DafnyMap)((Function0)() -> {
            HashMap<Object, Object> _coll1 = new HashMap<Object, Object>();
            Iterator iterator = _9_stringifyResults.valueSet().Elements().iterator();
            while (iterator.hasNext()) {
                Result _compr_1_boxed0;
                Result _compr_1;
                Result _10_r = _compr_1 = (_compr_1_boxed0 = (Result)iterator.next());
                if (!_9_stringifyResults.valueSet().contains((Object)_10_r)) continue;
                _coll1.put(((Tuple2)_10_r.dtor_value()).dtor__0(), ((Tuple2)_10_r.dtor_value()).dtor__1());
            }
            return new DafnyMap(_coll1);
        }).apply()).apply(_0_stringifyResults));
    }

    public static Result<Tuple2<DafnySequence<? extends Character>, DafnySequence<? extends Character>>, Error> StringifyEncryptionContextPair(DafnySequence<? extends Byte> utf8Key, DafnySequence<? extends Byte> utf8Value) {
        Result<DafnySequence<? extends Character>, Error> _0_valueOrError0 = UTF8.__default.Decode(utf8Key).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), __default::WrapStringToError);
        if (_0_valueOrError0.IsFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        }
        DafnySequence<? extends Character> _1_key = _0_valueOrError0.Extract((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
        Result<DafnySequence<? extends Character>, Error> _2_valueOrError1 = UTF8.__default.Decode(utf8Value).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), __default::WrapStringToError);
        if (_2_valueOrError1.IsFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
            return _2_valueOrError1.PropagateFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        }
        DafnySequence<? extends Character> _3_value = _2_valueOrError1.Extract((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
        return Result.create_Success(Tuple2._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), Tuple2.create(_1_key, _3_value));
    }

    public static Error WrapStringToError(DafnySequence<? extends Character> e) {
        return Error.create_AwsCryptographicMaterialProvidersException(e);
    }

    public static Result<Tuple0, Error> ValidateKmsKeyId(DafnySequence<? extends Character> keyId) {
        Result<AwsKmsIdentifier, Error> _0_valueOrError0 = AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(keyId).MapFailure(AwsKmsIdentifier._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), __default::WrapStringToError);
        if (_0_valueOrError0.IsFailure(AwsKmsIdentifier._typeDescriptor(), Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(AwsKmsIdentifier._typeDescriptor(), Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        AwsKmsIdentifier _1___v0 = _0_valueOrError0.Extract(AwsKmsIdentifier._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _2_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), UTF8.__default.IsASCIIString(keyId), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key identifier is not ASCII")));
        if (_2_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _2_valueOrError1.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        Outcome<Error> _3_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(keyId.length()).signum() == 1 && BigInteger.valueOf(keyId.length()).compareTo(AwsArnParsing_Compile.__default.MAX__AWS__KMS__IDENTIFIER__LENGTH()) <= 0, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key identifier is too long")));
        if (_3_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _3_valueOrError2.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        return Result.create_Success(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.create());
    }

    public static Result<DafnySequence<? extends DafnySequence<? extends Character>>, Error> GetValidGrantTokens(Option<DafnySequence<? extends DafnySequence<? extends Character>>> grantTokens) {
        DafnySequence<? extends DafnySequence<? extends Character>> _0_tokens = grantTokens.UnwrapOr((TypeDescriptor<DafnySequence<? extends DafnySequence<? extends Character>>>)DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), (DafnySequence<? extends DafnySequence<? extends Character>>)DafnySequence.empty((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        Outcome<Error> _1_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_0_tokens.length()).signum() != -1 && BigInteger.valueOf(_0_tokens.length()).compareTo(BigInteger.valueOf(10L)) <= 0, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Grant token list can have no more than 10 tokens")));
        if (_1_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _1_valueOrError0.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        }
        Outcome<Error> _2_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), ((Function<DafnySequence, Boolean>)_3_tokens -> Helpers.Quantifier((Iterable)_3_tokens.UniqueElements(), (boolean)true, _forall_var_0_boxed0 -> {
            DafnySequence _forall_var_0 = _forall_var_0_boxed0;
            DafnySequence _4_token = _forall_var_0;
            return !_3_tokens.contains((Object)_4_token) || BigInteger.ONE.compareTo(BigInteger.valueOf(_4_token.length())) <= 0 && BigInteger.valueOf(_4_token.length()).compareTo(BigInteger.valueOf(8192L)) <= 0;
        })).apply(_0_tokens), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Grant token list contains a grant token with invalid length")));
        if (_2_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _2_valueOrError1.PropagateFailure(Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)));
        }
        return Result.create_Success(DafnySequence._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), _0_tokens);
    }

    public static Result<DafnySequence<? extends Byte>, Error> GetEcdhPublicKey(IKMSClient client, DafnySequence<? extends Character> awsKmsKey) {
        Result<GetPublicKeyResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out0;
        Result<DafnySequence<? extends Byte>, Error> res = null;
        GetPublicKeyRequest _0_getPublicKeyRequest = GetPublicKeyRequest.create(awsKmsKey, Option.create_None(GrantTokenList._typeDescriptor()));
        Result<GetPublicKeyResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _1_maybePublicKeyResponse = _out0 = client.GetPublicKey(_0_getPublicKeyRequest);
        Result<GetPublicKeyResponse, Error> _2_valueOrError0 = Result.Default(GetPublicKeyResponse._typeDescriptor(), Error._typeDescriptor(), GetPublicKeyResponse.Default());
        _2_valueOrError0 = _1_maybePublicKeyResponse.MapFailure(GetPublicKeyResponse._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _3_e_boxed0 -> {
            software.amazon.cryptography.services.kms.internaldafny.types.Error _3_e = _3_e_boxed0;
            return Error.create_ComAmazonawsKms(_3_e);
        });
        if (_2_valueOrError0.IsFailure(GetPublicKeyResponse._typeDescriptor(), Error._typeDescriptor())) {
            res = _2_valueOrError0.PropagateFailure(GetPublicKeyResponse._typeDescriptor(), Error._typeDescriptor(), PublicKeyType._typeDescriptor());
            return res;
        }
        GetPublicKeyResponse _4_getPublicKeyResponse = _2_valueOrError0.Extract(GetPublicKeyResponse._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _5_valueOrError1 = Outcome.Default(Error._typeDescriptor());
        _5_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _4_getPublicKeyResponse.dtor_KeyId().is_Some() && _4_getPublicKeyResponse.dtor_KeyId().dtor_value().equals(awsKmsKey) && _4_getPublicKeyResponse.dtor_KeyUsage().is_Some() && Objects.equals(_4_getPublicKeyResponse.dtor_KeyUsage().dtor_value(), KeyUsageType.create_KEY__AGREEMENT()) && _4_getPublicKeyResponse.dtor_PublicKey().is_Some(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from KMS GetPublicKey")));
        if (_5_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _5_valueOrError1.PropagateFailure(Error._typeDescriptor(), PublicKeyType._typeDescriptor());
            return res;
        }
        res = Result.create_Success(PublicKeyType._typeDescriptor(), Error._typeDescriptor(), _4_getPublicKeyResponse.dtor_PublicKey().dtor_value());
        return res;
    }

    public static Result<Tuple2<DafnySequence<? extends Byte>, DafnySequence<? extends Byte>>, Error> ParseKeyNamespaceAndName(DafnySequence<? extends Character> keyNamespace, DafnySequence<? extends Character> keyName) {
        Result<DafnySequence<? extends Byte>, Error> _0_valueOrError0 = UTF8.__default.Encode(keyNamespace).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _1_e_boxed0 -> {
            DafnySequence _1_e = _1_e_boxed0;
            return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Key namespace could not be UTF8-encoded"), (DafnySequence)_1_e));
        });
        if (_0_valueOrError0.IsFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), Tuple2._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()));
        }
        DafnySequence<? extends Byte> _2_namespace = _0_valueOrError0.Extract(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _3_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_2_namespace.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key namespace too long")));
        if (_3_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _3_valueOrError1.PropagateFailure(Error._typeDescriptor(), Tuple2._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()));
        }
        Result<DafnySequence<? extends Byte>, Error> _4_valueOrError2 = UTF8.__default.Encode(keyName).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _5_e_boxed0 -> {
            DafnySequence _5_e = _5_e_boxed0;
            return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.concatenate((DafnySequence)DafnySequence.asString((String)"Key name could not be UTF8-encoded"), (DafnySequence)_5_e));
        });
        if (_4_valueOrError2.IsFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor())) {
            return _4_valueOrError2.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), Tuple2._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()));
        }
        DafnySequence<? extends Byte> _6_name = _4_valueOrError2.Extract(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _7_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_6_name.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key name too long")));
        if (_7_valueOrError3.IsFailure(Error._typeDescriptor())) {
            return _7_valueOrError3.PropagateFailure(Error._typeDescriptor(), Tuple2._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()));
        }
        return Result.create_Success(Tuple2._typeDescriptor(ValidUTF8Bytes._typeDescriptor(), ValidUTF8Bytes._typeDescriptor()), Error._typeDescriptor(), Tuple2.create(_2_namespace, _6_name));
    }

    public static Result<Tuple0, Error> ValidateDiscoveryFilter(DiscoveryFilter filter) {
        Outcome<Error> _0_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(filter.dtor_accountIds().length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Discovery filter must have at least one account ID")));
        if (_0_valueOrError0.IsFailure(Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        Outcome<Error> _1_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), ((Function<DiscoveryFilter, Boolean>)_2_filter -> Helpers.Quantifier((Iterable)_2_filter.dtor_accountIds().UniqueElements(), (boolean)true, _forall_var_0_boxed0 -> {
            DafnySequence _forall_var_0;
            DafnySequence _3_accountId = _forall_var_0 = _forall_var_0_boxed0;
            return !_2_filter.dtor_accountIds().contains((Object)_3_accountId) || BigInteger.valueOf(_3_accountId.length()).signum() == 1;
        })).apply(filter), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Discovery filter account IDs cannot be blank")));
        if (_1_valueOrError1.IsFailure(Error._typeDescriptor())) {
            return _1_valueOrError1.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        Outcome<Error> _4_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(filter.dtor_partition().length()).signum() == 1, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Discovery filter partition cannot be blank")));
        if (_4_valueOrError2.IsFailure(Error._typeDescriptor())) {
            return _4_valueOrError2.PropagateFailure(Error._typeDescriptor(), Tuple0._typeDescriptor());
        }
        return Result.create_Success(Tuple0._typeDescriptor(), Error._typeDescriptor(), Tuple0.create());
    }

    public String toString() {
        return "AwsKmsUtils._default";
    }
}

