/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.termstat;

import com.o19s.es.explore.StatisticsHelper;
import com.o19s.es.termstat.TermStatScorer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.opensearch.ltr.settings.LTRSettings;

public class TermStatQuery
extends Query {
    private Expression expr;
    private StatisticsHelper.AggrType aggr;
    private StatisticsHelper.AggrType posAggr;
    private Set<Term> terms;

    public TermStatQuery(Expression expr, StatisticsHelper.AggrType aggr, StatisticsHelper.AggrType posAggr, Set<Term> terms) {
        this.expr = expr;
        this.aggr = aggr;
        this.posAggr = posAggr;
        this.terms = terms;
    }

    public Expression getExpr() {
        return this.expr;
    }

    public StatisticsHelper.AggrType getAggr() {
        return this.aggr;
    }

    public StatisticsHelper.AggrType getPosAggr() {
        return this.posAggr;
    }

    public Set<Term> getTerms() {
        return this.terms;
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((TermStatQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(TermStatQuery other) {
        return Objects.equals(this.expr.sourceText, other.expr.sourceText) && Objects.equals((Object)this.aggr, (Object)other.aggr) && Objects.equals((Object)this.posAggr, (Object)other.posAggr) && Objects.equals(this.terms, other.terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expr.sourceText, this.aggr, this.posAggr, this.terms});
    }

    public String toString(String field) {
        return null;
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        if (!LTRSettings.isLTRPluginEnabled()) {
            throw new IllegalStateException("LTR plugin is disabled. To enable, update ltr.plugin.enabled to true");
        }
        assert (scoreMode.needsScores()) : "Should not be used in filtering mode";
        return new TermStatWeight(searcher, this, this.terms, scoreMode, this.aggr, this.posAggr);
    }

    public void visit(QueryVisitor visitor) {
        Term[] acceptedTerms = (Term[])this.terms.stream().filter(t -> visitor.acceptField(t.field())).toArray(Term[]::new);
        if (acceptedTerms.length > 0) {
            QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.SHOULD, (Query)this);
            v.consumeTerms((Query)this, acceptedTerms);
        }
    }

    static class TermStatWeight
    extends Weight {
        private final Expression expression;
        private final IndexSearcher searcher;
        private final ScoreMode scoreMode;
        private final StatisticsHelper.AggrType aggr;
        private final StatisticsHelper.AggrType posAggr;
        private final Set<Term> terms;
        private final Map<Term, TermStates> termContexts;

        TermStatWeight(IndexSearcher searcher, TermStatQuery tsq, Set<Term> terms, ScoreMode scoreMode, StatisticsHelper.AggrType aggr, StatisticsHelper.AggrType posAggr) throws IOException {
            super((Query)tsq);
            this.searcher = searcher;
            this.expression = tsq.expr;
            this.terms = terms;
            this.scoreMode = scoreMode;
            this.aggr = aggr;
            this.posAggr = posAggr;
            this.termContexts = new HashMap<Term, TermStates>();
            if (scoreMode.needsScores()) {
                for (Term t : terms) {
                    TermStates ctx = TermStates.build((IndexSearcher)searcher, (Term)t, (boolean)true);
                    if (ctx != null && ctx.docFreq() > 0) {
                        searcher.collectionStatistics(t.field());
                        searcher.termStatistics(t, ctx.docFreq(), ctx.totalTermFreq());
                    }
                    this.termContexts.put(t, ctx);
                }
            }
        }

        public void extractTerms(Set<Term> terms) {
            terms.addAll(terms);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            Scorer scorer = this.scorer(context);
            int newDoc = scorer.iterator().advance(doc);
            if (newDoc == doc) {
                return Explanation.match((Number)Float.valueOf(scorer.score()), (String)("weight(" + this.expression.sourceText + " in doc " + newDoc + ")"), (Explanation[])new Explanation[0]);
            }
            return Explanation.noMatch((String)"no matching term", (Explanation[])new Explanation[0]);
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            return new TermStatScorer(this, this.searcher, context, this.expression, this.terms, this.scoreMode, this.aggr, this.posAggr, this.termContexts);
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }
    }
}

