/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.utils;

import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.js.JavascriptCompiler;
import org.opensearch.SpecialPermission;
import org.opensearch.script.ClassPermission;
import org.opensearch.script.ScriptException;

public class Scripting {
    private Scripting() {
    }

    public static Object compile(String scriptSource) {
        return Scripting.compile(scriptSource, JavascriptCompiler.DEFAULT_FUNCTIONS);
    }

    public static Object compile(final String scriptSource, final Map<String, Method> functions) {
        final SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        return AccessController.doPrivileged(new PrivilegedAction<Expression>(){

            @Override
            public Expression run() {
                try {
                    final AccessControlContext engineContext = AccessController.getContext();
                    ClassLoader loader = this.getClass().getClassLoader();
                    if (sm != null) {
                        loader = new ClassLoader(loader){

                            @Override
                            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                                try {
                                    engineContext.checkPermission((Permission)new ClassPermission(name));
                                }
                                catch (SecurityException e) {
                                    throw new ClassNotFoundException(name, e);
                                }
                                return super.loadClass(name, resolve);
                            }
                        };
                    }
                    return JavascriptCompiler.compile((String)scriptSource, (Map)functions, (ClassLoader)loader);
                }
                catch (ParseException e) {
                    throw Scripting.convertToScriptException("compile error", scriptSource, scriptSource, e);
                }
            }
        });
    }

    private static ScriptException convertToScriptException(String message, String source, String portion, Throwable cause) {
        ArrayList<String> stack = new ArrayList<String>();
        stack.add(portion);
        StringBuilder pointer = new StringBuilder();
        if (cause instanceof ParseException) {
            int offset = ((ParseException)cause).getErrorOffset();
            for (int i = 0; i < offset; ++i) {
                pointer.append(' ');
            }
        }
        pointer.append("^---- HERE");
        stack.add(pointer.toString());
        throw new ScriptException(message, cause, stack, source, "STATIC_COMPILER");
    }
}

