/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.ranker.parser;

import com.o19s.es.ltr.ranker.parser.LtrRankerParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class LtrRankerParserFactory {
    private final Map<String, Supplier<LtrRankerParser>> parsers;

    private LtrRankerParserFactory(Map<String, Supplier<LtrRankerParser>> parsers) {
        this.parsers = parsers;
    }

    public LtrRankerParser getParser(String type) {
        Supplier<LtrRankerParser> supplier = this.parsers.get(type);
        if (supplier == null) {
            throw new IllegalArgumentException("Unsupported LtrRanker format/type [" + type + "]");
        }
        return supplier.get();
    }

    public static class Builder {
        private final Map<String, Supplier<LtrRankerParser>> registry = new HashMap<String, Supplier<LtrRankerParser>>();

        public Builder register(String type, Supplier<LtrRankerParser> parser) {
            if (this.registry.put(type, parser) != null) {
                throw new RuntimeException("Cannot register LtrRankerParser: [" + type + "] already registered.");
            }
            return this;
        }

        public LtrRankerParserFactory build() {
            return new LtrRankerParserFactory(Collections.unmodifiableMap(this.registry));
        }
    }
}

