/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.action;

import com.o19s.es.ltr.feature.FeatureValidation;
import com.o19s.es.ltr.feature.store.StorableElement;
import java.io.IOException;
import java.util.Objects;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestBuilder;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionType;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.common.xcontent.StatusToXContentObject;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class FeatureStoreAction
extends ActionType<FeatureStoreResponse> {
    public static final String NAME = "cluster:admin/ltr/featurestore/data";
    public static final FeatureStoreAction INSTANCE = new FeatureStoreAction();

    protected FeatureStoreAction() {
        super(NAME, FeatureStoreResponse::new);
    }

    public Writeable.Reader<FeatureStoreResponse> getResponseReader() {
        return FeatureStoreResponse::new;
    }

    public static class FeatureStoreResponse
    extends ActionResponse
    implements StatusToXContentObject {
        private IndexResponse response;

        public FeatureStoreResponse(StreamInput in) throws IOException {
            super(in);
            this.response = new IndexResponse(in);
        }

        public FeatureStoreResponse(IndexResponse response) {
            this.response = response;
        }

        public IndexResponse getResponse() {
            return this.response;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.response.writeTo(out);
        }

        public RestStatus status() {
            return this.response.status();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.response.toXContent(builder, params);
        }
    }

    public static class FeatureStoreRequest
    extends ActionRequest {
        private String store;
        private Action action;
        private StorableElement storableElement;
        private Long updatedVersion;
        private String routing;
        private FeatureValidation validation;

        public FeatureStoreRequest() {
        }

        public FeatureStoreRequest(StreamInput in) throws IOException {
            super(in);
            this.store = in.readString();
            this.routing = in.readOptionalString();
            this.action = Action.values()[in.readVInt()];
            this.storableElement = (StorableElement)in.readNamedWriteable(StorableElement.class);
            this.validation = (FeatureValidation)in.readOptionalWriteable(FeatureValidation::new);
        }

        public FeatureStoreRequest(String store, StorableElement storableElement, Action action) {
            this.store = Objects.requireNonNull(store);
            this.storableElement = Objects.requireNonNull(storableElement);
            this.action = Objects.requireNonNull(action);
        }

        public FeatureStoreRequest(String store, StorableElement storableElement, long updatedVersion) {
            this.store = Objects.requireNonNull(store);
            this.storableElement = Objects.requireNonNull(storableElement);
            this.action = Action.UPDATE;
            this.updatedVersion = updatedVersion;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException arve = null;
            if (this.store == null) {
                arve = ValidateActions.addValidationError((String)"store must be set", null);
            }
            if (!this.store.equals(".ltrstore") && !this.store.startsWith(".ltrstore_")) {
                arve = ValidateActions.addValidationError((String)("Store name [" + this.store + "] is invalid."), (ActionRequestValidationException)arve);
            }
            if (this.storableElement == null) {
                arve = ValidateActions.addValidationError((String)"storable element must be set", (ActionRequestValidationException)arve);
            }
            if (this.action == Action.UPDATE && !this.storableElement.updatable()) {
                arve = ValidateActions.addValidationError((String)("Elements of type [" + this.storableElement.type() + "] are not updatable."), (ActionRequestValidationException)arve);
            }
            if (this.updatedVersion != null && this.action != Action.UPDATE) {
                arve = ValidateActions.addValidationError((String)"Only UPDATE supports a version.", (ActionRequestValidationException)arve);
            }
            return arve;
        }

        public String getStore() {
            return this.store;
        }

        public void setStore(String store) {
            this.store = store;
        }

        public Action getAction() {
            return this.action;
        }

        public void setAction(Action action) {
            this.action = action;
        }

        public StorableElement getStorableElement() {
            return this.storableElement;
        }

        public void setStorableElement(StorableElement storableElement) {
            this.storableElement = storableElement;
        }

        public String getRouting() {
            return this.routing;
        }

        public void setRouting(String routing) {
            this.routing = routing;
        }

        public Long getUpdatedVersion() {
            return this.updatedVersion;
        }

        public FeatureValidation getValidation() {
            return this.validation;
        }

        public void setValidation(FeatureValidation validation) {
            this.validation = validation;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.store);
            out.writeOptionalString(this.routing);
            out.writeVInt(this.action.ordinal());
            out.writeNamedWriteable((NamedWriteable)this.storableElement);
            out.writeOptionalWriteable((Writeable)this.validation);
        }

        public static enum Action {
            CREATE,
            UPDATE;

        }
    }

    public static class FeatureStoreRequestBuilder
    extends ActionRequestBuilder<FeatureStoreRequest, FeatureStoreResponse> {
        public FeatureStoreRequestBuilder(OpenSearchClient client, FeatureStoreAction action) {
            super(client, (ActionType)action, (ActionRequest)new FeatureStoreRequest());
        }
    }
}

