/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.action;

import com.o19s.es.ltr.feature.FeatureValidation;
import com.o19s.es.ltr.feature.store.StoredFeature;
import java.io.IOException;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestBuilder;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionType;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.common.xcontent.StatusToXContentObject;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class AddFeaturesToSetAction
extends ActionType<AddFeaturesToSetResponse> {
    public static final AddFeaturesToSetAction INSTANCE = new AddFeaturesToSetAction();
    public static final String NAME = "cluster:admin/ltr/store/add-features-to-set";

    protected AddFeaturesToSetAction() {
        super(NAME, AddFeaturesToSetResponse::new);
    }

    public Writeable.Reader<AddFeaturesToSetResponse> getResponseReader() {
        return AddFeaturesToSetResponse::new;
    }

    public static class AddFeaturesToSetResponse
    extends ActionResponse
    implements StatusToXContentObject {
        private IndexResponse response;

        public AddFeaturesToSetResponse(StreamInput in) throws IOException {
            super(in);
            this.response = new IndexResponse(in);
        }

        public AddFeaturesToSetResponse(IndexResponse response) {
            this.response = response;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.response.writeTo(out);
        }

        public RestStatus status() {
            return this.response.status();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.response.toXContent(builder, params);
        }

        public IndexResponse getResponse() {
            return this.response;
        }
    }

    public static class AddFeaturesToSetRequest
    extends ActionRequest {
        private String store;
        private String featureNameQuery;
        private List<StoredFeature> features;
        private boolean merge;
        private String featureSet;
        private String routing;
        private FeatureValidation validation;

        public AddFeaturesToSetRequest() {
        }

        public AddFeaturesToSetRequest(StreamInput in) throws IOException {
            super(in);
            this.store = in.readString();
            this.features = in.readList(StoredFeature::new);
            if (in.readBoolean()) {
                this.featureNameQuery = in.readOptionalString();
            }
            this.merge = in.readBoolean();
            this.featureSet = in.readString();
            this.routing = in.readOptionalString();
            this.validation = (FeatureValidation)in.readOptionalWriteable(FeatureValidation::new);
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException arve = null;
            if (this.store == null) {
                arve = ValidateActions.addValidationError((String)"store must be set", null);
            }
            if (this.featureNameQuery != null && this.features != null && !this.features.isEmpty()) {
                arve = ValidateActions.addValidationError((String)"if featureNameQuery is set features cannot", (ActionRequestValidationException)arve);
            } else if (this.featureNameQuery == null && (this.features == null || this.features.isEmpty())) {
                arve = ValidateActions.addValidationError((String)"either featureNameQuery or features must be set", (ActionRequestValidationException)arve);
            }
            if (this.featureSet == null) {
                arve = ValidateActions.addValidationError((String)"featureSet must be set", (ActionRequestValidationException)arve);
            }
            return arve;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.store);
            out.writeOptionalString(this.featureNameQuery);
            if (this.features != null) {
                out.writeList(this.features);
            }
            out.writeBoolean(this.merge);
            out.writeString(this.featureSet);
            out.writeOptionalString(this.routing);
            out.writeOptionalWriteable((Writeable)this.validation);
        }

        public String getStore() {
            return this.store;
        }

        public String getFeatureNameQuery() {
            return this.featureNameQuery;
        }

        public String getFeatureSet() {
            return this.featureSet;
        }

        public void setStore(String store) {
            this.store = store;
        }

        public void setFeatureNameQuery(String featureNameQuery) {
            this.featureNameQuery = featureNameQuery;
        }

        public void setFeatureSet(String featureSet) {
            this.featureSet = featureSet;
        }

        public String getRouting() {
            return this.routing;
        }

        public void setRouting(String routing) {
            this.routing = routing;
        }

        public List<StoredFeature> getFeatures() {
            return this.features;
        }

        public void setFeatures(List<StoredFeature> features) {
            this.features = features;
        }

        public boolean isMerge() {
            return this.merge;
        }

        public void setMerge(boolean merge) {
            this.merge = merge;
        }

        public FeatureValidation getValidation() {
            return this.validation;
        }

        public void setValidation(FeatureValidation validation) {
            this.validation = validation;
        }
    }

    public static class AddFeaturesToSetRequestBuilder
    extends ActionRequestBuilder<AddFeaturesToSetRequest, AddFeaturesToSetResponse> {
        public AddFeaturesToSetRequestBuilder(OpenSearchClient client) {
            super(client, (ActionType)INSTANCE, (ActionRequest)new AddFeaturesToSetRequest());
        }
    }
}

