/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.FutureUtils;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.common.WorkflowResources;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.exception.WorkflowStepException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;
import org.opensearch.ml.client.MachineLearningNodeClient;
import org.opensearch.ml.common.MLTask;
import org.opensearch.threadpool.ThreadPool;

public abstract class AbstractRetryableWorkflowStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(AbstractRetryableWorkflowStep.class);
    private TimeValue retryDuration;
    private final MachineLearningNodeClient mlClient;
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    private ThreadPool threadPool;

    protected AbstractRetryableWorkflowStep(ThreadPool threadPool, MachineLearningNodeClient mlClient, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler, FlowFrameworkSettings flowFrameworkSettings) {
        this.threadPool = threadPool;
        this.retryDuration = flowFrameworkSettings.getRetryDuration();
        this.mlClient = mlClient;
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
    }

    protected void retryableGetMlTask(WorkflowData currentNodeInputs, String nodeId, PlainActionFuture<WorkflowData> future, String taskId, String workflowStep, String tenantId, ActionListener<WorkflowData> mlTaskListener) {
        CompletableFuture.runAsync(() -> {
            do {
                this.mlClient.getTask(taskId, tenantId, ActionListener.wrap(response -> {
                    String resourceName = WorkflowResources.getResourceByWorkflowStep(this.getName());
                    String id = this.getResourceId((MLTask)response);
                    switch (response.getState()) {
                        case COMPLETED: {
                            logger.info("{} successful for {} and {} {}", (Object)workflowStep, (Object)currentNodeInputs, (Object)resourceName, (Object)id);
                            ActionListener resourceListener = ActionListener.wrap(r -> {
                                HashMap<String, Object> content = new HashMap<String, Object>(r.getContent());
                                content.put("register_model_status", response.getState().toString());
                                mlTaskListener.onResponse((Object)new WorkflowData(content, r.getWorkflowId(), r.getNodeId()));
                            }, arg_0 -> ((ActionListener)mlTaskListener).onFailure(arg_0));
                            this.flowFrameworkIndicesHandler.addResourceToStateIndex(currentNodeInputs, nodeId, this.getName(), id, tenantId, (ActionListener<WorkflowData>)resourceListener);
                            break;
                        }
                        case FAILED: 
                        case COMPLETED_WITH_ERROR: {
                            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("{} failed with error : {}", (Object)workflowStep, (Object)response.getError()).getFormattedMessage();
                            logger.error(errorMessage);
                            mlTaskListener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST)));
                            break;
                        }
                        case CANCELLED: {
                            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("{} task was cancelled.", (Object)workflowStep).getFormattedMessage();
                            logger.error(errorMessage);
                            mlTaskListener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.REQUEST_TIMEOUT)));
                            break;
                        }
                    }
                }, exception -> {
                    String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("{} failed", (Object)workflowStep).getFormattedMessage();
                    logger.error(errorMessage, (Throwable)exception);
                    mlTaskListener.onFailure((Exception)((Object)new WorkflowStepException(errorMessage, RestStatus.BAD_REQUEST)));
                }));
                try {
                    Thread.sleep(this.retryDuration.getMillis());
                }
                catch (InterruptedException e) {
                    FutureUtils.cancel((Future)future);
                    Thread.currentThread().interrupt();
                }
            } while (!future.isDone());
        }, this.threadPool.executor("opensearch_workflow"));
    }

    protected abstract String getResourceId(MLTask var1);
}

