/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.impl;

import com.oracle.labs.mlrg.olcut.util.SortUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.tribuo.Example;
import org.tribuo.Feature;
import org.tribuo.FeatureMap;
import org.tribuo.Output;
import org.tribuo.VariableInfo;
import org.tribuo.transform.TransformerMap;
import org.tribuo.util.Merger;

public final class BinaryFeaturesExample<T extends Output<T>>
extends Example<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(BinaryFeaturesExample.class.getName());
    public static final int DEFAULT_SIZE = 10;
    protected String[] featureNames;
    protected int size = 0;

    public BinaryFeaturesExample(T output, float weight, int initialSize) {
        super(output, weight);
        this.featureNames = new String[initialSize];
    }

    public BinaryFeaturesExample(T output, float weight, Map<String, Object> metadata) {
        super(output, weight, metadata);
        this.featureNames = new String[10];
    }

    public BinaryFeaturesExample(T output, float weight) {
        super(output, weight);
        this.featureNames = new String[10];
    }

    public BinaryFeaturesExample(T output, Map<String, Object> metadata) {
        super(output, metadata);
        this.featureNames = new String[10];
    }

    public BinaryFeaturesExample(T output) {
        super(output);
        this.featureNames = new String[10];
    }

    public BinaryFeaturesExample(T output, String[] names) {
        super(output);
        this.size = names.length;
        this.featureNames = Arrays.copyOf(names, names.length);
        this.sort();
    }

    public BinaryFeaturesExample(T output, List<? extends Feature> features) {
        super(output);
        this.size = features.size();
        this.featureNames = new String[this.size];
        int i = 0;
        for (Feature feature : features) {
            BinaryFeaturesExample.checkIsBinary(feature);
            this.featureNames[i] = feature.getName();
            ++i;
        }
        this.sort();
    }

    public BinaryFeaturesExample(Example<T> other) {
        super(other);
        this.featureNames = new String[other.size()];
        for (Feature f : other) {
            BinaryFeaturesExample.checkIsBinary(f);
            this.featureNames[this.size] = f.getName();
            ++this.size;
        }
    }

    public <U extends Output<U>> BinaryFeaturesExample(T output, Example<U> other, float weight) {
        super(output, weight);
        this.featureNames = new String[other.size()];
        for (Feature f : other) {
            BinaryFeaturesExample.checkIsBinary(f);
            this.featureNames[this.size] = f.getName();
            ++this.size;
        }
    }

    public void add(String name) {
        if (this.size >= this.featureNames.length) {
            this.growArray();
        }
        this.featureNames[this.size] = name;
        ++this.size;
        this.sort();
    }

    public static boolean isBinary(Feature feature) {
        return feature.getValue() == 1.0;
    }

    public static void checkIsBinary(Feature feature) {
        if (!BinaryFeaturesExample.isBinary(feature)) {
            throw new IllegalArgumentException("non-binary features are not allowed in BinaryFeaturesExample: value=" + feature.getValue());
        }
    }

    @Override
    public void add(Feature feature) {
        BinaryFeaturesExample.checkIsBinary(feature);
        this.add(feature.getName());
    }

    @Override
    public void addAll(Collection<? extends Feature> features) {
        if (this.size + features.size() >= this.featureNames.length) {
            this.growArray(this.size + features.size());
        }
        for (Feature feature : features) {
            BinaryFeaturesExample.checkIsBinary(feature);
            this.featureNames[this.size] = feature.getName();
            ++this.size;
        }
        this.sort();
    }

    protected void growArray(int minCapacity) {
        int newCapacity = this.newCapacity(minCapacity);
        this.featureNames = Arrays.copyOf(this.featureNames, newCapacity);
    }

    protected void growArray() {
        this.growArray(this.size + 1);
    }

    protected int newCapacity(int minCapacity) {
        int oldCapacity = this.featureNames.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity <= 0) {
            if (minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            return minCapacity;
        }
        return newCapacity;
    }

    @Override
    protected void sort() {
        int[] sortedIndices = SortUtil.argsort((Comparable[])this.featureNames, (int)0, (int)this.size, (boolean)true);
        String[] newNames = Arrays.copyOf(this.featureNames, this.size);
        for (int i = 0; i < sortedIndices.length; ++i) {
            this.featureNames[i] = newNames[sortedIndices[i]];
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void removeFeatures(List<Feature> featureList) {
        HashMap<String, List> map = new HashMap<String, List>();
        for (int i = 0; i < this.featureNames.length; ++i) {
            List list = map.computeIfAbsent(this.featureNames[i], k -> new ArrayList());
            list.add(i);
        }
        PriorityQueue removeQueue = new PriorityQueue();
        for (Feature f : featureList) {
            List i = (List)map.get(f.getName());
            if (i == null) continue;
            map.remove(f.getName());
            removeQueue.addAll(i);
        }
        String[] newNames = new String[this.size - removeQueue.size()];
        int source = 0;
        int dest = 0;
        while (!removeQueue.isEmpty()) {
            int curRemoveIdx = (Integer)removeQueue.poll();
            while (source < curRemoveIdx) {
                newNames[dest] = this.featureNames[source];
                ++source;
                ++dest;
            }
            ++source;
        }
        while (source < this.size) {
            newNames[dest] = this.featureNames[source];
            ++source;
            ++dest;
        }
        this.featureNames = newNames;
        this.size = this.featureNames.length;
    }

    @Override
    public boolean validateExample() {
        if (this.size == 0) {
            return false;
        }
        HashSet<String> names = new HashSet<String>(Arrays.asList(this.featureNames).subList(0, this.size));
        return names.size() == this.size;
    }

    @Override
    public BinaryFeaturesExample<T> copy() {
        return new BinaryFeaturesExample<T>(this);
    }

    @Override
    public Feature lookup(String i) {
        int index = Arrays.binarySearch(this.featureNames, 0, this.size, i);
        if (index < 0) {
            return null;
        }
        return new Feature(this.featureNames[index], 1.0);
    }

    @Override
    public void set(Feature feature) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void transform(TransformerMap transformerMap) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reduceByName(Merger merger) {
        if (this.size > 0) {
            List<String> newNames = Arrays.stream(this.featureNames, 0, this.size).distinct().collect(Collectors.toList());
            Collections.sort(newNames);
            this.featureNames = newNames.toArray(new String[newNames.size()]);
            this.size = this.featureNames.length;
        } else {
            logger.finer("Reducing an example with no features.");
        }
    }

    @Override
    public boolean isDense(FeatureMap fMap) {
        if (fMap.size() == this.size()) {
            for (String name : this.featureNames) {
                if (fMap.get(name) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void densify(List<String> featureList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void densify(FeatureMap fMap) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Feature> iterator() {
        return new BinaryFeaturesExampleIterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ArrayExample(numFeatures=");
        builder.append(this.size);
        builder.append(",output=");
        builder.append(this.output);
        builder.append(",weight=");
        builder.append(this.weight);
        if (this.metadata != null) {
            builder.append(",metadata=");
            builder.append(this.metadata.toString());
        }
        builder.append(",features=[");
        for (int i = 0; i < this.size; ++i) {
            builder.append('(').append(this.featureNames[i]).append(", ").append(1.0).append(')');
            if (i == 0) continue;
            builder.append(", ");
        }
        builder.append("])");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinaryFeaturesExample)) {
            return false;
        }
        BinaryFeaturesExample that = (BinaryFeaturesExample)o;
        if (Objects.equals(this.metadata, that.metadata) && this.output.getClass().equals(that.output.getClass())) {
            boolean outputTest = this.output.fullEquals(that.output);
            if (outputTest && this.size == that.size) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.featureNames[i].equals(that.featureNames[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int result = Objects.hash(this.size);
        result = 31 * result + this.output.hashCode();
        for (int i = 0; i < this.size; ++i) {
            result = 31 * result + this.featureNames[i].hashCode();
        }
        return result;
    }

    @Override
    public void canonicalize(FeatureMap featureMap) {
        for (int i = 0; i < this.featureNames.length; ++i) {
            VariableInfo vi = featureMap.get(this.featureNames[i]);
            if (vi == null) continue;
            this.featureNames[i] = vi.getName();
        }
    }

    class BinaryFeaturesExampleIterator
    implements Iterator<Feature> {
        int pos = 0;

        BinaryFeaturesExampleIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < BinaryFeaturesExample.this.size;
        }

        @Override
        public Feature next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Iterator exhausted at position " + this.pos);
            }
            Feature f = new Feature(BinaryFeaturesExample.this.featureNames[this.pos], 1.0);
            ++this.pos;
            return f;
        }
    }
}

