/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.evaluation.metrics;

import java.util.Collections;
import java.util.List;
import org.tribuo.Model;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.sequence.SequenceModel;

public abstract class MetricContext<T extends Output<T>> {
    private final Model<T> model;
    private final SequenceModel<T> seqModel;
    private final List<Prediction<T>> predictions;

    protected MetricContext(Model<T> model, List<Prediction<T>> predictions) {
        this.model = model;
        this.seqModel = null;
        this.predictions = Collections.unmodifiableList(predictions);
    }

    protected MetricContext(SequenceModel<T> model, List<Prediction<T>> predictions) {
        this.model = null;
        this.seqModel = model;
        this.predictions = Collections.unmodifiableList(predictions);
    }

    public Model<T> getModel() {
        return this.model;
    }

    public SequenceModel<T> getSequenceModel() {
        return this.seqModel;
    }

    public List<Prediction<T>> getPredictions() {
        return this.predictions;
    }
}

