/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasources.glue;

import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.datasource.model.DataSource;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasource.model.DataSourceType;
import org.opensearch.sql.datasources.glue.GlueDataSourceFactory;

public class SecurityLakeDataSourceFactory
extends GlueDataSourceFactory {
    private final Settings pluginSettings;
    public static final String TRUE = "true";

    public SecurityLakeDataSourceFactory(Settings pluginSettings) {
        super(pluginSettings);
        this.pluginSettings = pluginSettings;
    }

    @Override
    public DataSourceType getDataSourceType() {
        return DataSourceType.SECURITY_LAKE;
    }

    @Override
    public DataSource createDataSource(DataSourceMetadata metadata) {
        this.validateProperties(metadata.getProperties());
        metadata.getProperties().put("glue.iceberg.enabled", TRUE);
        metadata.getProperties().put("glue.lakeformation.enabled", TRUE);
        return super.createDataSource(metadata);
    }

    private void validateProperties(Map<String, String> properties) {
        if (properties.get("glue.iceberg.enabled") != null && !BooleanUtils.toBoolean((String)properties.get("glue.iceberg.enabled"))) {
            throw new IllegalArgumentException("glue.iceberg.enabled cannot be false when using Security Lake data source.");
        }
        if (properties.get("glue.lakeformation.enabled") != null && !BooleanUtils.toBoolean((String)properties.get("glue.lakeformation.enabled"))) {
            throw new IllegalArgumentException("glue.lakeformation.enabled cannot be false when using Security Lake data source.");
        }
        if (StringUtils.isBlank((CharSequence)properties.get("glue.lakeformation.session_tag"))) {
            throw new IllegalArgumentException("glue.lakeformation.session_tag must be specified when using Security Lake data source");
        }
    }
}

