/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.collectors;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;

class CachedStats {
    private static final Set<String> CACHABLE_VALUES = new HashSet<String>(Arrays.asList(AllMetrics.ShardStatsValue.INDEXING_THROTTLE_TIME.toString(), AllMetrics.ShardStatsValue.CACHE_QUERY_HIT.toString(), AllMetrics.ShardStatsValue.CACHE_QUERY_MISS.toString(), AllMetrics.ShardStatsValue.CACHE_FIELDDATA_EVICTION.toString(), AllMetrics.ShardStatsValue.CACHE_REQUEST_HIT.toString(), AllMetrics.ShardStatsValue.CACHE_REQUEST_MISS.toString(), AllMetrics.ShardStatsValue.CACHE_REQUEST_EVICTION.toString(), AllMetrics.ShardStatsValue.REFRESH_EVENT.toString(), AllMetrics.ShardStatsValue.REFRESH_TIME.toString(), AllMetrics.ShardStatsValue.FLUSH_EVENT.toString(), AllMetrics.ShardStatsValue.FLUSH_TIME.toString(), AllMetrics.ShardStatsValue.MERGE_EVENT.toString(), AllMetrics.ShardStatsValue.MERGE_TIME.toString()));
    private Map<String, Long> cachedValues = new HashMap<String, Long>();

    CachedStats() {
    }

    long getValue(String statsName) {
        return this.cachedValues.getOrDefault(statsName, 0L);
    }

    void putValue(String statsName, long value) {
        this.cachedValues.put(statsName, value);
    }

    static Set<String> getCachableValues() {
        return CACHABLE_VALUES;
    }
}

