/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.alerting.comments.CommentsIndices;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.transport.SecureTransportAction;
import org.opensearch.alerting.transport.TransportIndexAlertingCommentAction;
import org.opensearch.alerting.transport.TransportIndexAlertingCommentActionKt;
import org.opensearch.alerting.util.CommentsUtils;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.action.IndexCommentRequest;
import org.opensearch.commons.alerting.action.IndexCommentResponse;
import org.opensearch.commons.alerting.model.Alert;
import org.opensearch.commons.alerting.model.Comment;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestRequest;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u00018BG\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J&\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00022\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000307H\u0014R\u0018\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0018\u0010 \u001a\n \u0018*\u0004\u0018\u00010!0!X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\"R$\u0010#\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0016\u0010(\u001a\n \u0018*\u0004\u0018\u00010)0)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010*\u001a\n \u0018*\u0004\u0018\u00010!0!X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\"R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u00069"}, d2={"Lorg/opensearch/alerting/transport/TransportIndexAlertingCommentAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/action/ActionRequest;", "Lorg/opensearch/commons/alerting/action/IndexCommentResponse;", "Lorg/opensearch/alerting/transport/SecureTransportAction;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "commentsIndices", "Lorg/opensearch/alerting/comments/CommentsIndices;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "namedWriteableRegistry", "Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/alerting/comments/CommentsIndices;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/core/xcontent/NamedXContentRegistry;Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;)V", "alertingCommentsEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "getClient", "()Lorg/opensearch/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getCommentsIndices", "()Lorg/opensearch/alerting/comments/CommentsIndices;", "commentsMaxContentSize", "", "Ljava/lang/Long;", "filterByEnabled", "getFilterByEnabled", "()Ljava/lang/Boolean;", "setFilterByEnabled", "(Ljava/lang/Boolean;)V", "indexTimeout", "Lorg/opensearch/common/unit/TimeValue;", "maxCommentsPerAlert", "getNamedWriteableRegistry", "()Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "IndexCommentHandler", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nTransportIndexAlertingCommentAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportIndexAlertingCommentAction.kt\norg/opensearch/alerting/transport/TransportIndexAlertingCommentAction\n+ 2 TransportHelpers.kt\norg/opensearch/commons/utils/TransportHelpersKt\n*L\n1#1,389:1\n48#2,5:390\n*S KotlinDebug\n*F\n+ 1 TransportIndexAlertingCommentAction.kt\norg/opensearch/alerting/transport/TransportIndexAlertingCommentAction\n*L\n115#1:390,5\n*E\n"})
public final class TransportIndexAlertingCommentAction
extends HandledTransportAction<ActionRequest, IndexCommentResponse>
implements SecureTransportAction {
    @NotNull
    private final Client client;
    @NotNull
    private final CommentsIndices commentsIndices;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private final NamedWriteableRegistry namedWriteableRegistry;
    private volatile Boolean alertingCommentsEnabled;
    private volatile Long commentsMaxContentSize;
    private volatile Long maxCommentsPerAlert;
    private volatile TimeValue indexTimeout;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportIndexAlertingCommentAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull CommentsIndices commentsIndices, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry, @NotNull NamedWriteableRegistry namedWriteableRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)commentsIndices, (String)"commentsIndices");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)namedWriteableRegistry, (String)"namedWriteableRegistry");
        super("cluster:admin/opensearch/alerting/comments/write", transportService, actionFilters, IndexCommentRequest::new);
        this.client = client;
        this.commentsIndices = commentsIndices;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.alertingCommentsEnabled = (Boolean)AlertingSettings.Companion.getALERTING_COMMENTS_ENABLED().get(this.settings);
        this.commentsMaxContentSize = (Long)AlertingSettings.Companion.getCOMMENTS_MAX_CONTENT_SIZE().get(this.settings);
        this.maxCommentsPerAlert = (Long)AlertingSettings.Companion.getMAX_COMMENTS_PER_ALERT().get(this.settings);
        this.indexTimeout = (TimeValue)AlertingSettings.Companion.getINDEX_TIMEOUT().get(this.settings);
        this.filterByEnabled = (Boolean)AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getALERTING_COMMENTS_ENABLED(), arg_0 -> TransportIndexAlertingCommentAction._init_$lambda$0(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getCOMMENTS_MAX_CONTENT_SIZE(), arg_0 -> TransportIndexAlertingCommentAction._init_$lambda$1(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getMAX_COMMENTS_PER_ALERT(), arg_0 -> TransportIndexAlertingCommentAction._init_$lambda$2(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(AlertingSettings.Companion.getINDEX_TIMEOUT(), arg_0 -> TransportIndexAlertingCommentAction._init_$lambda$3(this, arg_0));
        this.listenFilterBySettingChange(this.clusterService);
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final CommentsIndices getCommentsIndices() {
        return this.commentsIndices;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @NotNull
    public final NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.namedWriteableRegistry;
    }

    public Boolean getFilterByEnabled() {
        return this.filterByEnabled;
    }

    public void setFilterByEnabled(Boolean bl) {
        this.filterByEnabled = bl;
    }

    /*
     * Exception decompiling
     */
    protected void doExecute(@NotNull Task task, @NotNull ActionRequest request, @NotNull ActionListener<IndexCommentResponse> actionListener) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void listenFilterBySettingChange(@NotNull ClusterService clusterService) {
        SecureTransportAction.DefaultImpls.listenFilterBySettingChange(this, clusterService);
    }

    @Override
    @Nullable
    public User readUserFromThreadContext(@NotNull Client client) {
        return SecureTransportAction.DefaultImpls.readUserFromThreadContext(this, client);
    }

    @Override
    public boolean doFilterForUser(@Nullable User user) {
        return SecureTransportAction.DefaultImpls.doFilterForUser(this, user);
    }

    @Override
    public boolean isAdmin(@Nullable User user) {
        return SecureTransportAction.DefaultImpls.isAdmin(this, user);
    }

    @Override
    public <T> boolean validateUserBackendRoles(@Nullable User user, @NotNull ActionListener<T> actionListener) {
        return SecureTransportAction.DefaultImpls.validateUserBackendRoles(this, user, actionListener);
    }

    @Override
    public <T> boolean checkUserPermissionsWithResource(@Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
        return SecureTransportAction.DefaultImpls.checkUserPermissionsWithResource(this, requesterUser, resourceUser, actionListener, resourceType, resourceId);
    }

    private static final void _init_$lambda$0(TransportIndexAlertingCommentAction this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.alertingCommentsEnabled = it;
    }

    private static final void _init_$lambda$1(TransportIndexAlertingCommentAction this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.commentsMaxContentSize = it;
    }

    private static final void _init_$lambda$2(TransportIndexAlertingCommentAction this$0, Long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.maxCommentsPerAlert = it;
    }

    private static final void _init_$lambda$3(TransportIndexAlertingCommentAction this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.indexTimeout = it;
    }

    public static final /* synthetic */ Long access$getMaxCommentsPerAlert$p(TransportIndexAlertingCommentAction $this) {
        return $this.maxCommentsPerAlert;
    }

    public static final /* synthetic */ TimeValue access$getIndexTimeout$p(TransportIndexAlertingCommentAction $this) {
        return $this.indexTimeout;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0011\u0010\u0015\u001a\u00020\u0016H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0011\u0010\u0017\u001a\u00020\u0016H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0011\u0010\u0018\u001a\u00020\u0016H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lorg/opensearch/alerting/transport/TransportIndexAlertingCommentAction$IndexCommentHandler;", "", "client", "Lorg/opensearch/client/Client;", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "Lorg/opensearch/commons/alerting/action/IndexCommentResponse;", "request", "Lorg/opensearch/commons/alerting/action/IndexCommentRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "(Lorg/opensearch/alerting/transport/TransportIndexAlertingCommentAction;Lorg/opensearch/client/Client;Lorg/opensearch/core/action/ActionListener;Lorg/opensearch/commons/alerting/action/IndexCommentRequest;Lorg/opensearch/commons/authuser/User;)V", "checkShardsFailure", "", "response", "Lorg/opensearch/action/index/IndexResponse;", "getAlert", "Lorg/opensearch/commons/alerting/model/Alert;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getComment", "Lorg/opensearch/commons/alerting/model/Comment;", "indexComment", "", "start", "updateComment", "opensearch-alerting"})
    @SourceDebugExtension(value={"SMAP\nTransportIndexAlertingCommentAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportIndexAlertingCommentAction.kt\norg/opensearch/alerting/transport/TransportIndexAlertingCommentAction$IndexCommentHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,389:1\n1549#2:390\n1620#2,3:391\n1549#2:394\n1620#2,3:395\n13579#3,2:398\n*S KotlinDebug\n*F\n+ 1 TransportIndexAlertingCommentAction.kt\norg/opensearch/alerting/transport/TransportIndexAlertingCommentAction$IndexCommentHandler\n*L\n299#1:390\n299#1:391,3\n348#1:394\n348#1:395,3\n380#1:398,2\n*E\n"})
    public final class IndexCommentHandler {
        @NotNull
        private final Client client;
        @NotNull
        private final ActionListener<IndexCommentResponse> actionListener;
        @NotNull
        private final IndexCommentRequest request;
        @Nullable
        private final User user;

        public IndexCommentHandler(@NotNull Client client, @NotNull ActionListener<IndexCommentResponse> actionListener, @Nullable IndexCommentRequest request, User user) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = user;
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object start(@NotNull Continuation<? super Unit> var1_1) {
            if (!(var1_1 instanceof start.1)) ** GOTO lbl-1000
            var3_2 = var1_1;
            if ((var3_2.label & -2147483648) != 0) {
                var3_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ IndexCommentHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.start((Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = TransportIndexAlertingCommentAction.this.getCommentsIndices().createOrUpdateInitialCommentsHistoryIndex((Continuation<? super Unit>)$continuation);
                    if (v0 == var4_4) {
                        return var4_4;
                    }
                    ** GOTO lbl22
                }
                case 1: {
                    this = (IndexCommentHandler)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl22:
                    // 2 sources

                    if (this.request.getMethod() != RestRequest.Method.PUT) break;
                    $continuation.L$0 = null;
                    $continuation.label = 2;
                    v1 = this.updateComment((Continuation<? super Unit>)$continuation);
                    if (v1 == var4_4) {
                        return var4_4;
                    }
                    ** GOTO lbl32
                }
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl32:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            $continuation.L$0 = null;
            $continuation.label = 3;
            v2 = this.indexComment((Continuation<? super Unit>)$continuation);
            if (v2 == var4_4) {
                return var4_4;
            }
            ** GOTO lbl42
            {
                case 3: {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl42:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object indexComment(Continuation<? super Unit> var1_1) {
            if (!(var1_1 instanceof indexComment.1)) ** GOTO lbl-1000
            var9_2 = var1_1;
            if ((var9_2.label & -2147483648) != 0) {
                var9_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ IndexCommentHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return IndexCommentHandler.access$indexComment(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = this.getAlert((Continuation<? super Alert>)$continuation);
                    if (v0 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl22
                }
                case 1: {
                    this = (IndexCommentHandler)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl22:
                    // 2 sources

                    v1 = (Alert)v0;
                    if (v1 == null) {
                        return Unit.INSTANCE;
                    }
                    alert = v1;
                    $continuation.L$0 = this;
                    $continuation.L$1 = alert;
                    $continuation.label = 2;
                    v2 = CommentsUtils.Companion.getCommentIDsByAlertIDs(this.client, CollectionsKt.listOf((Object)alert.getId()), (Continuation<? super List<String>>)$continuation);
                    if (v2 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl38
                }
                case 2: {
                    alert = (Alert)$continuation.L$1;
                    this = (IndexCommentHandler)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl38:
                    // 2 sources

                    numCommentsOnThisAlert = ((List)v2).size();
                    v3 = numCommentsOnThisAlert;
                    var4_7 = TransportIndexAlertingCommentAction.access$getMaxCommentsPerAlert$p(TransportIndexAlertingCommentAction.this);
                    Intrinsics.checkNotNullExpressionValue((Object)var4_7, (String)"maxCommentsPerAlert");
                    if (v3 >= ((Number)var4_7).longValue()) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new IllegalArgumentException("This request would create more than the allowed number of Commentsfor this Alert: " + TransportIndexAlertingCommentAction.access$getMaxCommentsPerAlert$p(TransportIndexAlertingCommentAction.this))));
                        return Unit.INSTANCE;
                    }
                    TransportIndexAlertingCommentActionKt.access$getLog$p().debug("checking user permissions in index comment");
                    TransportIndexAlertingCommentAction.this.checkUserPermissionsWithResource(this.user, alert.getMonitorUser(), this.actionListener, "monitor", alert.getMonitorId());
                    v4 = this.request.getEntityId();
                    v5 = this.request.getEntityType();
                    v6 = this.request.getContent();
                    v7 = Instant.now();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"now()");
                    comment = new Comment(v4, v5, v6, v7, this.user);
                    v8 = new IndexRequest(".opensearch-alerting-comments-history-write");
                    v9 = XContentFactory.jsonBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"jsonBuilder()");
                    indexRequest = (IndexRequest)((IndexRequest)v8.source(comment.toXContentWithUser(v9)).setIfSeqNo(this.request.getSeqNo()).setIfPrimaryTerm(this.request.getPrimaryTerm()).timeout(TransportIndexAlertingCommentAction.access$getIndexTimeout$p(TransportIndexAlertingCommentAction.this))).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                    v10 = TransportIndexAlertingCommentActionKt.access$getLog$p();
                    v11 = XContentFactory.jsonBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"jsonBuilder()");
                    v10.debug("Creating new comment: " + comment.toXContentWithUser(v11));
                    $continuation.L$0 = this;
                    $continuation.L$1 = comment;
                    $continuation.label = 3;
                    v12 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (Function2)((Function2)new Function2<Client, ActionListener<IndexResponse>, Unit>(this, indexRequest){
                        final /* synthetic */ IndexCommentHandler this$0;
                        final /* synthetic */ IndexRequest $indexRequest;
                        {
                            this.this$0 = $receiver;
                            this.$indexRequest = $indexRequest;
                            super(2);
                        }

                        public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<IndexResponse> it) {
                            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            IndexCommentHandler.access$getClient$p(this.this$0).index(this.$indexRequest, it);
                        }
                    }), (Continuation)$continuation);
                    ** if (v12 != var10_4) goto lbl70
lbl69:
                    // 1 sources

                    return var10_4;
lbl70:
                    // 1 sources

                    ** GOTO lbl78
                }
                case 3: {
                    comment = (Comment)$continuation.L$1;
                    this = (IndexCommentHandler)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v12 = $result;
lbl78:
                        // 2 sources

                        if ((failureReasons = this.checkShardsFailure(indexResponse = (IndexResponse)v12)) != null) {
                            this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException(failureReasons.toString(), indexResponse.status(), new Object[0])));
                            return Unit.INSTANCE;
                        }
                        v13 = indexResponse.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"indexResponse.id");
                        this.actionListener.onResponse((Object)new IndexCommentResponse(v13, indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), comment));
                    }
                    catch (Exception t) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object updateComment(Continuation<? super Unit> var1_1) {
            if (!(var1_1 instanceof updateComment.1)) ** GOTO lbl-1000
            var8_2 = var1_1;
            if ((var8_2.label & -2147483648) != 0) {
                var8_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ IndexCommentHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return IndexCommentHandler.access$updateComment(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = this.getComment((Continuation<? super Comment>)$continuation);
                    if (v0 == var9_4) {
                        return var9_4;
                    }
                    ** GOTO lbl22
                }
                case 1: {
                    this = (IndexCommentHandler)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl22:
                    // 2 sources

                    v1 = (Comment)v0;
                    if (v1 == null) {
                        return Unit.INSTANCE;
                    }
                    currentComment = v1;
                    if (this.user != null && !TransportIndexAlertingCommentAction.this.isAdmin(this.user)) {
                        v2 = currentComment.getUser();
                        if (!Intrinsics.areEqual((Object)this.user.getName(), (Object)(v2 != null ? v2.getName() : null))) {
                            this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Comment can only be edited by Admin or author of comment", RestStatus.FORBIDDEN, new Object[0])));
                            return Unit.INSTANCE;
                        }
                    }
                    requestComment = Comment.copy$default((Comment)currentComment, null, null, null, (String)this.request.getContent(), null, (Instant)Instant.now(), null, (int)87, null);
                    v3 = new IndexRequest(".opensearch-alerting-comments-history-write");
                    v4 = XContentFactory.jsonBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"jsonBuilder()");
                    indexRequest = (IndexRequest)((IndexRequest)v3.source(requestComment.toXContentWithUser(v4)).id(requestComment.getId()).setIfSeqNo(this.request.getSeqNo()).setIfPrimaryTerm(this.request.getPrimaryTerm()).timeout(TransportIndexAlertingCommentAction.access$getIndexTimeout$p(TransportIndexAlertingCommentAction.this))).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                    TransportIndexAlertingCommentActionKt.access$getLog$p().debug("Updating comment, " + currentComment.getId() + ", from: " + currentComment.getContent() + " to: " + requestComment.getContent());
                    $continuation.L$0 = this;
                    $continuation.L$1 = requestComment;
                    $continuation.label = 2;
                    v5 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (Function2)((Function2)new Function2<Client, ActionListener<IndexResponse>, Unit>(this, indexRequest){
                        final /* synthetic */ IndexCommentHandler this$0;
                        final /* synthetic */ IndexRequest $indexRequest;
                        {
                            this.this$0 = $receiver;
                            this.$indexRequest = $indexRequest;
                            super(2);
                        }

                        public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<IndexResponse> it) {
                            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            IndexCommentHandler.access$getClient$p(this.this$0).index(this.$indexRequest, it);
                        }
                    }), (Continuation)$continuation);
                    ** if (v5 != var9_4) goto lbl45
lbl44:
                    // 1 sources

                    return var9_4;
lbl45:
                    // 1 sources

                    ** GOTO lbl53
                }
                case 2: {
                    requestComment = (Comment)$continuation.L$1;
                    this = (IndexCommentHandler)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl53:
                        // 2 sources

                        if ((failureReasons = this.checkShardsFailure(indexResponse = (IndexResponse)v5)) != null) {
                            this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException(failureReasons.toString(), indexResponse.status(), new Object[0])));
                            return Unit.INSTANCE;
                        }
                        v6 = indexResponse.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"indexResponse.id");
                        this.actionListener.onResponse((Object)new IndexCommentResponse(v6, indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), (Comment)var3_6));
                    }
                    catch (Exception t) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap(t));
                    }
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object getAlert(Continuation<? super Alert> var1_1) {
            if (!(var1_1 instanceof getAlert.1)) ** GOTO lbl-1000
            var20_2 = var1_1;
            if ((var20_2.label & -2147483648) != 0) {
                var20_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ IndexCommentHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return IndexCommentHandler.access$getAlert(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var21_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"_id", (Collection)CollectionsKt.listOf((Object)this.request.getEntityId())));
                    searchSourceBuilder = new SearchSourceBuilder().version(Boxing.boxBoolean((boolean)true)).seqNoAndPrimaryTerm(Boxing.boxBoolean((boolean)true)).query((QueryBuilder)queryBuilder);
                    var5_7 = new String[]{".opendistro-alerting-alert*"};
                    searchRequest = new SearchRequest().indices(var5_7).source(searchSourceBuilder);
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (Function2)((Function2)new Function2<Client, ActionListener<SearchResponse>, Unit>(searchRequest){
                        final /* synthetic */ SearchRequest $searchRequest;
                        {
                            this.$searchRequest = $searchRequest;
                            super(2);
                        }

                        public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<SearchResponse> it) {
                            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            $this$suspendUntil.search(this.$searchRequest, it);
                        }
                    }), (Continuation)$continuation);
                    if (v0 == var21_4) {
                        return var21_4;
                    }
                    ** GOTO lbl26
                }
                case 1: {
                    this = (IndexCommentHandler)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    searchResponse = (SearchResponse)v0;
                    var7_9 = searchResponse.getHits();
                    Intrinsics.checkNotNullExpressionValue((Object)var7_9, (String)"searchResponse.hits");
                    $this$map$iv = (Iterable)var7_9;
                    $i$f$map = false;
                    var9_11 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var14_16 = (SearchHit)item$iv$iv;
                        var18_20 = destination$iv$iv;
                        $i$a$-map-TransportIndexAlertingCommentAction$IndexCommentHandler$getAlert$alerts$1 = false;
                        xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)hit.getSourceRef(), (MediaType)((MediaType)XContentType.JSON));
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                        Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                        v1 = hit.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"hit.id");
                        alert = Alert.Companion.parse(xcp, v1, hit.getVersion());
                        var18_20.add(alert);
                    }
                    alerts = (List)destination$iv$iv;
                    if (alerts.isEmpty()) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Alert not found", RestStatus.NOT_FOUND, new Object[0])));
                        return null;
                    }
                    if (alerts.size() > 1) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new IllegalStateException("Multiple alerts were found with the same ID")));
                        return null;
                    }
                    return alerts.get(0);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object getComment(Continuation<? super Comment> var1_1) {
            if (!(var1_1 instanceof getComment.1)) ** GOTO lbl-1000
            var20_2 = var1_1;
            if ((var20_2.label & -2147483648) != 0) {
                var20_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ IndexCommentHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return IndexCommentHandler.access$getComment(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var21_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"_id", (Collection)CollectionsKt.listOf((Object)this.request.getCommentId())));
                    searchSourceBuilder = new SearchSourceBuilder().version(Boxing.boxBoolean((boolean)true)).seqNoAndPrimaryTerm(Boxing.boxBoolean((boolean)true)).query((QueryBuilder)queryBuilder);
                    var5_7 = new String[]{".opensearch-alerting-comments*"};
                    searchRequest = new SearchRequest().indices(var5_7).source(searchSourceBuilder);
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)((OpenSearchClient)this.client), (Function2)((Function2)new Function2<Client, ActionListener<SearchResponse>, Unit>(searchRequest){
                        final /* synthetic */ SearchRequest $searchRequest;
                        {
                            this.$searchRequest = $searchRequest;
                            super(2);
                        }

                        public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<SearchResponse> it) {
                            Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            $this$suspendUntil.search(this.$searchRequest, it);
                        }
                    }), (Continuation)$continuation);
                    if (v0 == var21_4) {
                        return var21_4;
                    }
                    ** GOTO lbl26
                }
                case 1: {
                    this = (IndexCommentHandler)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    searchResponse = (SearchResponse)v0;
                    var7_9 = searchResponse.getHits();
                    Intrinsics.checkNotNullExpressionValue((Object)var7_9, (String)"searchResponse.hits");
                    $this$map$iv = (Iterable)var7_9;
                    $i$f$map = false;
                    var9_11 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var14_16 = (SearchHit)item$iv$iv;
                        var18_20 = destination$iv$iv;
                        $i$a$-map-TransportIndexAlertingCommentAction$IndexCommentHandler$getComment$comments$1 = false;
                        xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)hit.getSourceRef(), (MediaType)((MediaType)XContentType.JSON));
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                        Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                        v1 = hit.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"hit.id");
                        comment = Comment.Companion.parse(xcp, v1);
                        var18_20.add(comment);
                    }
                    comments = (List)destination$iv$iv;
                    if (comments.isEmpty()) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new OpenSearchStatusException("Comment not found", RestStatus.NOT_FOUND, new Object[0])));
                        return null;
                    }
                    if (comments.size() > 1) {
                        this.actionListener.onFailure((Exception)AlertingException.Companion.wrap((Exception)new IllegalStateException("Multiple comments were found with the same ID")));
                        return null;
                    }
                    return comments.get(0);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final String checkShardsFailure(IndexResponse response2) {
            StringBuilder failureReasons = new StringBuilder();
            if (response2.getShardInfo().getFailed() > 0) {
                ReplicationResponse.ShardInfo.Failure[] failureArray = response2.getShardInfo().getFailures();
                Intrinsics.checkNotNullExpressionValue((Object)failureArray, (String)"response.shardInfo.failures");
                Object[] $this$forEach$iv = failureArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ReplicationResponse.ShardInfo.Failure entry = (ReplicationResponse.ShardInfo.Failure)element$iv;
                    boolean bl = false;
                    failureReasons.append(entry.reason());
                }
                return failureReasons.toString();
            }
            return null;
        }

        public static final /* synthetic */ Object access$indexComment(IndexCommentHandler $this, Continuation $completion) {
            return $this.indexComment((Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Client access$getClient$p(IndexCommentHandler $this) {
            return $this.client;
        }

        public static final /* synthetic */ Object access$updateComment(IndexCommentHandler $this, Continuation $completion) {
            return $this.updateComment((Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$getAlert(IndexCommentHandler $this, Continuation $completion) {
            return $this.getAlert((Continuation<? super Alert>)$completion);
        }

        public static final /* synthetic */ Object access$getComment(IndexCommentHandler $this, Continuation $completion) {
            return $this.getComment((Continuation<? super Comment>)$completion);
        }
    }
}

