/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.connector.functions.preprocess;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.ml.common.connector.functions.preprocess.ConnectorPreProcessFunction;
import org.opensearch.ml.common.dataset.TextDocsInputDataSet;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.utils.StringUtils;

public class CohereMultiModalEmbeddingPreProcessFunction
extends ConnectorPreProcessFunction {
    public CohereMultiModalEmbeddingPreProcessFunction() {
        this.returnDirectlyForRemoteInferenceInput = true;
    }

    @Override
    public void validate(MLInput mlInput) {
        this.validateTextDocsInput(mlInput);
        List<String> docs = ((TextDocsInputDataSet)mlInput.getInputDataset()).getDocs();
        if (docs == null || docs.isEmpty() || docs.get(0) == null) {
            throw new IllegalArgumentException("No image provided");
        }
    }

    @Override
    public RemoteInferenceInputDataSet process(MLInput mlInput) {
        TextDocsInputDataSet inputData = (TextDocsInputDataSet)mlInput.getInputDataset();
        HashMap<String, List<String>> parametersMap = new HashMap<String, List<String>>();
        parametersMap.put("images", inputData.getDocs());
        return RemoteInferenceInputDataSet.builder().parameters(StringUtils.convertScriptStringToJsonString(Map.of("parameters", parametersMap))).build();
    }
}

