/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.repository.Artifact;
import ai.djl.repository.Restriction;
import ai.djl.repository.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public final class VersionRange {
    private static final VersionRange ANY = new VersionRange(null, Collections.emptyList());
    private Version recommendedVersion;
    private List<Restriction> restrictions;

    private VersionRange(Version recommendedVersion, List<Restriction> restrictions) {
        this.recommendedVersion = recommendedVersion;
        this.restrictions = restrictions;
    }

    public Version getRecommendedVersion() {
        return this.recommendedVersion;
    }

    public List<Restriction> getRestrictions() {
        return this.restrictions;
    }

    public static VersionRange parse(String spec) {
        if (spec == null || spec.isEmpty()) {
            return ANY;
        }
        ArrayList<Restriction> restrictions = new ArrayList<Restriction>();
        String process = spec;
        Version version = null;
        Version upperBound = null;
        Version lowerBound = null;
        while (process.startsWith("[") || process.startsWith("(")) {
            int index2;
            int index1 = process.indexOf(41);
            int index = index2 = process.indexOf(93);
            if ((index2 < 0 || index1 < index2) && index1 >= 0) {
                index = index1;
            }
            if (index < 0) {
                throw new IllegalArgumentException("Unbounded range: " + spec);
            }
            Restriction restriction = VersionRange.parseRestriction(process.substring(0, index + 1));
            if (lowerBound == null) {
                lowerBound = restriction.getLowerBound();
            }
            if (upperBound != null && (restriction.getLowerBound() == null || restriction.getLowerBound().compareTo(upperBound) < 0)) {
                throw new IllegalArgumentException("Ranges overlap: " + spec);
            }
            restrictions.add(restriction);
            upperBound = restriction.getUpperBound();
            if ((process = process.substring(index + 1).trim()).length() <= 0 || !process.startsWith(",")) continue;
            process = process.substring(1).trim();
        }
        if (process.length() > 0) {
            if (!restrictions.isEmpty()) {
                throw new IllegalArgumentException("Only fully-qualified sets allowed in multiple set scenario: " + spec);
            }
            version = new Version(process);
            restrictions.add(Restriction.EVERYTHING);
        }
        return new VersionRange(version, restrictions);
    }

    private static Restriction parseRestriction(String spec) {
        Restriction restriction;
        boolean lowerBoundInclusive = spec.startsWith("[");
        boolean upperBoundInclusive = spec.endsWith("]");
        String process = spec.substring(1, spec.length() - 1).trim();
        int index = process.indexOf(44);
        if (index < 0) {
            if (!lowerBoundInclusive || !upperBoundInclusive) {
                throw new IllegalArgumentException("Single version must be surrounded by []: " + spec);
            }
            Version version = new Version(process);
            restriction = new Restriction(version, true, version, true);
        } else {
            String upperBound;
            String lowerBound = process.substring(0, index).trim();
            if (lowerBound.equals(upperBound = process.substring(index + 1).trim())) {
                throw new IllegalArgumentException("Range cannot have identical boundaries: " + spec);
            }
            Version lowerVersion = null;
            if (lowerBound.length() > 0) {
                lowerVersion = new Version(lowerBound);
            }
            Version upperVersion = null;
            if (upperBound.length() > 0) {
                upperVersion = new Version(upperBound);
            }
            if (upperVersion != null && lowerVersion != null && upperVersion.compareTo(lowerVersion) < 0) {
                throw new IllegalArgumentException("Range defies version ordering: " + spec);
            }
            restriction = new Restriction(lowerVersion, lowerBoundInclusive, upperVersion, upperBoundInclusive);
        }
        return restriction;
    }

    public List<Artifact> matches(List<Artifact> artifacts) {
        return artifacts.stream().filter(this::contains).collect(Collectors.toList());
    }

    public boolean contains(Version version) {
        if (ANY == this) {
            return true;
        }
        if (this.recommendedVersion != null) {
            return this.recommendedVersion.equals(version);
        }
        for (Restriction restriction : this.restrictions) {
            if (!restriction.containsVersion(version)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Artifact artifact) {
        return artifact.getVersion() == null || this.contains(artifact.getParsedVersion());
    }

    public String toString() {
        if (this.recommendedVersion != null) {
            return this.recommendedVersion.toString();
        }
        StringBuilder buf = new StringBuilder();
        Iterator<Restriction> i = this.restrictions.iterator();
        while (i.hasNext()) {
            Restriction r = i.next();
            buf.append(r.toString());
            if (!i.hasNext()) continue;
            buf.append(',');
        }
        return buf.toString();
    }
}

