/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.RestRequest;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.metrics.Max;
import org.opensearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.action.IndexCustomLogTypeRequest;
import org.opensearch.securityanalytics.action.IndexCustomLogTypeResponse;
import org.opensearch.securityanalytics.logtype.LogTypeService;
import org.opensearch.securityanalytics.model.CustomLogType;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.securityanalytics.util.CustomLogTypeIndices;
import org.opensearch.securityanalytics.util.DetectorIndices;
import org.opensearch.securityanalytics.util.IndexUtils;
import org.opensearch.securityanalytics.util.RuleIndices;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportIndexCustomLogTypeAction
extends HandledTransportAction<IndexCustomLogTypeRequest, IndexCustomLogTypeResponse>
implements SecureTransportAction {
    private final Client client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final Settings settings;
    private final DetectorIndices detectorIndices;
    private final RuleIndices ruleIndices;
    private final CustomLogTypeIndices customLogTypeIndices;
    private final LogTypeService logTypeService;
    private volatile Boolean filterByEnabled;
    private volatile TimeValue indexTimeout;

    @Inject
    public TransportIndexCustomLogTypeAction(TransportService transportService, Client client, ActionFilters actionFilters, ClusterService clusterService, DetectorIndices detectorIndices, RuleIndices ruleIndices, CustomLogTypeIndices customLogTypeIndices, LogTypeService logTypeService, Settings settings, ThreadPool threadPool) {
        super("cluster:admin/opensearch/securityanalytics/logtype/write", transportService, actionFilters, IndexCustomLogTypeRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.settings = settings;
        this.detectorIndices = detectorIndices;
        this.ruleIndices = ruleIndices;
        this.customLogTypeIndices = customLogTypeIndices;
        this.logTypeService = logTypeService;
        this.filterByEnabled = (Boolean)SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES.get(this.settings);
        this.indexTimeout = (TimeValue)SecurityAnalyticsSettings.INDEX_TIMEOUT.get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES, this::setFilterByEnabled);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.INDEX_TIMEOUT, this::setIndexTimeout);
    }

    protected void doExecute(Task task, IndexCustomLogTypeRequest request, ActionListener<IndexCustomLogTypeResponse> listener) {
        User user = this.readUserFromThreadContext(this.threadPool);
        String validateBackendRoleMessage = this.validateUserBackendRoles(user, this.filterByEnabled);
        if (!"".equals(validateBackendRoleMessage)) {
            listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException(validateBackendRoleMessage, RestStatus.FORBIDDEN, new Object[0]))));
            return;
        }
        AsyncIndexCustomLogTypeAction asyncAction = new AsyncIndexCustomLogTypeAction(task, request, listener);
        asyncAction.start();
    }

    public void onCreateMappingsResponse(CreateIndexResponse response) {
        if (!response.isAcknowledged()) {
            log.error(String.format(Locale.getDefault(), "Create %s mappings call not acknowledged.", ".opensearch-sap-log-types-config"));
            throw new OpenSearchStatusException(String.format(Locale.getDefault(), "Create %s mappings call not acknowledged", ".opensearch-sap-log-types-config"), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        log.info(String.format(Locale.getDefault(), "Created %s with mappings.", ".opensearch-sap-log-types-config"));
        IndexUtils.customLogTypeIndexUpdated();
    }

    public void onUpdateMappingsResponse(AcknowledgedResponse response) {
        if (!response.isAcknowledged()) {
            log.error(String.format(Locale.getDefault(), "Update %s mappings call not acknowledged.", ".opensearch-sap-log-types-config"));
            throw new OpenSearchStatusException(String.format(Locale.getDefault(), "Update %s mappings call not acknowledged.", ".opensearch-sap-log-types-config"), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        log.info(String.format(Locale.getDefault(), "Updated  %s with mappings.", ".opensearch-sap-log-types-config"));
        IndexUtils.customLogTypeIndexUpdated();
    }

    private void setFilterByEnabled(boolean filterByEnabled) {
        this.filterByEnabled = filterByEnabled;
    }

    private void setIndexTimeout(TimeValue indexTimeout) {
        this.indexTimeout = indexTimeout;
    }

    class AsyncIndexCustomLogTypeAction {
        private final IndexCustomLogTypeRequest request;
        private final ActionListener<IndexCustomLogTypeResponse> listener;
        private final AtomicReference<Object> response;
        private final AtomicBoolean counter = new AtomicBoolean();
        private final Task task;

        AsyncIndexCustomLogTypeAction(Task task, IndexCustomLogTypeRequest request, ActionListener<IndexCustomLogTypeResponse> listener) {
            this.task = task;
            this.request = request;
            this.listener = listener;
            this.response = new AtomicReference();
        }

        void start() {
            TransportIndexCustomLogTypeAction.this.threadPool.getThreadContext().stashContext();
            try {
                if (!TransportIndexCustomLogTypeAction.this.customLogTypeIndices.customLogTypeIndexExists()) {
                    TransportIndexCustomLogTypeAction.this.customLogTypeIndices.initCustomLogTypeIndex(new ActionListener<CreateIndexResponse>(){

                        public void onResponse(CreateIndexResponse response) {
                            try {
                                TransportIndexCustomLogTypeAction.this.onCreateMappingsResponse(response);
                                AsyncIndexCustomLogTypeAction.this.prepareCustomLogTypeIndexing();
                            }
                            catch (IOException ex) {
                                AsyncIndexCustomLogTypeAction.this.onFailures(ex);
                            }
                        }

                        public void onFailure(Exception e) {
                            AsyncIndexCustomLogTypeAction.this.onFailures(e);
                        }
                    });
                } else if (!IndexUtils.customLogTypeIndexUpdated.booleanValue()) {
                    IndexUtils.updateIndexMapping(".opensearch-sap-log-types-config", CustomLogTypeIndices.customLogTypeMappings(), TransportIndexCustomLogTypeAction.this.clusterService.state(), TransportIndexCustomLogTypeAction.this.client.admin().indices(), new ActionListener<AcknowledgedResponse>(){

                        public void onResponse(AcknowledgedResponse response) {
                            try {
                                TransportIndexCustomLogTypeAction.this.onUpdateMappingsResponse(response);
                                AsyncIndexCustomLogTypeAction.this.prepareCustomLogTypeIndexing();
                            }
                            catch (IOException ex) {
                                AsyncIndexCustomLogTypeAction.this.onFailures(ex);
                            }
                        }

                        public void onFailure(Exception e) {
                            AsyncIndexCustomLogTypeAction.this.onFailures(e);
                        }
                    }, false);
                } else {
                    this.prepareCustomLogTypeIndexing();
                }
            }
            catch (IOException ex) {
                this.onFailures(ex);
            }
        }

        private void prepareCustomLogTypeIndexing() throws IOException {
            final String logTypeId = this.request.getLogTypeId();
            String source = this.request.getCustomLogType().getSource();
            if (source.equals("Sigma")) {
                this.onFailures(new Exception[]{new OpenSearchStatusException(String.format(Locale.getDefault(), "Log Type with id %s cannot be updated because source is sigma", logTypeId), RestStatus.BAD_REQUEST, new Object[0])});
            }
            if (this.request.getMethod() == RestRequest.Method.PUT) {
                this.searchLogTypes(logTypeId, new ActionListener<SearchResponse>(){

                    public void onResponse(SearchResponse response) {
                        if (response.isTimedOut()) {
                            AsyncIndexCustomLogTypeAction.this.onFailures(new Exception[]{new OpenSearchStatusException(String.format(Locale.getDefault(), "Search request timed out. Log Type with id %s cannot be updated", logTypeId), RestStatus.REQUEST_TIMEOUT, new Object[0])});
                            return;
                        }
                        if (response.getHits().getTotalHits().value != 1L) {
                            AsyncIndexCustomLogTypeAction.this.onFailures(new Exception[]{new OpenSearchStatusException(String.format(Locale.getDefault(), "Log Type with id %s cannot be updated", logTypeId), RestStatus.INTERNAL_SERVER_ERROR, new Object[0])});
                            return;
                        }
                        Map sourceMap = response.getHits().getHits()[0].getSourceAsMap();
                        final CustomLogType existingLogType = new CustomLogType(sourceMap);
                        existingLogType.setId(AsyncIndexCustomLogTypeAction.this.request.getCustomLogType().getId());
                        existingLogType.setVersion(AsyncIndexCustomLogTypeAction.this.request.getCustomLogType().getVersion());
                        if (existingLogType.getSource().equals("Sigma")) {
                            AsyncIndexCustomLogTypeAction.this.onFailures(new Exception[]{new OpenSearchStatusException(String.format(Locale.getDefault(), "Log Type with id %s cannot be updated because source is sigma", logTypeId), RestStatus.BAD_REQUEST, new Object[0])});
                        }
                        if (!existingLogType.getName().equals(AsyncIndexCustomLogTypeAction.this.request.getCustomLogType().getName())) {
                            if (TransportIndexCustomLogTypeAction.this.detectorIndices.detectorIndexExists()) {
                                AsyncIndexCustomLogTypeAction.this.searchDetectors(existingLogType.getName(), new ActionListener<SearchResponse>(){

                                    public void onResponse(SearchResponse response) {
                                        if (response.isTimedOut()) {
                                            AsyncIndexCustomLogTypeAction.this.onFailures(new Exception[]{new OpenSearchStatusException(String.format(Locale.getDefault(), "Search request timed out. Log Type with id %s cannot be updated", logTypeId), RestStatus.REQUEST_TIMEOUT, new Object[0])});
                                            return;
                                        }
                                        if (response.getHits().getTotalHits().value > 0L) {
                                            AsyncIndexCustomLogTypeAction.this.onFailures(new Exception[]{new OpenSearchStatusException(String.format(Locale.getDefault(), "Name of Log Type with id %s cannot be updated because active detectors exist", logTypeId), RestStatus.BAD_REQUEST, new Object[0])});
                                            return;
                                        }
                                        AsyncIndexCustomLogTypeAction.this.checkRuleIndexAndUpdateLogType(existingLogType, logTypeId);
                                    }

                                    public void onFailure(Exception e) {
                                        AsyncIndexCustomLogTypeAction.this.onFailures(e);
                                    }
                                });
                            } else {
                                AsyncIndexCustomLogTypeAction.this.checkRuleIndexAndUpdateLogType(existingLogType, logTypeId);
                            }
                        } else {
                            AsyncIndexCustomLogTypeAction.this.updateLogType(existingLogType, logTypeId);
                        }
                    }

                    public void onFailure(Exception e) {
                        AsyncIndexCustomLogTypeAction.this.onFailures(e);
                    }
                });
            } else {
                TransportIndexCustomLogTypeAction.this.logTypeService.ensureConfigIndexIsInitialized(new ActionListener<Void>(){

                    public void onResponse(Void unused) {
                        MatchQueryBuilder queryBuilder = QueryBuilders.matchQuery((String)"name", (Object)AsyncIndexCustomLogTypeAction.this.request.getCustomLogType().getName());
                        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                        searchSourceBuilder.query((QueryBuilder)queryBuilder);
                        SearchRequest searchRequest = new SearchRequest();
                        searchRequest.indices(new String[]{".opensearch-sap-log-types-config"});
                        searchRequest.source(searchSourceBuilder);
                        TransportIndexCustomLogTypeAction.this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                            public void onResponse(SearchResponse response) {
                                if (response.isTimedOut()) {
                                    AsyncIndexCustomLogTypeAction.this.onFailures(new Exception[]{new OpenSearchStatusException("Search request timed out", RestStatus.REQUEST_TIMEOUT, new Object[0])});
                                    return;
                                }
                                long noOfHits = response.getHits().getTotalHits().value;
                                if (noOfHits > 0L) {
                                    AsyncIndexCustomLogTypeAction.this.onFailures(new Exception[]{new OpenSearchStatusException(String.format(Locale.ROOT, "Log Type with name %s already exists", AsyncIndexCustomLogTypeAction.this.request.getCustomLogType().getName()), RestStatus.INTERNAL_SERVER_ERROR, new Object[0])});
                                    return;
                                }
                                MaxAggregationBuilder queryBuilder = (MaxAggregationBuilder)AggregationBuilders.max((String)"agg").field("tags.correlation_id");
                                SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                                searchSourceBuilder.aggregation((AggregationBuilder)queryBuilder);
                                SearchRequest searchRequest = new SearchRequest();
                                searchRequest.indices(new String[]{".opensearch-sap-log-types-config"});
                                searchRequest.source(searchSourceBuilder);
                                TransportIndexCustomLogTypeAction.this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                                    public void onResponse(SearchResponse response) {
                                        if (response.isTimedOut()) {
                                            AsyncIndexCustomLogTypeAction.this.onFailures(new Exception[]{new OpenSearchStatusException("Search request timed out", RestStatus.REQUEST_TIMEOUT, new Object[0])});
                                            return;
                                        }
                                        try {
                                            Max agg = (Max)response.getAggregations().get("agg");
                                            int value = Double.valueOf(agg.getValue()).intValue();
                                            AsyncIndexCustomLogTypeAction.this.request.getCustomLogType().setTags(Map.of("correlation_id", value + 1));
                                            IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-log-types-config").setRefreshPolicy(AsyncIndexCustomLogTypeAction.this.request.getRefreshPolicy())).source(AsyncIndexCustomLogTypeAction.this.request.getCustomLogType().toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).timeout(TransportIndexCustomLogTypeAction.this.indexTimeout);
                                            TransportIndexCustomLogTypeAction.this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

                                                public void onResponse(IndexResponse response) {
                                                    if (response.status() != RestStatus.CREATED) {
                                                        AsyncIndexCustomLogTypeAction.this.onFailures(new Exception[]{new OpenSearchStatusException(String.format(Locale.getDefault(), "Log Type with id %s cannot be updated", logTypeId), RestStatus.INTERNAL_SERVER_ERROR, new Object[0])});
                                                    }
                                                    AsyncIndexCustomLogTypeAction.this.request.getCustomLogType().setId(response.getId());
                                                    AsyncIndexCustomLogTypeAction.this.onOperation(response, AsyncIndexCustomLogTypeAction.this.request.getCustomLogType());
                                                }

                                                public void onFailure(Exception e) {
                                                    AsyncIndexCustomLogTypeAction.this.onFailures(e);
                                                }
                                            });
                                        }
                                        catch (IOException ex) {
                                            AsyncIndexCustomLogTypeAction.this.onFailures(ex);
                                        }
                                    }

                                    public void onFailure(Exception e) {
                                        AsyncIndexCustomLogTypeAction.this.onFailures(e);
                                    }
                                });
                            }

                            public void onFailure(Exception e) {
                                AsyncIndexCustomLogTypeAction.this.onFailures(e);
                            }
                        });
                    }

                    public void onFailure(Exception e) {
                        AsyncIndexCustomLogTypeAction.this.onFailures(e);
                    }
                });
            }
        }

        void checkRuleIndexAndUpdateLogType(final CustomLogType existingLogType, final String logTypeId) {
            if (TransportIndexCustomLogTypeAction.this.ruleIndices.ruleIndexExists(false)) {
                TransportIndexCustomLogTypeAction.this.ruleIndices.searchRules(existingLogType.getName(), new ActionListener<SearchResponse>(){

                    public void onResponse(SearchResponse response) {
                        if (response.isTimedOut()) {
                            AsyncIndexCustomLogTypeAction.this.onFailures(new Exception[]{new OpenSearchStatusException(String.format(Locale.getDefault(), "Search request timed out. Log Type with id %s cannot be updated", logTypeId), RestStatus.REQUEST_TIMEOUT, new Object[0])});
                            return;
                        }
                        if (response.getHits().getTotalHits().value > 0L) {
                            AsyncIndexCustomLogTypeAction.this.onFailures(new Exception[]{new OpenSearchStatusException(String.format(Locale.getDefault(), "Name of Log Type with id %s cannot be updated because active rules exist", logTypeId), RestStatus.BAD_REQUEST, new Object[0])});
                            return;
                        }
                        AsyncIndexCustomLogTypeAction.this.updateLogType(existingLogType, logTypeId);
                    }

                    public void onFailure(Exception e) {
                        if (e instanceof IndexNotFoundException) {
                            AsyncIndexCustomLogTypeAction.this.updateLogType(existingLogType, logTypeId);
                        } else {
                            AsyncIndexCustomLogTypeAction.this.onFailures(e);
                        }
                    }
                });
            } else {
                SecureTransportAction.log.warn("Custom rule index missing, allowing update of custom log type {} to go through", (Object)logTypeId);
                this.updateLogType(existingLogType, logTypeId);
            }
        }

        private void updateLogType(CustomLogType existingLogType, final String logTypeId) {
            try {
                this.request.getCustomLogType().setTags(existingLogType.getTags());
                IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-log-types-config").setRefreshPolicy(this.request.getRefreshPolicy())).source(this.request.getCustomLogType().toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).id(logTypeId).timeout(TransportIndexCustomLogTypeAction.this.indexTimeout);
                TransportIndexCustomLogTypeAction.this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

                    public void onResponse(IndexResponse response) {
                        if (response.status() != RestStatus.OK) {
                            AsyncIndexCustomLogTypeAction.this.onFailures(new Exception[]{new OpenSearchStatusException(String.format(Locale.getDefault(), "Log Type with id %s cannot be updated", logTypeId), RestStatus.INTERNAL_SERVER_ERROR, new Object[0])});
                        }
                        AsyncIndexCustomLogTypeAction.this.request.getCustomLogType().setId(response.getId());
                        AsyncIndexCustomLogTypeAction.this.onOperation(response, AsyncIndexCustomLogTypeAction.this.request.getCustomLogType());
                    }

                    public void onFailure(Exception e) {
                        AsyncIndexCustomLogTypeAction.this.onFailures(e);
                    }
                });
            }
            catch (IOException e) {
                this.onFailures(e);
            }
        }

        private void searchLogTypes(String logTypeId, ActionListener<SearchResponse> listener) {
            MatchQueryBuilder queryBuilder = QueryBuilders.matchQuery((String)"_id", (Object)logTypeId);
            SearchRequest searchRequest = new SearchRequest(new String[]{".opensearch-sap-log-types-config"}).source(new SearchSourceBuilder().seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true)).query((QueryBuilder)queryBuilder).size(1));
            TransportIndexCustomLogTypeAction.this.client.search(searchRequest, listener);
        }

        private void searchDetectors(String logTypeName, ActionListener<SearchResponse> listener) {
            NestedQueryBuilder queryBuilder = QueryBuilders.nestedQuery((String)"detector", (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"detector.detector_type", (Object)logTypeName)), (ScoreMode)ScoreMode.Avg);
            SearchRequest searchRequest = new SearchRequest(new String[]{".opensearch-sap-detectors-config"}).source(new SearchSourceBuilder().seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true)).query((QueryBuilder)queryBuilder).size(0));
            TransportIndexCustomLogTypeAction.this.client.search(searchRequest, listener);
        }

        private void onOperation(IndexResponse response, CustomLogType logType) {
            this.response.set(response);
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(logType, new Exception[0]);
            }
        }

        private void onFailures(Exception ... t) {
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(null, t);
            }
        }

        private void finishHim(CustomLogType logType, Exception ... t) {
            TransportIndexCustomLogTypeAction.this.threadPool.executor("generic").execute((Runnable)ActionRunnable.supply(this.listener, () -> {
                if (t != null && t.length > 0) {
                    if (t.length > 1) {
                        throw SecurityAnalyticsException.wrap(Arrays.asList(t));
                    }
                    throw SecurityAnalyticsException.wrap(t[0]);
                }
                return new IndexCustomLogTypeResponse(logType.getId(), logType.getVersion(), RestStatus.CREATED, logType);
            }));
        }
    }
}

