/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.services;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkClientException;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.securityanalytics.action.TestS3ConnectionResponse;
import org.opensearch.securityanalytics.commons.connector.Connector;
import org.opensearch.securityanalytics.commons.connector.S3Connector;
import org.opensearch.securityanalytics.commons.connector.exceptions.ConnectorParsingException;
import org.opensearch.securityanalytics.commons.connector.factory.InputCodecFactory;
import org.opensearch.securityanalytics.commons.connector.factory.S3ClientFactory;
import org.opensearch.securityanalytics.commons.connector.factory.StsAssumeRoleCredentialsProviderFactory;
import org.opensearch.securityanalytics.commons.connector.factory.StsClientFactory;
import org.opensearch.securityanalytics.commons.connector.model.InputCodecSchema;
import org.opensearch.securityanalytics.commons.connector.model.S3ConnectorConfig;
import org.opensearch.securityanalytics.commons.model.FeedConfiguration;
import org.opensearch.securityanalytics.commons.model.IOCSchema;
import org.opensearch.securityanalytics.commons.model.IOCType;
import org.opensearch.securityanalytics.commons.model.STIX2;
import org.opensearch.securityanalytics.commons.model.UpdateType;
import org.opensearch.securityanalytics.model.STIX2IOC;
import org.opensearch.securityanalytics.model.STIX2IOCDto;
import org.opensearch.securityanalytics.services.STIX2IOCConnectorFactory;
import org.opensearch.securityanalytics.services.STIX2IOCConsumer;
import org.opensearch.securityanalytics.services.STIX2IOCFeedStore;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.threatIntel.model.S3Source;
import org.opensearch.securityanalytics.threatIntel.model.SATIFSourceConfig;
import org.opensearch.securityanalytics.threatIntel.model.UrlDownloadSource;
import org.opensearch.securityanalytics.threatIntel.service.TIFJobParameterService;
import org.opensearch.securityanalytics.threatIntel.service.ThreatIntelFeedDataService;
import org.opensearch.securityanalytics.threatIntel.util.ThreatIntelFeedParser;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.sts.model.StsException;

public class STIX2IOCFetchService {
    private final Logger log = LogManager.getLogger(STIX2IOCFetchService.class);
    private final String ENDPOINT_CONFIG_PATH = "/threatIntelFeed/internalAuthEndpoint.txt";
    public final String REGION_REGEX = "^.{1,20}$";
    public final String ROLE_ARN_REGEX = "^arn:aws:iam::\\d{12}:role/[\\w+=,.@-]{1,64}$";
    private Client client;
    private ClusterService clusterService;
    private STIX2IOCConnectorFactory connectorFactory;
    private S3ClientFactory s3ClientFactory;
    private Integer batchSize;
    private String internalAuthEndpoint = "";

    public STIX2IOCFetchService(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
        this.internalAuthEndpoint = this.getEndpoint();
        StsAssumeRoleCredentialsProviderFactory factory = new StsAssumeRoleCredentialsProviderFactory(new StsClientFactory());
        this.s3ClientFactory = new S3ClientFactory(factory, this.internalAuthEndpoint);
        this.connectorFactory = new STIX2IOCConnectorFactory(new InputCodecFactory(), this.s3ClientFactory);
        this.batchSize = (Integer)clusterService.getClusterSettings().get(SecurityAnalyticsSettings.BATCH_SIZE);
    }

    public void onlyIndexIocs(SATIFSourceConfig saTifSourceConfig, List<STIX2IOC> stix2IOCList, ActionListener<STIX2IOCFetchResponse> listener) {
        STIX2IOCFeedStore feedStore = new STIX2IOCFeedStore(this.client, this.clusterService, saTifSourceConfig, listener);
        Instant startTime = Instant.now();
        Throwable exception = null;
        RestStatus restStatus = null;
        try {
            this.log.info("Started IOC index step at {}.", (Object)startTime);
            feedStore.indexIocs(stix2IOCList);
        }
        catch (IllegalArgumentException e) {
            exception = e;
            restStatus = RestStatus.BAD_REQUEST;
        }
        catch (OpenSearchException e) {
            exception = e;
            restStatus = e.status();
        }
        catch (Exception e) {
            exception = e;
            restStatus = RestStatus.INTERNAL_SERVER_ERROR;
        }
        Instant endTime = Instant.now();
        long took = Duration.between(startTime, endTime).toMillis();
        if (exception != null && restStatus != null) {
            String errorText = this.getErrorText(saTifSourceConfig, "index", took);
            this.log.error(errorText, exception);
            listener.onFailure((Exception)((Object)new SecurityAnalyticsException(errorText, restStatus, (Exception)exception)));
        } else {
            this.log.info("IOC index step took {} milliseconds.", (Object)took);
        }
    }

    public void downloadAndIndexIOCs(SATIFSourceConfig saTifSourceConfig, ActionListener<STIX2IOCFetchResponse> listener) {
        S3ConnectorConfig s3ConnectorConfig;
        try {
            s3ConnectorConfig = this.constructS3ConnectorConfig(saTifSourceConfig);
        }
        catch (SecurityAnalyticsException e) {
            listener.onFailure((Exception)((Object)e));
            return;
        }
        Connector<STIX2> s3Connector = this.constructS3Connector(s3ConnectorConfig);
        STIX2IOCFeedStore feedStore = new STIX2IOCFeedStore(this.client, this.clusterService, saTifSourceConfig, listener);
        STIX2IOCConsumer consumer = new STIX2IOCConsumer(this.batchSize, feedStore, UpdateType.REPLACE);
        Instant startTime = Instant.now();
        Throwable exception = null;
        RestStatus restStatus = null;
        try {
            this.log.info("Started IOC download step at {}.", (Object)startTime);
            s3Connector.load((Consumer)consumer);
        }
        catch (RuntimeJsonMappingException | IllegalArgumentException | ConnectorParsingException e) {
            exception = e;
            restStatus = RestStatus.BAD_REQUEST;
        }
        catch (S3Exception | StsException e) {
            exception = e;
            restStatus = RestStatus.fromCode((int)e.statusCode());
        }
        catch (AmazonServiceException e) {
            exception = e;
            restStatus = RestStatus.fromCode((int)e.getStatusCode());
        }
        catch (SdkClientException | SdkException e) {
            exception = e;
            restStatus = RestStatus.FORBIDDEN;
        }
        catch (Exception e) {
            exception = e;
            restStatus = RestStatus.INTERNAL_SERVER_ERROR;
        }
        Instant endTime = Instant.now();
        long took = Duration.between(startTime, endTime).toMillis();
        if (exception != null && restStatus != null) {
            String errorText = this.getErrorText(saTifSourceConfig, "download", took);
            this.log.error(errorText, exception);
            listener.onFailure((Exception)((Object)new SecurityAnalyticsException(errorText, restStatus, (Exception)exception)));
            return;
        }
        this.log.info("IOC download step took {} milliseconds.", (Object)took);
        startTime = Instant.now();
        try {
            this.log.info("Started IOC flush at {}.", (Object)startTime);
            consumer.flushIOCs();
        }
        catch (IllegalArgumentException e) {
            exception = e;
            restStatus = RestStatus.BAD_REQUEST;
        }
        catch (OpenSearchException e) {
            exception = e;
            restStatus = e.status();
        }
        catch (Exception e) {
            exception = e;
            restStatus = RestStatus.INTERNAL_SERVER_ERROR;
        }
        endTime = Instant.now();
        took = Duration.between(startTime, endTime).toMillis();
        if (exception != null && restStatus != null) {
            String errorText = this.getErrorText(saTifSourceConfig, "index", took);
            this.log.error(errorText, exception);
            listener.onFailure((Exception)((Object)new SecurityAnalyticsException(errorText, restStatus, (Exception)exception)));
        } else {
            this.log.info("IOC flush step took {} milliseconds.", (Object)took);
        }
    }

    public void testS3Connection(S3ConnectorConfig s3ConnectorConfig, ActionListener<TestS3ConnectionResponse> listener) {
        if (this.internalAuthEndpoint.isEmpty()) {
            this.testS3ClientConnection(s3ConnectorConfig, listener);
        } else {
            this.testAmazonS3Connection(s3ConnectorConfig, listener);
        }
    }

    private void testS3ClientConnection(S3ConnectorConfig s3ConnectorConfig, ActionListener<TestS3ConnectionResponse> listener) {
        try {
            S3Connector connector = (S3Connector)this.constructS3Connector(s3ConnectorConfig);
            HeadObjectResponse response = connector.testS3Connection(s3ConnectorConfig);
            listener.onResponse((Object)new TestS3ConnectionResponse(RestStatus.fromCode((int)response.sdkHttpResponse().statusCode()), ""));
        }
        catch (NoSuchKeyException noSuchKeyException) {
            this.log.error("S3Client connection test failed with NoSuchKeyException: ", (Throwable)noSuchKeyException);
            listener.onResponse((Object)new TestS3ConnectionResponse(RestStatus.fromCode((int)noSuchKeyException.statusCode()), noSuchKeyException.awsErrorDetails().errorMessage()));
        }
        catch (S3Exception s3Exception) {
            this.log.error("S3Client connection test failed with S3Exception: ", (Throwable)s3Exception);
            listener.onResponse((Object)new TestS3ConnectionResponse(RestStatus.fromCode((int)s3Exception.statusCode()), "Resource not found."));
        }
        catch (StsException stsException) {
            this.log.error("S3Client connection test failed with StsException: ", (Throwable)stsException);
            listener.onResponse((Object)new TestS3ConnectionResponse(RestStatus.fromCode((int)stsException.statusCode()), stsException.awsErrorDetails().errorMessage()));
        }
        catch (SdkException sdkException) {
            this.log.error("S3Client connection test failed with SdkException: ", (Throwable)sdkException);
            listener.onResponse((Object)new TestS3ConnectionResponse(RestStatus.FORBIDDEN, "Resource not found."));
        }
        catch (Exception e) {
            this.log.error("S3Client connection test failed with error: ", (Throwable)e);
            listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap(e)));
        }
    }

    private void testAmazonS3Connection(S3ConnectorConfig s3ConnectorConfig, ActionListener<TestS3ConnectionResponse> listener) {
        try {
            S3Connector connector = (S3Connector)this.constructS3Connector(s3ConnectorConfig);
            boolean response = connector.testAmazonS3Connection(s3ConnectorConfig);
            listener.onResponse((Object)new TestS3ConnectionResponse(response ? RestStatus.OK : RestStatus.FORBIDDEN, ""));
        }
        catch (AmazonServiceException e) {
            this.log.error("AmazonS3 connection test failed with AmazonServiceException: ", (Throwable)e);
            listener.onResponse((Object)new TestS3ConnectionResponse(RestStatus.fromCode((int)e.getStatusCode()), e.getErrorMessage()));
        }
        catch (SdkClientException e) {
            this.log.error("AmazonS3 connection test failed with SdkClientException: ", (Throwable)e);
            listener.onResponse((Object)new TestS3ConnectionResponse(RestStatus.FORBIDDEN, "Resource not found."));
        }
        catch (Exception e) {
            this.log.error("AmazonS3 connection test failed with error: ", (Throwable)e);
            listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap(e)));
        }
    }

    private Connector<STIX2> constructS3Connector(S3ConnectorConfig s3ConnectorConfig) {
        FeedConfiguration feedConfiguration = new FeedConfiguration(IOCSchema.STIX2, InputCodecSchema.ND_JSON, s3ConnectorConfig);
        if (this.internalAuthEndpoint.isEmpty()) {
            return this.constructS3ClientConnector(feedConfiguration);
        }
        return this.constructAmazonS3Connector(feedConfiguration);
    }

    private Connector<STIX2> constructS3ClientConnector(FeedConfiguration feedConfiguration) {
        return this.connectorFactory.doCreate(feedConfiguration);
    }

    private Connector<STIX2> constructAmazonS3Connector(FeedConfiguration feedConfiguration) {
        List<String> clusterTuple = List.of(this.clusterService.getClusterName().value().split(":"));
        return this.connectorFactory.createAmazonS3Connector(feedConfiguration, clusterTuple);
    }

    private S3ConnectorConfig constructS3ConnectorConfig(SATIFSourceConfig saTifSourceConfig) {
        S3ConnectorConfig s3ConnectorConfig = new S3ConnectorConfig(((S3Source)saTifSourceConfig.getSource()).getBucketName(), ((S3Source)saTifSourceConfig.getSource()).getObjectKey(), ((S3Source)saTifSourceConfig.getSource()).getRegion(), ((S3Source)saTifSourceConfig.getSource()).getRoleArn());
        this.validateS3ConnectorConfig(s3ConnectorConfig);
        return s3ConnectorConfig;
    }

    private void validateS3ConnectorConfig(S3ConnectorConfig s3ConnectorConfig) {
        if (s3ConnectorConfig.getRoleArn() == null || !s3ConnectorConfig.getRoleArn().matches("^arn:aws:iam::\\d{12}:role/[\\w+=,.@-]{1,64}$")) {
            throw new SecurityAnalyticsException("Role arn is empty or malformed.", RestStatus.BAD_REQUEST, new IllegalArgumentException());
        }
        if (s3ConnectorConfig.getRegion() == null || !s3ConnectorConfig.getRegion().matches("^.{1,20}$")) {
            throw new SecurityAnalyticsException("Region is empty or malformed.", RestStatus.BAD_REQUEST, new IllegalArgumentException());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getEndpoint() {
        try (InputStream is = TIFJobParameterService.class.getResourceAsStream("/threatIntelFeed/internalAuthEndpoint.txt");){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                string = reader.lines().map(String::trim).collect(Collectors.joining());
            }
            return string;
        }
        catch (Exception e) {
            this.log.debug(String.format("Resource file [%s] doesn't exist.", "/threatIntelFeed/internalAuthEndpoint.txt"));
            return "";
        }
    }

    public void downloadFromUrlAndIndexIOCs(SATIFSourceConfig saTifSourceConfig, ActionListener<STIX2IOCFetchResponse> listener) {
        UrlDownloadSource source = (UrlDownloadSource)saTifSourceConfig.getSource();
        switch (source.getFeedFormat()) {
            case "csv": {
                try (CSVParser reader = ThreatIntelFeedParser.getThreatIntelFeedReaderCSV(source.getUrl());){
                    CSVParser noHeaderReader = ThreatIntelFeedParser.getThreatIntelFeedReaderCSV(source.getUrl());
                    boolean notFound = true;
                    while (notFound) {
                        CSVRecord hasHeaderRecord = (CSVRecord)reader.iterator().next();
                        if (hasHeaderRecord.values().length == 1 && "".equals(hasHeaderRecord.values()[0]) || hasHeaderRecord.get(0).charAt(0) == '#' || hasHeaderRecord.get(0).charAt(0) == ' ') {
                            noHeaderReader.iterator().next();
                            continue;
                        }
                        notFound = false;
                    }
                    if (source.hasCsvHeader()) {
                        this.parseAndSaveThreatIntelFeedDataCSV(reader.iterator(), saTifSourceConfig, listener);
                    } else {
                        this.parseAndSaveThreatIntelFeedDataCSV(noHeaderReader.iterator(), saTifSourceConfig, listener);
                    }
                    break;
                }
                catch (Exception e) {
                    this.log.error("Failed to download the IoCs in CSV format for source " + saTifSourceConfig.getId());
                    listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap(e)));
                    return;
                }
            }
            default: {
                this.log.error("unsupported feed format for url download:" + source.getFeedFormat());
                listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap(new UnsupportedOperationException("unsupported feed format for url download:" + source.getFeedFormat()))));
            }
        }
    }

    private void parseAndSaveThreatIntelFeedDataCSV(Iterator<CSVRecord> iterator, SATIFSourceConfig saTifSourceConfig, ActionListener<STIX2IOCFetchResponse> listener) throws IOException {
        ArrayList bulkRequestList = new ArrayList();
        UrlDownloadSource source = (UrlDownloadSource)saTifSourceConfig.getSource();
        ArrayList<STIX2IOC> iocs = new ArrayList<STIX2IOC>();
        while (iterator.hasNext()) {
            CSVRecord record = iterator.next();
            String iocType = saTifSourceConfig.getIocTypes().stream().findFirst().orElse(null);
            Integer colNum = source.getCsvIocValueColumnNo();
            String iocValue = record.values()[colNum].split(" ")[0];
            if (iocType.equalsIgnoreCase("ipv4-addr") && !ThreatIntelFeedDataService.isValidIp(iocValue)) {
                this.log.info("Invalid IP address, skipping this ioc record: {}", (Object)iocValue);
                continue;
            }
            Instant now = Instant.now();
            STIX2IOC stix2IOC = new STIX2IOC(UUID.randomUUID().toString(), UUID.randomUUID().toString(), iocType == null ? new IOCType("ipv4-addr") : new IOCType(iocType), iocValue, "high", now, now, "", Collections.emptyList(), "", saTifSourceConfig.getId(), saTifSourceConfig.getName(), 1L);
            iocs.add(stix2IOC);
        }
        STIX2IOCFeedStore feedStore = new STIX2IOCFeedStore(this.client, this.clusterService, saTifSourceConfig, listener);
        feedStore.indexIocs(iocs);
    }

    private String getErrorText(SATIFSourceConfig saTifSourceConfig, String action, long duration) {
        return String.format("Failed to %s IOCs from source config '%s' with ID %s after %s milliseconds: ", action, saTifSourceConfig.getName(), saTifSourceConfig.getId(), duration);
    }

    public static class STIX2IOCFetchResponse
    extends ActionResponse
    implements ToXContentObject {
        public static String IOCS_FIELD = "iocs";
        public static String TOTAL_FIELD = "total";
        public static String DURATION_FIELD = "took";
        private List<STIX2IOCDto> iocs = new ArrayList<STIX2IOCDto>();
        private long duration;

        public STIX2IOCFetchResponse(List<STIX2IOC> iocs, long duration) {
            iocs.forEach(ioc -> this.iocs.add(new STIX2IOCDto((STIX2IOC)((Object)ioc))));
            this.duration = duration;
        }

        public STIX2IOCFetchResponse(StreamInput sin) throws IOException {
            this(sin.readList(STIX2IOC::new), sin.readLong());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.iocs);
            out.writeLong(this.duration);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(TOTAL_FIELD, this.iocs.size()).field(DURATION_FIELD, this.duration).endObject();
        }

        public List<STIX2IOCDto> getIocs() {
            return this.iocs;
        }
    }
}

