/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.resthandler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.securityanalytics.action.AckAlertsAction;
import org.opensearch.securityanalytics.action.AckAlertsRequest;

public class RestAcknowledgeAlertsAction
extends BaseRestHandler {
    public String getName() {
        return "ack_detector_alerts_action";
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.getDefault(), "%s/{%s}/_acknowledge/alerts", "/_plugins/_security_analytics/detectors", "detector_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient) throws IOException {
        String detectorId = request.param("detector_id");
        List<String> alertIds = this.getAlertIds(request.contentParser());
        AckAlertsRequest ackAlertsRequest = new AckAlertsRequest(detectorId, alertIds);
        return channel -> nodeClient.execute((ActionType)AckAlertsAction.INSTANCE, (ActionRequest)ackAlertsRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private List<String> getAlertIds(XContentParser xcp) throws IOException {
        ArrayList<String> ids = new ArrayList<String>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            if (!fieldName.equals("alerts")) continue;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                ids.add(xcp.text());
            }
        }
        return ids;
    }
}

