/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Locale;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.securityanalytics.commons.model.IOCType;
import org.opensearch.securityanalytics.model.STIX2IOCDto;

public class DetailedSTIX2IOCDto
implements Writeable,
ToXContentObject {
    public static final String NUM_FINDINGS_FIELD = "num_findings";
    STIX2IOCDto ioc;
    private long numFindings = 0L;

    public DetailedSTIX2IOCDto(STIX2IOCDto ioc, long numFindings) {
        this.ioc = ioc;
        this.numFindings = numFindings;
    }

    public DetailedSTIX2IOCDto(StreamInput sin) throws IOException {
        this(STIX2IOCDto.readFrom(sin), sin.readLong());
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.ioc.writeTo(out);
        out.writeLong(this.numFindings);
    }

    public static DetailedSTIX2IOCDto parse(XContentParser xcp, String id, Long version) throws IOException {
        long numFindings = 0L;
        if (id == null) {
            id = "";
        }
        if (version == null) {
            version = 1L;
        }
        String name = null;
        IOCType type = null;
        String value = null;
        String severity = null;
        Instant created = null;
        Instant modified = null;
        String description = null;
        ArrayList<String> labels = new ArrayList<String>();
        String specVersion = null;
        String feedId = null;
        String feedName = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block32: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "id": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block32;
                    id = xcp.text();
                    continue block32;
                }
                case "version": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block32;
                    version = xcp.longValue();
                    continue block32;
                }
                case "name": {
                    name = xcp.text();
                    continue block32;
                }
                case "type": {
                    type = new IOCType(xcp.text().toLowerCase(Locale.ROOT));
                    continue block32;
                }
                case "value": {
                    value = xcp.text();
                    continue block32;
                }
                case "severity": {
                    severity = xcp.text();
                    continue block32;
                }
                case "created": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        created = null;
                        continue block32;
                    }
                    if (xcp.currentToken().isValue()) {
                        if (xcp.currentToken() == XContentParser.Token.VALUE_STRING) {
                            created = Instant.parse(xcp.text());
                            continue block32;
                        }
                        if (xcp.currentToken() != XContentParser.Token.VALUE_NUMBER) continue block32;
                        created = Instant.ofEpochMilli(xcp.longValue());
                        continue block32;
                    }
                    XContentParserUtils.throwUnknownToken((XContentParser.Token)xcp.currentToken(), (XContentLocation)xcp.getTokenLocation());
                    created = null;
                    continue block32;
                }
                case "modified": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        modified = null;
                        continue block32;
                    }
                    if (xcp.currentToken().isValue()) {
                        if (xcp.currentToken() == XContentParser.Token.VALUE_STRING) {
                            modified = Instant.parse(xcp.text());
                            continue block32;
                        }
                        if (xcp.currentToken() != XContentParser.Token.VALUE_NUMBER) continue block32;
                        modified = Instant.ofEpochMilli(xcp.longValue());
                        continue block32;
                    }
                    XContentParserUtils.throwUnknownToken((XContentParser.Token)xcp.currentToken(), (XContentLocation)xcp.getTokenLocation());
                    modified = null;
                    continue block32;
                }
                case "description": {
                    description = xcp.text();
                    continue block32;
                }
                case "labels": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        String entry = xcp.textOrNull();
                        if (entry == null) continue;
                        labels.add(entry);
                    }
                    continue block32;
                }
                case "spec_version": {
                    specVersion = xcp.text();
                    continue block32;
                }
                case "feed_id": {
                    feedId = xcp.text();
                    continue block32;
                }
                case "feed_name": {
                    feedName = xcp.text();
                    continue block32;
                }
                case "num_findings": {
                    numFindings = xcp.longValue();
                    continue block32;
                }
            }
            xcp.skipChildren();
        }
        return new DetailedSTIX2IOCDto(new STIX2IOCDto(id, name, type, value, severity, created, modified, description, labels, specVersion, feedId, feedName, version), numFindings);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("id", this.ioc.getId()).field("name", this.ioc.getName()).field("type", this.ioc.getType().toString()).field("value", this.ioc.getValue()).field("severity", this.ioc.getSeverity()).timeField("created", (Object)this.ioc.getCreated()).timeField("modified", (Object)this.ioc.getModified()).field("description", this.ioc.getDescription()).field("labels", this.ioc.getLabels()).field("feed_id", this.ioc.getFeedId()).field("feed_name", this.ioc.getFeedName()).field("spec_version", this.ioc.getSpecVersion()).field("version", this.ioc.getVersion()).field(NUM_FINDINGS_FIELD, this.numFindings).endObject();
    }

    public STIX2IOCDto getIoc() {
        return this.ioc;
    }

    public void setIoc(STIX2IOCDto ioc) {
        this.ioc = ioc;
    }

    public long getNumFindings() {
        return this.numFindings;
    }

    public void setNumFindings(Long numFindings) {
        this.numFindings = numFindings;
    }
}

