/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import org.opensearch.commons.alerting.model.DocLevelQuery;
import org.opensearch.commons.alerting.model.FindingDocument;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

public class FindingDto
implements ToXContentObject,
Writeable {
    private static final String DETECTOR_ID_FIELD = "detectorId";
    private static final String FINDING_ID_FIELD = "id";
    private static final String RELATED_DOC_IDS_FIELD = "related_doc_ids";
    private static final String INDEX_FIELD = "index";
    private static final String QUERIES_FIELD = "queries";
    private static final String TIMESTAMP_FIELD = "timestamp";
    private static final String DOCUMENTS_LIST = "document_list";
    private String id;
    private List<String> relatedDocIds;
    private String index;
    private List<DocLevelQuery> docLevelQueries;
    private Instant timestamp;
    private List<FindingDocument> documents;
    private String detectorId;

    public FindingDto(String detectorId, String id, List<String> relatedDocIds, String index, List<DocLevelQuery> docLevelQueries, Instant timestamp, List<FindingDocument> documents) {
        this.detectorId = detectorId;
        this.id = id;
        this.relatedDocIds = relatedDocIds;
        this.index = index;
        this.docLevelQueries = docLevelQueries;
        this.timestamp = timestamp;
        this.documents = documents;
    }

    public FindingDto(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readString(), sin.readStringList(), sin.readString(), sin.readList(DocLevelQuery::readFrom), sin.readInstant(), sin.readList(FindingDocument::new));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(DETECTOR_ID_FIELD, this.detectorId).field(FINDING_ID_FIELD, this.id).field(RELATED_DOC_IDS_FIELD, this.relatedDocIds).field(INDEX_FIELD, this.index).field(QUERIES_FIELD, this.docLevelQueries).field(TIMESTAMP_FIELD, this.timestamp.toEpochMilli()).field(DOCUMENTS_LIST, this.documents);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.detectorId);
        out.writeString(this.id);
        out.writeStringCollection(this.relatedDocIds);
        out.writeString(this.index);
        out.writeCollection(this.docLevelQueries);
        out.writeInstant(this.timestamp);
        out.writeList(this.documents);
    }

    public String getId() {
        return this.id;
    }

    public List<String> getRelatedDocIds() {
        return this.relatedDocIds;
    }

    public String getIndex() {
        return this.index;
    }

    public List<DocLevelQuery> getDocLevelQueries() {
        return this.docLevelQueries;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public List<FindingDocument> getDocuments() {
        return this.documents;
    }

    public String getDetectorId() {
        return this.detectorId;
    }
}

