/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.core.temperature;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature.ShardProfileSummary;
import org.opensearch.performanceanalyzer.rca.store.rca.hotshard.IndexShardKey;

public class ShardStore {
    private static final Logger LOG = LogManager.getLogger(ShardStore.class);
    Map<IndexShardKey, ShardProfileSummary> shardToShardProfileMap = new ConcurrentHashMap<IndexShardKey, ShardProfileSummary>();

    @Nonnull
    public synchronized ShardProfileSummary getOrCreateIfAbsent(IndexShardKey indexShardKey) {
        ShardProfileSummary shardProfileSummary = this.shardToShardProfileMap.get(indexShardKey);
        if (shardProfileSummary == null) {
            shardProfileSummary = new ShardProfileSummary(indexShardKey.getIndexName(), indexShardKey.getShardId());
            this.shardToShardProfileMap.put(indexShardKey, shardProfileSummary);
        }
        return shardProfileSummary;
    }
}

