/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.api.flow_units;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.grpc.FlowUnitMessage;
import org.opensearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import org.opensearch.performanceanalyzer.rca.framework.api.persist.JooqFieldValue;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.HotResourceSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.GenericFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.core.GenericSummary;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;

public class ResourceFlowUnit<T extends GenericSummary>
extends GenericFlowUnit {
    private static final Logger LOG = LogManager.getLogger(ResourceFlowUnit.class);
    public static final String RCA_TABLE_NAME = "RCA";
    private ResourceContext resourceContext = null;
    private T summary = null;
    private boolean persistSummary = false;

    public ResourceFlowUnit(long timeStamp) {
        super(timeStamp);
    }

    public ResourceFlowUnit(long timeStamp, ResourceContext context, T summary, boolean persistSummary) {
        super(timeStamp);
        this.resourceContext = context;
        this.summary = summary;
        this.empty = false;
        this.persistSummary = persistSummary;
    }

    public ResourceFlowUnit(long timeStamp, ResourceContext context, T summary) {
        this(timeStamp, context, summary, false);
    }

    public static ResourceFlowUnit<? extends GenericSummary> generic() {
        return new ResourceFlowUnit(System.currentTimeMillis());
    }

    public ResourceContext getResourceContext() {
        return this.resourceContext;
    }

    public void setResourceContext(ResourceContext context) {
        this.resourceContext = context;
    }

    public boolean hasResourceSummary() {
        return this.summary != null;
    }

    public GenericSummary getPersistableSummary() {
        return this.summary;
    }

    public T getSummary() {
        return this.summary;
    }

    public void setSummary(T summary) {
        this.summary = summary;
    }

    public void setPersistSummary(boolean persistSummary) {
        this.persistSummary = persistSummary;
    }

    public boolean isSummaryPersistable() {
        return this.persistSummary;
    }

    @Override
    public FlowUnitMessage buildFlowUnitMessage(String graphNode, InstanceDetails.Id node) {
        FlowUnitMessage.Builder messageBuilder = FlowUnitMessage.newBuilder();
        messageBuilder.setGraphNode(graphNode);
        messageBuilder.setNode(node.toString());
        messageBuilder.setTimeStamp(System.currentTimeMillis());
        if (this.resourceContext != null) {
            messageBuilder.setResourceContext(this.resourceContext.buildContextMessage());
        }
        if (this.summary != null) {
            ((GenericSummary)this.summary).buildSummaryMessageAndAddToFlowUnit(messageBuilder);
        }
        return messageBuilder.build();
    }

    public static <T extends GenericSummary> ResourceFlowUnit<T> buildFlowUnitFromWrapper(FlowUnitMessage message) {
        if (message.hasResourceContext()) {
            ResourceContext newContext = ResourceContext.buildResourceContextFromMessage(message.getResourceContext());
            GenericSummary newSummary = null;
            try {
                switch (message.getSummaryOneofCase()) {
                    case HOTRESOURCESUMMARY: {
                        newSummary = HotResourceSummary.buildHotResourceSummaryFromMessage(message.getHotResourceSummary());
                        break;
                    }
                    case HOTNODESUMMARY: {
                        newSummary = HotNodeSummary.buildHotNodeSummaryFromMessage(message.getHotNodeSummary());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            catch (Exception e) {
                LOG.error("RCA: casting to wrong summary type when de-serializing this flowunit:[{}]", (Object)message, (Object)e);
            }
            return new ResourceFlowUnit<HotResourceSummary>(message.getTimeStamp(), newContext, (HotResourceSummary)newSummary);
        }
        return new ResourceFlowUnit<T>(message.getTimeStamp());
    }

    public List<Field<?>> getSqlSchema() {
        ArrayList schema = new ArrayList();
        if (!this.isEmpty()) {
            schema.add(ResourceFlowUnitFieldValue.TIMESTAMP_FIELD.getField());
            schema.add(ResourceFlowUnitFieldValue.RCA_NAME_FILELD.getField());
            schema.add(ResourceFlowUnitFieldValue.STATE_NAME_FILELD.getField());
        }
        return schema;
    }

    public List<Object> getSqlValue(String rcaName) {
        ArrayList<Object> value = new ArrayList<Object>();
        if (!this.isEmpty()) {
            value.add(this.getTimeStamp());
            value.add(rcaName);
            value.addAll(this.getResourceContext().getSqlValue());
        }
        return value;
    }

    public String toString() {
        return this.getTimeStamp() + ": " + String.valueOf(this.resourceContext) + " :: " + String.valueOf(this.summary);
    }

    public static enum ResourceFlowUnitFieldValue implements JooqFieldValue
    {
        TIMESTAMP_FIELD("timestamp", Long.class),
        RCA_NAME_FILELD("rca_name", String.class),
        STATE_NAME_FILELD("state", String.class);

        private String name;
        private Class<?> clazz;

        private ResourceFlowUnitFieldValue(String name, Class<?> clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        public Field<?> getField() {
            return DSL.field((Name)DSL.name((String)this.name), this.clazz);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class SQL_SCHEMA_CONSTANTS {
        public static final String TIMESTAMP_COL_NAME = "timestamp";
        public static final String RCA_COL_NAME = "rca_name";
        public static final String STATE_COL_NAME = "state";
    }
}

