/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.api;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.rca.framework.api.Metric;
import org.opensearch.performanceanalyzer.rca.framework.core.ConnectedComponent;
import org.opensearch.performanceanalyzer.rca.framework.core.Stats;

public abstract class AnalysisGraph {
    private static final Logger LOG = LogManager.getLogger(AnalysisGraph.class);
    private List<Metric> metricList;

    public AnalysisGraph() {
        Stats.clear();
        this.metricList = new ArrayList<Metric>();
    }

    protected void addLeaf(Metric leaf) {
        this.metricList.add(leaf);
        leaf.setAddedToFlowField();
        Stats stats = Stats.getInstance();
        stats.incrementLeavesAddedToAnalysisFlowField();
        ConnectedComponent connectedComponent = new ConnectedComponent(stats.getGraphsCount());
        stats.addNewGraph(connectedComponent);
        leaf.setGraphId(connectedComponent.getGraphId());
        LOG.debug("#rca: adding leafNode: {} with connected component id: {}", (Object)leaf.name(), (Object)leaf.getGraphId());
        LOG.debug("#rca: current connected component id: {}", (Object)connectedComponent.getGraphId());
        for (int i = 0; i < leaf.getGraphId(); ++i) {
            ConnectedComponent connectedComponent1 = stats.getGraphById(i);
            if (connectedComponent1 == null) continue;
            LOG.debug("#rca: graph so far: {}", (Object)connectedComponent1.getGraphId());
        }
    }

    public void validateAndProcess() {
        for (Metric metricNode : this.metricList) {
            LOG.debug("#rca: validateAndProcess: Metric: name {}, graph-id: {}", (Object)metricNode.name(), (Object)metricNode.getGraphId());
            ConnectedComponent connectedComponent = Stats.getInstance().getGraphById(metricNode.getGraphId());
            connectedComponent.addLeafNode(metricNode);
        }
    }

    public abstract void construct();
}

