/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.deciders.jvm.old_gen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.decisionmaker.actions.Action;
import org.opensearch.performanceanalyzer.decisionmaker.actions.ModifyCacheMaxSizeAction;
import org.opensearch.performanceanalyzer.decisionmaker.actions.configs.CacheActionConfig;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.LevelOneActionBuilderConfig;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.OldGenDecisionPolicyConfig;
import org.opensearch.performanceanalyzer.grpc.ResourceEnum;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;

public class LevelOneActionBuilder {
    private final AppContext appContext;
    private final RcaConf rcaConf;
    private final OldGenDecisionPolicyConfig oldGenDecisionPolicyConfig;
    private final LevelOneActionBuilderConfig actionBuilderConfig;
    private final CacheActionConfig cacheActionConfig;
    private final NodeKey nodeKey;
    private final Map<ResourceEnum, ModifyCacheMaxSizeAction> cacheActionMap;

    private LevelOneActionBuilder(NodeKey nodeKey, AppContext appContext, RcaConf rcaConf) {
        this.appContext = appContext;
        this.rcaConf = rcaConf;
        this.oldGenDecisionPolicyConfig = rcaConf.getDeciderConfig().getOldGenDecisionPolicyConfig();
        this.actionBuilderConfig = this.oldGenDecisionPolicyConfig.levelOneActionBuilderConfig();
        this.cacheActionConfig = rcaConf.getCacheActionConfig();
        this.nodeKey = nodeKey;
        this.cacheActionMap = new HashMap<ResourceEnum, ModifyCacheMaxSizeAction>();
        this.registerActions();
    }

    public static LevelOneActionBuilder newBuilder(NodeKey nodeKey, AppContext appContext, RcaConf rcaConf) {
        return new LevelOneActionBuilder(nodeKey, appContext, rcaConf);
    }

    private void addFieldDataCacheAction() {
        double stepSizeInPercent = this.cacheActionConfig.getStepSize(ResourceEnum.FIELD_DATA_CACHE);
        ModifyCacheMaxSizeAction action = ModifyCacheMaxSizeAction.newBuilder(this.nodeKey, ResourceEnum.FIELD_DATA_CACHE, this.appContext, this.rcaConf).increase(false).stepSizeInPercent(stepSizeInPercent * (double)this.actionBuilderConfig.fieldDataCacheStepSize()).build();
        if (action.isActionable()) {
            this.cacheActionMap.put(ResourceEnum.FIELD_DATA_CACHE, action);
        }
    }

    private void addShardRequestCacheAction() {
        double stepSizeInPercent = this.cacheActionConfig.getStepSize(ResourceEnum.SHARD_REQUEST_CACHE);
        ModifyCacheMaxSizeAction action = ModifyCacheMaxSizeAction.newBuilder(this.nodeKey, ResourceEnum.SHARD_REQUEST_CACHE, this.appContext, this.rcaConf).increase(false).stepSizeInPercent(stepSizeInPercent * (double)this.actionBuilderConfig.shardRequestCacheStepSize()).build();
        if (action.isActionable()) {
            this.cacheActionMap.put(ResourceEnum.SHARD_REQUEST_CACHE, action);
        }
    }

    private void registerActions() {
        this.addFieldDataCacheAction();
        this.addShardRequestCacheAction();
    }

    public List<Action> build() {
        ArrayList<Action> actions = new ArrayList<Action>();
        this.cacheActionMap.forEach((cache, action) -> actions.add((Action)action));
        return actions;
    }
}

