/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cache.common.tier;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.opensearch.common.cache.CacheType;
import org.opensearch.common.cache.settings.CacheSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.threadpool.ThreadPool;

public class TieredSpilloverCacheSettings {
    public static final long DEFAULT_DISK_CACHE_SIZE_IN_BYTES = 0x40000000L;
    public static final long MIN_DISK_CACHE_SIZE_IN_BYTES = 0xA00000L;
    public static final Setting.AffixSetting<String> TIERED_SPILLOVER_ONHEAP_STORE_NAME = Setting.suffixKeySetting((String)"tiered_spillover.onheap.store.name", key -> Setting.simpleString((String)key, (String)"", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Setting.AffixSetting<String> TIERED_SPILLOVER_DISK_STORE_NAME = Setting.suffixKeySetting((String)"tiered_spillover.disk.store.name", key -> Setting.simpleString((String)key, (String)"", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Setting.AffixSetting<Boolean> TIERED_SPILLOVER_DISK_CACHE_SETTING = Setting.suffixKeySetting((String)"tiered_spillover.disk.store.enabled", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
    public static final Setting.AffixSetting<Integer> TIERED_SPILLOVER_SEGMENTS = Setting.suffixKeySetting((String)"tiered_spillover.segments", key -> Setting.intSetting((String)key, (int)TieredSpilloverCacheSettings.defaultSegments(), (int)1, k -> {
        if (!CacheSettings.VALID_SEGMENT_COUNT_VALUES.contains(k)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Cache: %s segment count should be power of two up-to 256", "tiered_spillover"));
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Setting.AffixSetting<ByteSizeValue> TIERED_SPILLOVER_ONHEAP_STORE_SIZE = Setting.suffixKeySetting((String)"tiered_spillover.onheap.store.size", key -> Setting.memorySizeSetting((String)key, (String)"1%", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Setting.AffixSetting<Long> TIERED_SPILLOVER_DISK_STORE_SIZE = Setting.suffixKeySetting((String)"tiered_spillover.disk.store.size", key -> Setting.longSetting((String)key, (long)0x40000000L, (long)0xA00000L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    private static final Setting.AffixSetting<TimeValue> TIERED_SPILLOVER_DISK_TOOK_TIME_THRESHOLD = Setting.suffixKeySetting((String)"tiered_spillover.disk.store.policies.took_time.threshold", key -> Setting.timeSetting((String)key, (TimeValue)new TimeValue(10L, TimeUnit.MILLISECONDS), (TimeValue)TimeValue.ZERO, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
    public static final Map<CacheType, Setting<TimeValue>> TOOK_TIME_POLICY_CONCRETE_SETTINGS_MAP;
    public static final Map<CacheType, Setting<Boolean>> DISK_CACHE_ENABLED_SETTING_MAP;

    public static int defaultSegments() {
        int defaultSegmentCount = ThreadPool.searchThreadPoolSize((int)Runtime.getRuntime().availableProcessors());
        Iterator iterator = CacheSettings.VALID_SEGMENT_COUNT_VALUES.iterator();
        while (iterator.hasNext()) {
            int segmentValue = (Integer)iterator.next();
            if (defaultSegmentCount > segmentValue) continue;
            return segmentValue;
        }
        return (Integer)CacheSettings.VALID_SEGMENT_COUNT_VALUES.get(CacheSettings.VALID_SEGMENT_COUNT_VALUES.size() - 1);
    }

    TieredSpilloverCacheSettings() {
    }

    static {
        HashMap<CacheType, Setting<TimeValue>> concreteTookTimePolicySettingMap = new HashMap<CacheType, Setting<TimeValue>>();
        HashMap<CacheType, Setting<Boolean>> diskCacheSettingMap = new HashMap<CacheType, Setting<Boolean>>();
        for (CacheType cacheType : CacheType.values()) {
            concreteTookTimePolicySettingMap.put(cacheType, (Setting<TimeValue>)TIERED_SPILLOVER_DISK_TOOK_TIME_THRESHOLD.getConcreteSettingForNamespace(cacheType.getSettingPrefix()));
            diskCacheSettingMap.put(cacheType, (Setting<Boolean>)TIERED_SPILLOVER_DISK_CACHE_SETTING.getConcreteSettingForNamespace(cacheType.getSettingPrefix()));
        }
        TOOK_TIME_POLICY_CONCRETE_SETTINGS_MAP = concreteTookTimePolicySettingMap;
        DISK_CACHE_ENABLED_SETTING_MAP = diskCacheSettingMap;
    }
}

