/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.chunker;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensearch.neuralsearch.processor.chunker.Chunker;
import org.opensearch.neuralsearch.processor.chunker.ChunkerParameterParser;

public final class DelimiterChunker
implements Chunker {
    public static final String ALGORITHM_NAME = "delimiter";
    public static final String DELIMITER_FIELD = "delimiter";
    public static final String DEFAULT_DELIMITER = "\n\n";
    private String delimiter;

    public DelimiterChunker(Map<String, Object> parameters) {
        this.parseParameters(parameters);
    }

    @Override
    public void parseParameters(Map<String, Object> parameters) {
        this.delimiter = ChunkerParameterParser.parseStringWithDefault(parameters, "delimiter", DEFAULT_DELIMITER);
    }

    @Override
    public List<String> chunk(String content, Map<String, Object> runtimeParameters) {
        int runtimeMaxChunkLimit = ChunkerParameterParser.parseInteger(runtimeParameters, "max_chunk_limit");
        int chunkStringCount = ChunkerParameterParser.parseInteger(runtimeParameters, "chunk_string_count");
        ArrayList<String> chunkResult = new ArrayList<String>();
        int start = 0;
        int nextDelimiterPosition = content.indexOf(this.delimiter);
        while (nextDelimiterPosition != -1 && !Chunker.checkRunTimeMaxChunkLimit(chunkResult.size(), runtimeMaxChunkLimit, chunkStringCount)) {
            int end = nextDelimiterPosition + this.delimiter.length();
            chunkResult.add(content.substring(start, end));
            start = end;
            nextDelimiterPosition = content.indexOf(this.delimiter, start);
        }
        if (start < content.length()) {
            chunkResult.add(content.substring(start));
        }
        return chunkResult;
    }
}

