/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.markerlayer.ButtonMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageMarker
extends ButtonMarker {
    public URL imageUrl;

    public ImageMarker(LatLon ll, URL imageUrl, MarkerLayer parentLayer, double time, double offset) {
        super(ll, "photo", parentLayer, time, offset);
        this.imageUrl = imageUrl;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        JPanel p = new JPanel(new BorderLayout());
        JScrollPane scroll = new JScrollPane(new JLabel(ImageMarker.loadScaledImage(this.imageUrl, 580)));
        JViewport vp = scroll.getViewport();
        p.add((Component)scroll, "Center");
        JToggleButton scale = new JToggleButton(ImageProvider.get("misc", "rectangle"));
        JPanel p2 = new JPanel();
        p2.add(scale);
        p.add((Component)p2, "South");
        scale.addActionListener(ev1 -> {
            p.setCursor(Cursor.getPredefinedCursor(3));
            if (scale.getModel().isSelected()) {
                ((JLabel)vp.getView()).setIcon(ImageMarker.loadScaledImage(this.imageUrl, Math.max(vp.getWidth(), vp.getHeight())));
            } else {
                ((JLabel)vp.getView()).setIcon(new ImageIcon(this.imageUrl));
            }
            p.setCursor(Cursor.getDefaultCursor());
        });
        scale.setSelected(true);
        JOptionPane pane = new JOptionPane(p, -1);
        if (!GraphicsEnvironment.isHeadless()) {
            JDialog dlg = pane.createDialog(MainApplication.getMainFrame(), this.imageUrl.toString());
            dlg.setModal(false);
            dlg.toFront();
            dlg.setVisible(true);
        }
    }

    private static Icon loadScaledImage(URL u, int maxSize) {
        int h;
        Image img = new ImageIcon(u).getImage();
        int w = img.getWidth(null);
        if (w > (h = img.getHeight(null))) {
            h = (int)Math.round((double)maxSize * ((double)h / (double)w));
            w = maxSize;
        } else {
            w = (int)Math.round((double)maxSize * ((double)w / (double)h));
            h = maxSize;
        }
        return new ImageIcon(img.getScaledInstance(w, h, 4));
    }

    @Override
    public WayPoint convertToWayPoint() {
        WayPoint wpt = super.convertToWayPoint();
        GpxLink link = new GpxLink(this.imageUrl.toString());
        link.type = "image";
        wpt.put("meta.links", Collections.singleton(link));
        return wpt;
    }
}

