/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.oauth;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import oauth.signpost.AbstractOAuthConsumer;
import oauth.signpost.AbstractOAuthProvider;
import org.openstreetmap.josm.tools.HttpClient;

public final class SignpostAdapters {
    private SignpostAdapters() {
    }

    static final class HttpResponse
    implements oauth.signpost.http.HttpResponse {
        final HttpClient.Response response;

        HttpResponse(HttpClient.Response response) {
            this.response = response;
        }

        @Override
        public int getStatusCode() {
            return this.response.getResponseCode();
        }

        @Override
        public String getReasonPhrase() {
            return this.response.getResponseMessage();
        }

        @Override
        public InputStream getContent() throws IOException {
            return this.response.getContent();
        }

        @Override
        public Object unwrap() {
            throw new IllegalStateException();
        }
    }

    static final class HttpRequest
    implements oauth.signpost.http.HttpRequest {
        final HttpClient request;

        HttpRequest(HttpClient request) {
            this.request = request;
        }

        @Override
        public void setHeader(String name, String value) {
            this.request.setHeader(name, value);
        }

        @Override
        public String getMethod() {
            return this.request.getRequestMethod();
        }

        @Override
        public String getRequestUrl() {
            return this.request.getURL().toExternalForm();
        }

        @Override
        public String getContentType() {
            return this.request.getRequestHeader("Content-Type");
        }

        @Override
        public String getHeader(String name) {
            return this.request.getRequestHeader(name);
        }

        @Override
        public InputStream getMessagePayload() {
            return null;
        }

        @Override
        public void setRequestUrl(String url) {
            throw new IllegalStateException();
        }

        @Override
        public Map<String, String> getAllHeaders() {
            throw new IllegalStateException();
        }

        @Override
        public Object unwrap() {
            throw new IllegalStateException();
        }
    }

    public static class OAuthConsumer
    extends AbstractOAuthConsumer {
        private static final long serialVersionUID = 1L;

        public OAuthConsumer(String consumerKey, String consumerSecret) {
            super(consumerKey, consumerSecret);
        }

        @Override
        protected HttpRequest wrap(Object request) {
            return new HttpRequest((HttpClient)request);
        }
    }

    public static class OAuthProvider
    extends AbstractOAuthProvider {
        private static final long serialVersionUID = 1L;

        public OAuthProvider(String requestTokenEndpointUrl, String accessTokenEndpointUrl, String authorizationWebsiteUrl) {
            super(requestTokenEndpointUrl, accessTokenEndpointUrl, authorizationWebsiteUrl);
        }

        @Override
        protected HttpRequest createRequest(String endpointUrl) throws Exception {
            return new HttpRequest(HttpClient.create(new URL(endpointUrl), "GET"));
        }

        @Override
        protected HttpResponse sendRequest(oauth.signpost.http.HttpRequest request) throws Exception {
            return new HttpResponse(((HttpRequest)request).request.connect());
        }

        @Override
        protected void closeConnection(oauth.signpost.http.HttpRequest request, oauth.signpost.http.HttpResponse response) throws Exception {
            if (response != null) {
                ((HttpResponse)response).response.disconnect();
            } else if (request != null) {
                ((HttpRequest)request).request.disconnect();
            }
        }
    }
}

