/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.network;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.zaproxy.zap.network.HttpEncoding;

abstract class AbstractStreamHttpEncoding
implements HttpEncoding {
    private static final int BUFFER_SIZE = 2048;
    private final OutputStreamSupplier outputStreamSupplier;
    private final InputStreamSupplier inputStreamSupplier;

    protected AbstractStreamHttpEncoding(OutputStreamSupplier outputStreamSupplier, InputStreamSupplier inputStreamSupplier) {
        this.outputStreamSupplier = outputStreamSupplier;
        this.inputStreamSupplier = inputStreamSupplier;
    }

    @Override
    public byte[] encode(byte[] content) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStream os = this.outputStreamSupplier.get(baos);){
            os.write(content);
        }
        return baos.toByteArray();
    }

    @Override
    public byte[] decode(byte[] content) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(content);
             InputStream is = this.inputStreamSupplier.get(bais);){
            int len;
            byte[] buffer = new byte[2048];
            while ((len = is.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
        }
        return baos.toByteArray();
    }

    protected static interface InputStreamSupplier {
        public InputStream get(ByteArrayInputStream var1) throws IOException;
    }

    protected static interface OutputStreamSupplier {
        public OutputStream get(ByteArrayOutputStream var1) throws IOException;
    }
}

