/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3.xmlrules;

import java.util.StringTokenizer;
import org.apache.commons.digester3.binder.CallMethodBuilder;
import org.apache.commons.digester3.binder.LinkedRuleBuilder;
import org.apache.commons.digester3.binder.RulesBinder;
import org.apache.commons.digester3.xmlrules.AbstractXmlRule;
import org.apache.commons.digester3.xmlrules.PatternStack;
import org.xml.sax.Attributes;

final class CallMethodRule
extends AbstractXmlRule {
    public CallMethodRule(RulesBinder targetRulesBinder, PatternStack patternStack) {
        super(targetRulesBinder, patternStack);
    }

    protected void bindRule(LinkedRuleBuilder linkedRuleBuilder, Attributes attributes) throws Exception {
        String paramTypesStr;
        CallMethodBuilder builder = linkedRuleBuilder.callMethod(attributes.getValue("methodname"));
        int targetOffset = 0;
        String targetOffsetStr = attributes.getValue("targetoffset");
        if (targetOffsetStr != null) {
            targetOffset = Integer.parseInt(targetOffsetStr);
            builder.withTargetOffset(targetOffset);
        }
        builder.useExactMatch("true".equalsIgnoreCase(attributes.getValue("useExactMatch")));
        String paramCountStr = attributes.getValue("paramcount");
        if (paramCountStr != null) {
            int paramCount = Integer.parseInt(attributes.getValue("paramcount"));
            builder.withParamCount(paramCount);
        }
        if ((paramTypesStr = attributes.getValue("paramtypes")) != null && paramTypesStr.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(paramTypesStr, " \t\n\r,");
            String[] paramTypeNames = new String[tokens.countTokens()];
            int counter = 0;
            while (tokens.hasMoreTokens()) {
                paramTypeNames[counter++] = tokens.nextToken();
            }
            builder.withParamTypes(paramTypeNames);
        }
        if ("true".equalsIgnoreCase(attributes.getValue("usingElementBodyAsArgument"))) {
            builder.usingElementBodyAsArgument();
        }
    }
}

