/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants.ciba.channel;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Map;
import org.keycloak.Token;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.grants.ciba.channel.AuthenticationChannelProvider;
import org.keycloak.protocol.oidc.grants.ciba.channel.AuthenticationChannelRequest;
import org.keycloak.protocol.oidc.grants.ciba.channel.CIBAAuthenticationRequest;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.cors.Cors;

public class HttpAuthenticationChannelProvider
implements AuthenticationChannelProvider {
    public static final String AUTHENTICATION_CHANNEL_ID = "authentication_channel_id";
    protected KeycloakSession session;
    protected MultivaluedMap<String, String> formParams;
    protected RealmModel realm;
    protected Map<String, String> clientAuthAttributes;
    protected Cors cors;
    protected final String httpAuthenticationChannelUri;

    public HttpAuthenticationChannelProvider(KeycloakSession session, String httpAuthenticationRequestUri) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.httpAuthenticationChannelUri = httpAuthenticationRequestUri;
    }

    @Override
    public boolean requestAuthentication(CIBAAuthenticationRequest request, String infoUsedByAuthenticator) {
        this.checkAuthenticationChannel();
        ClientModel client = request.getClient();
        try {
            AuthenticationChannelRequest channelRequest = new AuthenticationChannelRequest();
            channelRequest.setScope(request.getScope());
            channelRequest.setBindingMessage(request.getBindingMessage());
            channelRequest.setLoginHint(infoUsedByAuthenticator);
            channelRequest.setConsentRequired(client.isConsentRequired());
            channelRequest.setAcrValues(request.getAcrValues());
            channelRequest.setAdditionalParameters(request.getOtherClaims());
            SimpleHttp simpleHttp = SimpleHttp.doPost((String)this.httpAuthenticationChannelUri, (KeycloakSession)this.session).header("Content-Type", "application/json").json((Object)channelRequest).auth(this.createBearerToken(request, client));
            int status = this.completeDecoupledAuthnRequest(simpleHttp, channelRequest).asStatus();
            if (status == Response.Status.CREATED.getStatusCode()) {
                return true;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Authentication Channel Access failed.", ioe);
        }
        return false;
    }

    private String createBearerToken(CIBAAuthenticationRequest request, ClientModel client) {
        AccessToken bearerToken = new AccessToken();
        bearerToken.type("Bearer");
        bearerToken.issuer(request.getIssuer());
        bearerToken.id(request.getAuthResultId());
        bearerToken.issuedFor(client.getClientId());
        bearerToken.audience(new String[]{request.getIssuer()});
        bearerToken.iat(request.getIat());
        bearerToken.exp(request.getExp());
        bearerToken.subject(request.getSubject());
        return this.session.tokens().encode((Token)bearerToken);
    }

    protected void checkAuthenticationChannel() {
        if (this.httpAuthenticationChannelUri == null) {
            throw new RuntimeException("Authentication Channel Request URI not set properly.");
        }
        if (!this.httpAuthenticationChannelUri.startsWith("http://") && !this.httpAuthenticationChannelUri.startsWith("https://")) {
            throw new RuntimeException("Authentication Channel Request URI not set properly.");
        }
    }

    protected SimpleHttp completeDecoupledAuthnRequest(SimpleHttp simpleHttp, AuthenticationChannelRequest channelRequest) {
        return simpleHttp;
    }

    public void close() {
    }
}

